# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=7
inherit gnustep-base toolchain-funcs

DESCRIPTION="A tool to create .nfont packages for use with gnustep-back-art"
HOMEPAGE="https://packages.debian.org/mknfonts.tool"
SRC_URI="mirror://debian/pool/main/m/${PN}.tool/${PN}.tool_${PV}.orig.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~alpha amd64 ppc ~sparc x86"
IUSE=""

RDEPEND="gnustep-base/gnustep-gui
	>=media-libs/freetype-2.1"
DEPEND="${RDEPEND}"
BDEPEND="virtual/pkgconfig"

PATCHES=(
	"${FILESDIR}"/${PN}-rename.patch
	"${FILESDIR}"/${P}-pkgconfig.patch
)

src_prepare() {
	default

	tc-export PKG_CONFIG

	# Correct link command for --as-needed
	sed -i -e "s/ADDITIONAL_LDFLAGS/ADDITIONAL_TOOL_LIBS/" GNUmakefile || die
}
