# Copyright 1999-2022 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=7

inherit toolchain-funcs

DESCRIPTION="collect network traffic statistics and store them in pcap format"
HOMEPAGE="https://sourceforge.net/projects/sancp/"
SRC_URI="http://www.metre.net/files/${P}.tar.gz
	http://sancp.sourceforge.net/${PN}-1.6.1.fix200511.a.patch
	http://sancp.sourceforge.net/${PN}-1.6.1.fix200511.b.patch
	http://sancp.sourceforge.net/${PN}-1.6.1.fix200601.c.patch
	http://sancp.sourceforge.net/${PN}-1.6.1.fix200606.d.patch
	https://dev.gentoo.org/~sam/distfiles/${CATEGORY}/${PN}/${PN}-1.6.1-musl.patch.bz2"

LICENSE="QPL-1.0 GPL-2" # GPL-2 for init script
SLOT="0"
KEYWORDS="~amd64 ~x86"
IUSE="sguil"

RDEPEND="
	acct-group/sancp
	acct-user/sancp
	net-libs/libpcap"
DEPEND="${RDEPEND}"

PATCHES=(
	"${DISTDIR}"/${PN}-1.6.1.fix200511.a.patch
	"${DISTDIR}"/${PN}-1.6.1.fix200511.b.patch
	# bug 138337
	"${DISTDIR}"/${PN}-1.6.1.fix200601.c.patch
	"${DISTDIR}"/${PN}-1.6.1.fix200606.d.patch
	"${FILESDIR}"/${PN}-1.6.1-compiler.patch
	"${FILESDIR}"/${PN}-1.6.1-gcc6.patch
	"${FILESDIR}"/${PN}-1.6.1-extern.patch
	"${WORKDIR}"/${PN}-1.6.1-musl.patch
)

src_compile() {
	tc-export CC CXX
	emake CFLAGS="${CXXFLAGS}"
}

src_install() {
	keepdir /var/log/sancp/
	dodoc docs/CHANGES docs/fields.LIST docs/README docs/SETUP \
		"${FILESDIR}"/sguil_sancp.conf etc/sancp/sancp.conf

	insinto /etc/sancp
	if use sguil ; then
		newins "${FILESDIR}"/sguil_sancp.conf sancp.conf
	else
		doins etc/sancp/sancp.conf
	fi

	dobin sancp

	newinitd "${FILESDIR}"/sancp.rc1 sancp
	newconfd "${FILESDIR}"/sancp.confd sancp
	if use sguil ; then
		sed -i -e /^SANCP_OPTS/s:'sancp':"sguil":g \
			-e s:'-d $LOGDIR/today':"-d /var/lib/sguil/$(hostname)/sancp": \
			"${D}/etc/conf.d/sancp"
	fi

	fowners sancp:sancp /var/log/sancp
	fperms 0770 /var/log/sancp
}
