/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.sql.SQLException;
import org.hsqldb.Trace;

class StringConverter {
    private static final char[] HEXCHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String HEXINDEX = "0123456789abcdef0123456789ABCDEF";

    StringConverter() {
    }

    static byte[] hexToByte(String string) throws SQLException {
        int n = string.length() / 2;
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c;
            int n4;
            if ((n4 = HEXINDEX.indexOf(c = string.charAt(n2++))) == -1) {
                throw Trace.error(7, "hexadecimal string contains non hex character");
            }
            int n5 = (n4 & 0xF) << 4;
            c = string.charAt(n2++);
            n4 = HEXINDEX.indexOf(c);
            byArray[n3] = (byte)(n5 += n4 & 0xF);
            ++n3;
        }
        return byArray;
    }

    static String byteToHex(byte[] byArray) {
        int n = byArray.length;
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        int n2 = 0;
        while (n2 < n) {
            int n3 = byArray[n2] & 0xFF;
            stringBuffer.append(HEXCHAR[n3 >> 4 & 0xF]);
            stringBuffer.append(HEXCHAR[n3 & 0xF]);
            ++n2;
        }
        return stringBuffer.toString();
    }

    static String unicodeToHexString(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeUTF(string);
            dataOutputStream.close();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            return null;
        }
        return StringConverter.byteToHex(byteArrayOutputStream.toByteArray());
    }

    public static String hexStringToUnicode(String string) throws SQLException {
        byte[] byArray = StringConverter.hexToByte(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            return dataInputStream.readUTF();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static StringBuffer unicodeToAscii(String string) {
        if (string == null || string.length() == 0) {
            return new StringBuffer();
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 16);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\\') {
                if (n2 < n - 1 && string.charAt(n2 + 1) == 'u') {
                    stringBuffer.append(c);
                    stringBuffer.append("u005c");
                } else {
                    stringBuffer.append(c);
                }
            } else if (c >= ' ' && c <= '\u007f') {
                stringBuffer.append(c);
            } else {
                stringBuffer.append("\\u");
                stringBuffer.append(HEXCHAR[c >> 12 & 0xF]);
                stringBuffer.append(HEXCHAR[c >> 8 & 0xF]);
                stringBuffer.append(HEXCHAR[c >> 4 & 0xF]);
                stringBuffer.append(HEXCHAR[c & 0xF]);
            }
            ++n2;
        }
        return stringBuffer;
    }

    public static String asciiToUnicode(String string) {
        if (string == null || string.indexOf("\\u") == -1) {
            return string;
        }
        int n = string.length();
        char[] cArray = new char[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            if (c == '\\' && n3 < n - 5) {
                char c2 = string.charAt(n3 + 1);
                if (c2 == 'u') {
                    ++n3;
                    int n4 = HEXINDEX.indexOf(string.charAt(++n3)) << 12;
                    n4 += HEXINDEX.indexOf(string.charAt(++n3)) << 8;
                    n4 += HEXINDEX.indexOf(string.charAt(++n3)) << 4;
                    cArray[n2++] = (char)(n4 += HEXINDEX.indexOf(string.charAt(++n3)));
                } else {
                    cArray[n2++] = c;
                }
            } else {
                cArray[n2++] = c;
            }
            ++n3;
        }
        return new String(cArray, 0, n2);
    }

    public static String inputStreamToString(InputStream inputStream) throws SQLException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        StringWriter stringWriter = new StringWriter();
        int n = 8192;
        char[] cArray = new char[n];
        try {
            int n2;
            while ((n2 = inputStreamReader.read(cArray, 0, n)) != -1) {
                stringWriter.write(cArray, 0, n2);
            }
            stringWriter.close();
            inputStream.close();
        }
        catch (IOException iOException) {
            throw Trace.error(34, iOException.getMessage());
        }
        return stringWriter.toString();
    }

    static String toQuotedString(String string, char c, boolean bl) {
        if (string == null) {
            return "NULL";
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 16).append(c);
        int n2 = 0;
        while (n2 < n) {
            char c2 = string.charAt(n2);
            if (bl && c2 == c) {
                stringBuffer.append(c2);
            }
            stringBuffer.append(c2);
            ++n2;
        }
        return stringBuffer.append(c).toString();
    }
}

