/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef _SOC_QUALCOMM_SC7180_ADDRESS_MAP_H_
#define _SOC_QUALCOMM_SC7180_ADDRESS_MAP_H_

#define AOSS_CC_BASE			0x0C2A0000
#define GCC_BASE			0x00100000
#define QSPI_BASE			0x088DC000
#define TLMM_NORTH_TILE_BASE		0x03900000
#define TLMM_SOUTH_TILE_BASE		0x03D00000
#define TLMM_WEST_TILE_BASE		0x03500000
#define SILVER_PLL_BASE			0x18280000
#define L3_PLL_BASE			0x18284000
#define DISP_CC_BASE			0x0AF00000

/*
 * QUP SERIAL ENGINE BASE ADDRESSES
 */
/* QUPV3_0 */
#define QUP_SERIAL0_BASE		0x00880000
#define QUP_SERIAL1_BASE		0x00884000
#define QUP_SERIAL2_BASE		0x00888000
#define QUP_SERIAL3_BASE		0x0088C000
#define QUP_SERIAL4_BASE		0x00890000
#define QUP_SERIAL5_BASE		0x00894000
#define QUP_WRAP0_BASE			0x008C0000

/* QUPV3_1 */
#define QUP_SERIAL6_BASE		0x00A80000
#define QUP_SERIAL7_BASE		0x00A84000
#define QUP_SERIAL8_BASE		0x00A88000
#define QUP_SERIAL9_BASE		0x00A8C000
#define QUP_SERIAL10_BASE		0x00A90000
#define QUP_SERIAL11_BASE		0x00A94000
#define QUP_WRAP1_BASE			0x00AC0000

/* QUPV3_2 - Dummy Entry */
#define QUP_WRAP2_BASE			0x00000000

/*
 * USB BASE ADDRESSES
 */
#define QFPROM_BASE			0x00780000
#define QUSB_PRIM_PHY_BASE		0x088e3000
#define QUSB_PRIM_PHY_DIG_BASE		0x088e3200
#define QMP_PHY_QSERDES_COM_REG_BASE	0x088e9000
#define QMP_PHY_QSERDES_TX_REG_BASE	0x088e9200
#define QMP_PHY_QSERDES_RX_REG_BASE	0x088e9400
#define QMP_PHY_PCS_REG_BASE		0x088e9c00
#define USB_HOST_DWC3_BASE		0x0a60c100

/* SC7180 QSPI GPIO PINS */
#define QSPI_CLK			GPIO(63)
#define QSPI_DATA_0			GPIO(64)
#define QSPI_DATA_1			GPIO(65)
#define QSPI_CS				GPIO(68)

#define GPIO_FUNC_QSPI_DATA_0		GPIO64_FUNC_QSPI_DATA_0
#define GPIO_FUNC_QSPI_DATA_1		GPIO65_FUNC_QSPI_DATA_1
#define GPIO_FUNC_QSPI_CLK		GPIO63_FUNC_QSPI_CLK

/* SDHC TLMM Registers */
#define SDC1_TLMM_CFG_ADDR		0x03D7A000
#define SDC2_TLMM_CFG_ADDR		0x03D7B000

#endif /*  __SOC_QUALCOMM_SC7180_ADDRESS_MAP_H__ */
