// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.2.0
// - protoc             (unknown)
// source: private/pbsubscribe/subscribe.proto

package pbsubscribe

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// StateChangeSubscriptionClient is the client API for StateChangeSubscription service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type StateChangeSubscriptionClient interface {
	// Subscribe to a topic to receive events when there are changes to the topic.
	//
	// If SubscribeRequest.Index is 0 the event stream will start with one or
	// more snapshot events, followed by an EndOfSnapshot event. Subsequent
	// events will be a live stream of events as they happen.
	//
	// If SubscribeRequest.Index is > 0 it is assumed the client already has a
	// snapshot, and is trying to resume a stream that was disconnected. The
	// client will either receive a NewSnapshotToFollow event, indicating the
	// client view is stale and it must reset its view and prepare for a new
	// snapshot. Or, if no NewSnapshotToFollow event is received, the client
	// view is still fresh, and all events will be the live stream.
	//
	// Subscribe may return a gRPC status error with codes.ABORTED to indicate
	// the client view is now stale due to a change on the server. The client
	// must reset its view and issue a new Subscribe call to restart the stream.
	// This error is used when the server can no longer correctly maintain the
	// stream, for example because the ACL permissions for the token changed, or
	// because the server state was restored from a snapshot.
	// buf:lint:ignore RPC_RESPONSE_STANDARD_NAME
	Subscribe(ctx context.Context, in *SubscribeRequest, opts ...grpc.CallOption) (StateChangeSubscription_SubscribeClient, error)
}

type stateChangeSubscriptionClient struct {
	cc grpc.ClientConnInterface
}

func NewStateChangeSubscriptionClient(cc grpc.ClientConnInterface) StateChangeSubscriptionClient {
	return &stateChangeSubscriptionClient{cc}
}

func (c *stateChangeSubscriptionClient) Subscribe(ctx context.Context, in *SubscribeRequest, opts ...grpc.CallOption) (StateChangeSubscription_SubscribeClient, error) {
	stream, err := c.cc.NewStream(ctx, &StateChangeSubscription_ServiceDesc.Streams[0], "/subscribe.StateChangeSubscription/Subscribe", opts...)
	if err != nil {
		return nil, err
	}
	x := &stateChangeSubscriptionSubscribeClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type StateChangeSubscription_SubscribeClient interface {
	Recv() (*Event, error)
	grpc.ClientStream
}

type stateChangeSubscriptionSubscribeClient struct {
	grpc.ClientStream
}

func (x *stateChangeSubscriptionSubscribeClient) Recv() (*Event, error) {
	m := new(Event)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// StateChangeSubscriptionServer is the server API for StateChangeSubscription service.
// All implementations should embed UnimplementedStateChangeSubscriptionServer
// for forward compatibility
type StateChangeSubscriptionServer interface {
	// Subscribe to a topic to receive events when there are changes to the topic.
	//
	// If SubscribeRequest.Index is 0 the event stream will start with one or
	// more snapshot events, followed by an EndOfSnapshot event. Subsequent
	// events will be a live stream of events as they happen.
	//
	// If SubscribeRequest.Index is > 0 it is assumed the client already has a
	// snapshot, and is trying to resume a stream that was disconnected. The
	// client will either receive a NewSnapshotToFollow event, indicating the
	// client view is stale and it must reset its view and prepare for a new
	// snapshot. Or, if no NewSnapshotToFollow event is received, the client
	// view is still fresh, and all events will be the live stream.
	//
	// Subscribe may return a gRPC status error with codes.ABORTED to indicate
	// the client view is now stale due to a change on the server. The client
	// must reset its view and issue a new Subscribe call to restart the stream.
	// This error is used when the server can no longer correctly maintain the
	// stream, for example because the ACL permissions for the token changed, or
	// because the server state was restored from a snapshot.
	// buf:lint:ignore RPC_RESPONSE_STANDARD_NAME
	Subscribe(*SubscribeRequest, StateChangeSubscription_SubscribeServer) error
}

// UnimplementedStateChangeSubscriptionServer should be embedded to have forward compatible implementations.
type UnimplementedStateChangeSubscriptionServer struct {
}

func (UnimplementedStateChangeSubscriptionServer) Subscribe(*SubscribeRequest, StateChangeSubscription_SubscribeServer) error {
	return status.Errorf(codes.Unimplemented, "method Subscribe not implemented")
}

// UnsafeStateChangeSubscriptionServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to StateChangeSubscriptionServer will
// result in compilation errors.
type UnsafeStateChangeSubscriptionServer interface {
	mustEmbedUnimplementedStateChangeSubscriptionServer()
}

func RegisterStateChangeSubscriptionServer(s grpc.ServiceRegistrar, srv StateChangeSubscriptionServer) {
	s.RegisterService(&StateChangeSubscription_ServiceDesc, srv)
}

func _StateChangeSubscription_Subscribe_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(SubscribeRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(StateChangeSubscriptionServer).Subscribe(m, &stateChangeSubscriptionSubscribeServer{stream})
}

type StateChangeSubscription_SubscribeServer interface {
	Send(*Event) error
	grpc.ServerStream
}

type stateChangeSubscriptionSubscribeServer struct {
	grpc.ServerStream
}

func (x *stateChangeSubscriptionSubscribeServer) Send(m *Event) error {
	return x.ServerStream.SendMsg(m)
}

// StateChangeSubscription_ServiceDesc is the grpc.ServiceDesc for StateChangeSubscription service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var StateChangeSubscription_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "subscribe.StateChangeSubscription",
	HandlerType: (*StateChangeSubscriptionServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Subscribe",
			Handler:       _StateChangeSubscription_Subscribe_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "private/pbsubscribe/subscribe.proto",
}
