--copy_file $MYSQLTEST_VARDIR/std_data/wl12261_dump.zip $MYSQL_TMP_DIR/wl12261_dump.zip
--file_exists $MYSQL_TMP_DIR/wl12261_dump.zip
--exec unzip -qo $MYSQL_TMP_DIR/wl12261_dump.zip -d $MYSQL_TMP_DIR

--echo # Pre-define user u1, which is used in different tests below.
CREATE USER u1@localhost;
GRANT ALL ON db1.* TO u1@localhost;
GRANT CREATE TABLESPACE, PROCESS, SYSTEM_VARIABLES_ADMIN ON *.* TO u1@localhost;
connect (con1, localhost, u1);

--echo # This test run output (.sql) of mysqldump from 5.7, 8.0.12 and 8.0.13
--echo # in 8.0.15.
--echo #
--echo # The .sql files contain notes with tag wl12261 describing the
--echo # modifications done to .sql to make it run on MySQL 8.0.15.
--echo # It basically does two things a) removes ENCRYPTION=y for CVS and
--echo # MEMORY engines. b) Adds a explicit ENCRYPTION='y' for tables
--echo # using encryped general tablespace.
--echo #
--echo # The behavior of executing .sql with following variables would be
--echo # same as the test behavior seen by encryption.* test results.
--echo #
--echo # - Setting table_encryption_privilege_check to true/false.
--echo # - Setting default_table_encryption to true/false.
--echo # - With and without user holding TABLE_ENCRYPTION_ADMIN privilege.
--echo #

CREATE TABLESPACE ts1 ADD DATAFILE 'ts1.ibd';
CREATE TABLESPACE ts2 ADD DATAFILE 'ts2.ibd';
CREATE TABLESPACE ts3 ADD DATAFILE 'ts3.ibd';

--exec $MYSQL test < $MYSQL_TMP_DIR/wl12261_5_7_25.sql
SHOW CREATE DATABASE db1;
SHOW CREATE TABLE db1.i1;
SHOW CREATE TABLE db1.i2;
SHOW CREATE TABLE db1.i3;
SHOW CREATE TABLE db1.i4;
SHOW CREATE TABLE db1.i_ts1;
SHOW CREATE TABLE db1.i_ts2;
SHOW CREATE TABLE db1.i_ts3;
SHOW CREATE TABLE db1.i_part1;
SHOW CREATE TABLE db1.i_part2;
SHOW CREATE TABLE db1.i_part3;
SHOW CREATE TABLE db1.c1;
SHOW CREATE TABLE db1.c2;
SHOW CREATE TABLE db1.c3;
SHOW CREATE TABLE db1.h1;
SHOW CREATE TABLE db1.h2;
SHOW CREATE TABLE db1.h3;
DROP DATABASE db1;
DROP TABLESPACE ts1;
DROP TABLESPACE ts2;
DROP TABLESPACE ts3;


CREATE TABLESPACE ts1 ADD DATAFILE 'ts1.ibd';
CREATE TABLESPACE ts2 ADD DATAFILE 'ts2.ibd';
CREATE TABLESPACE ts3 ADD DATAFILE 'ts3.ibd';

--exec $MYSQL test < $MYSQL_TMP_DIR/wl12261_8_0_12.sql
SHOW CREATE DATABASE db1;
SHOW CREATE TABLE db1.i1;
SHOW CREATE TABLE db1.i2;
SHOW CREATE TABLE db1.i3;
SHOW CREATE TABLE db1.i4;
SHOW CREATE TABLE db1.i_ts1;
SHOW CREATE TABLE db1.i_ts2;
SHOW CREATE TABLE db1.i_ts3;
SHOW CREATE TABLE db1.i_part1;
SHOW CREATE TABLE db1.i_part2;
SHOW CREATE TABLE db1.i_part3;
SHOW CREATE TABLE db1.c1;
SHOW CREATE TABLE db1.c2;
SHOW CREATE TABLE db1.c3;
SHOW CREATE TABLE db1.h1;
SHOW CREATE TABLE db1.h2;
SHOW CREATE TABLE db1.h3;
DROP DATABASE db1;
DROP TABLESPACE ts1;
DROP TABLESPACE ts2;
DROP TABLESPACE ts3;


CREATE TABLESPACE ts1 ADD DATAFILE 'ts1.ibd';
CREATE TABLESPACE ts2 ADD DATAFILE 'ts2.ibd' ENCRYPTION='n';
CREATE TABLESPACE ts3 ADD DATAFILE 'ts3.ibd' ENCRYPTION='y';
CREATE TABLESPACE ts4 ADD DATAFILE 'ts4.ibd';

--exec $MYSQL test < $MYSQL_TMP_DIR/wl12261_8_0_13.sql
SHOW CREATE DATABASE db1;
SHOW CREATE TABLE db1.i1;
SHOW CREATE TABLE db1.i2;
SHOW CREATE TABLE db1.i3;
SHOW CREATE TABLE db1.i_ts1;
SHOW CREATE TABLE db1.i_ts2;
SHOW CREATE TABLE db1.i_ts3;
SHOW CREATE TABLE db1.i_ts4;
SHOW CREATE TABLE db1.i_part1;
SHOW CREATE TABLE db1.i_part2;
SHOW CREATE TABLE db1.i_part3;
SHOW CREATE TABLE db1.c1;
SHOW CREATE TABLE db1.c2;
SHOW CREATE TABLE db1.c3;
SHOW CREATE TABLE db1.h1;
SHOW CREATE TABLE db1.h2;
SHOW CREATE TABLE db1.h3;
DROP DATABASE db1;
DROP TABLESPACE ts1;
DROP TABLESPACE ts2;
DROP TABLESPACE ts3;
DROP TABLESPACE ts4;

--echo # Cleanup
disconnect con1;
connection default;

DROP USER u1@localhost;

--remove_file $MYSQL_TMP_DIR/wl12261_dump.zip
--remove_file $MYSQL_TMP_DIR/wl12261_5_7_25.sql
--remove_file $MYSQL_TMP_DIR/wl12261_8_0_12.sql
--remove_file $MYSQL_TMP_DIR/wl12261_8_0_13.sql
