/*
Copyright 2024 Keyfactor

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

EJBCA REST Interface

API reference documentation.

API version: 1.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ejbca

import (
	"encoding/json"
)

// checks if the SearchEndEntitiesRestResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &SearchEndEntitiesRestResponse{}

// SearchEndEntitiesRestResponse struct for SearchEndEntitiesRestResponse
type SearchEndEntitiesRestResponse struct {
	EndEntities          []EndEntityRestResponse `json:"end_entities,omitempty"`
	MoreResults          *bool                   `json:"more_results,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _SearchEndEntitiesRestResponse SearchEndEntitiesRestResponse

// NewSearchEndEntitiesRestResponse instantiates a new SearchEndEntitiesRestResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewSearchEndEntitiesRestResponse() *SearchEndEntitiesRestResponse {
	this := SearchEndEntitiesRestResponse{}
	return &this
}

// NewSearchEndEntitiesRestResponseWithDefaults instantiates a new SearchEndEntitiesRestResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewSearchEndEntitiesRestResponseWithDefaults() *SearchEndEntitiesRestResponse {
	this := SearchEndEntitiesRestResponse{}
	return &this
}

// GetEndEntities returns the EndEntities field value if set, zero value otherwise.
func (o *SearchEndEntitiesRestResponse) GetEndEntities() []EndEntityRestResponse {
	if o == nil || isNil(o.EndEntities) {
		var ret []EndEntityRestResponse
		return ret
	}
	return o.EndEntities
}

// GetEndEntitiesOk returns a tuple with the EndEntities field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SearchEndEntitiesRestResponse) GetEndEntitiesOk() ([]EndEntityRestResponse, bool) {
	if o == nil || isNil(o.EndEntities) {
		return nil, false
	}
	return o.EndEntities, true
}

// HasEndEntities returns a boolean if a field has been set.
func (o *SearchEndEntitiesRestResponse) HasEndEntities() bool {
	if o != nil && !isNil(o.EndEntities) {
		return true
	}

	return false
}

// SetEndEntities gets a reference to the given []EndEntityRestResponse and assigns it to the EndEntities field.
func (o *SearchEndEntitiesRestResponse) SetEndEntities(v []EndEntityRestResponse) {
	o.EndEntities = v
}

// GetMoreResults returns the MoreResults field value if set, zero value otherwise.
func (o *SearchEndEntitiesRestResponse) GetMoreResults() bool {
	if o == nil || isNil(o.MoreResults) {
		var ret bool
		return ret
	}
	return *o.MoreResults
}

// GetMoreResultsOk returns a tuple with the MoreResults field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SearchEndEntitiesRestResponse) GetMoreResultsOk() (*bool, bool) {
	if o == nil || isNil(o.MoreResults) {
		return nil, false
	}
	return o.MoreResults, true
}

// HasMoreResults returns a boolean if a field has been set.
func (o *SearchEndEntitiesRestResponse) HasMoreResults() bool {
	if o != nil && !isNil(o.MoreResults) {
		return true
	}

	return false
}

// SetMoreResults gets a reference to the given bool and assigns it to the MoreResults field.
func (o *SearchEndEntitiesRestResponse) SetMoreResults(v bool) {
	o.MoreResults = &v
}

func (o SearchEndEntitiesRestResponse) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o SearchEndEntitiesRestResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !isNil(o.EndEntities) {
		toSerialize["end_entities"] = o.EndEntities
	}
	if !isNil(o.MoreResults) {
		toSerialize["more_results"] = o.MoreResults
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *SearchEndEntitiesRestResponse) UnmarshalJSON(bytes []byte) (err error) {
	varSearchEndEntitiesRestResponse := _SearchEndEntitiesRestResponse{}

	if err = json.Unmarshal(bytes, &varSearchEndEntitiesRestResponse); err == nil {
		*o = SearchEndEntitiesRestResponse(varSearchEndEntitiesRestResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "end_entities")
		delete(additionalProperties, "more_results")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableSearchEndEntitiesRestResponse struct {
	value *SearchEndEntitiesRestResponse
	isSet bool
}

func (v NullableSearchEndEntitiesRestResponse) Get() *SearchEndEntitiesRestResponse {
	return v.value
}

func (v *NullableSearchEndEntitiesRestResponse) Set(val *SearchEndEntitiesRestResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableSearchEndEntitiesRestResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableSearchEndEntitiesRestResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableSearchEndEntitiesRestResponse(val *SearchEndEntitiesRestResponse) *NullableSearchEndEntitiesRestResponse {
	return &NullableSearchEndEntitiesRestResponse{value: val, isSet: true}
}

func (v NullableSearchEndEntitiesRestResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableSearchEndEntitiesRestResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
