/*
Copyright 2024 Keyfactor

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

EJBCA REST Interface

API reference documentation.

API version: 1.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ejbca

import (
	"encoding/json"
)

// checks if the CertificateRequestRestRequest type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &CertificateRequestRestRequest{}

// CertificateRequestRestRequest struct for CertificateRequestRestRequest
type CertificateRequestRestRequest struct {
	// Certificate request
	CertificateRequest *string `json:"certificate_request,omitempty"`
	// Username
	Username *string `json:"username,omitempty"`
	// Password
	Password     *string `json:"password,omitempty"`
	IncludeChain *bool   `json:"include_chain,omitempty"`
	// Certificate Authority (CA) name
	CertificateAuthorityName *string `json:"certificate_authority_name,omitempty"`
	AdditionalProperties     map[string]interface{}
}

type _CertificateRequestRestRequest CertificateRequestRestRequest

// NewCertificateRequestRestRequest instantiates a new CertificateRequestRestRequest object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCertificateRequestRestRequest() *CertificateRequestRestRequest {
	this := CertificateRequestRestRequest{}
	return &this
}

// NewCertificateRequestRestRequestWithDefaults instantiates a new CertificateRequestRestRequest object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCertificateRequestRestRequestWithDefaults() *CertificateRequestRestRequest {
	this := CertificateRequestRestRequest{}
	return &this
}

// GetCertificateRequest returns the CertificateRequest field value if set, zero value otherwise.
func (o *CertificateRequestRestRequest) GetCertificateRequest() string {
	if o == nil || isNil(o.CertificateRequest) {
		var ret string
		return ret
	}
	return *o.CertificateRequest
}

// GetCertificateRequestOk returns a tuple with the CertificateRequest field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateRequestRestRequest) GetCertificateRequestOk() (*string, bool) {
	if o == nil || isNil(o.CertificateRequest) {
		return nil, false
	}
	return o.CertificateRequest, true
}

// HasCertificateRequest returns a boolean if a field has been set.
func (o *CertificateRequestRestRequest) HasCertificateRequest() bool {
	if o != nil && !isNil(o.CertificateRequest) {
		return true
	}

	return false
}

// SetCertificateRequest gets a reference to the given string and assigns it to the CertificateRequest field.
func (o *CertificateRequestRestRequest) SetCertificateRequest(v string) {
	o.CertificateRequest = &v
}

// GetUsername returns the Username field value if set, zero value otherwise.
func (o *CertificateRequestRestRequest) GetUsername() string {
	if o == nil || isNil(o.Username) {
		var ret string
		return ret
	}
	return *o.Username
}

// GetUsernameOk returns a tuple with the Username field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateRequestRestRequest) GetUsernameOk() (*string, bool) {
	if o == nil || isNil(o.Username) {
		return nil, false
	}
	return o.Username, true
}

// HasUsername returns a boolean if a field has been set.
func (o *CertificateRequestRestRequest) HasUsername() bool {
	if o != nil && !isNil(o.Username) {
		return true
	}

	return false
}

// SetUsername gets a reference to the given string and assigns it to the Username field.
func (o *CertificateRequestRestRequest) SetUsername(v string) {
	o.Username = &v
}

// GetPassword returns the Password field value if set, zero value otherwise.
func (o *CertificateRequestRestRequest) GetPassword() string {
	if o == nil || isNil(o.Password) {
		var ret string
		return ret
	}
	return *o.Password
}

// GetPasswordOk returns a tuple with the Password field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateRequestRestRequest) GetPasswordOk() (*string, bool) {
	if o == nil || isNil(o.Password) {
		return nil, false
	}
	return o.Password, true
}

// HasPassword returns a boolean if a field has been set.
func (o *CertificateRequestRestRequest) HasPassword() bool {
	if o != nil && !isNil(o.Password) {
		return true
	}

	return false
}

// SetPassword gets a reference to the given string and assigns it to the Password field.
func (o *CertificateRequestRestRequest) SetPassword(v string) {
	o.Password = &v
}

// GetIncludeChain returns the IncludeChain field value if set, zero value otherwise.
func (o *CertificateRequestRestRequest) GetIncludeChain() bool {
	if o == nil || isNil(o.IncludeChain) {
		var ret bool
		return ret
	}
	return *o.IncludeChain
}

// GetIncludeChainOk returns a tuple with the IncludeChain field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateRequestRestRequest) GetIncludeChainOk() (*bool, bool) {
	if o == nil || isNil(o.IncludeChain) {
		return nil, false
	}
	return o.IncludeChain, true
}

// HasIncludeChain returns a boolean if a field has been set.
func (o *CertificateRequestRestRequest) HasIncludeChain() bool {
	if o != nil && !isNil(o.IncludeChain) {
		return true
	}

	return false
}

// SetIncludeChain gets a reference to the given bool and assigns it to the IncludeChain field.
func (o *CertificateRequestRestRequest) SetIncludeChain(v bool) {
	o.IncludeChain = &v
}

// GetCertificateAuthorityName returns the CertificateAuthorityName field value if set, zero value otherwise.
func (o *CertificateRequestRestRequest) GetCertificateAuthorityName() string {
	if o == nil || isNil(o.CertificateAuthorityName) {
		var ret string
		return ret
	}
	return *o.CertificateAuthorityName
}

// GetCertificateAuthorityNameOk returns a tuple with the CertificateAuthorityName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CertificateRequestRestRequest) GetCertificateAuthorityNameOk() (*string, bool) {
	if o == nil || isNil(o.CertificateAuthorityName) {
		return nil, false
	}
	return o.CertificateAuthorityName, true
}

// HasCertificateAuthorityName returns a boolean if a field has been set.
func (o *CertificateRequestRestRequest) HasCertificateAuthorityName() bool {
	if o != nil && !isNil(o.CertificateAuthorityName) {
		return true
	}

	return false
}

// SetCertificateAuthorityName gets a reference to the given string and assigns it to the CertificateAuthorityName field.
func (o *CertificateRequestRestRequest) SetCertificateAuthorityName(v string) {
	o.CertificateAuthorityName = &v
}

func (o CertificateRequestRestRequest) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o CertificateRequestRestRequest) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !isNil(o.CertificateRequest) {
		toSerialize["certificate_request"] = o.CertificateRequest
	}
	if !isNil(o.Username) {
		toSerialize["username"] = o.Username
	}
	if !isNil(o.Password) {
		toSerialize["password"] = o.Password
	}
	if !isNil(o.IncludeChain) {
		toSerialize["include_chain"] = o.IncludeChain
	}
	if !isNil(o.CertificateAuthorityName) {
		toSerialize["certificate_authority_name"] = o.CertificateAuthorityName
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *CertificateRequestRestRequest) UnmarshalJSON(bytes []byte) (err error) {
	varCertificateRequestRestRequest := _CertificateRequestRestRequest{}

	if err = json.Unmarshal(bytes, &varCertificateRequestRestRequest); err == nil {
		*o = CertificateRequestRestRequest(varCertificateRequestRestRequest)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "certificate_request")
		delete(additionalProperties, "username")
		delete(additionalProperties, "password")
		delete(additionalProperties, "include_chain")
		delete(additionalProperties, "certificate_authority_name")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableCertificateRequestRestRequest struct {
	value *CertificateRequestRestRequest
	isSet bool
}

func (v NullableCertificateRequestRestRequest) Get() *CertificateRequestRestRequest {
	return v.value
}

func (v *NullableCertificateRequestRestRequest) Set(val *CertificateRequestRestRequest) {
	v.value = val
	v.isSet = true
}

func (v NullableCertificateRequestRestRequest) IsSet() bool {
	return v.isSet
}

func (v *NullableCertificateRequestRestRequest) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCertificateRequestRestRequest(val *CertificateRequestRestRequest) *NullableCertificateRequestRestRequest {
	return &NullableCertificateRequestRestRequest{value: val, isSet: true}
}

func (v NullableCertificateRequestRestRequest) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCertificateRequestRestRequest) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
