// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package apptestiface provides an interface to enable mocking the AWS Mainframe Modernization Application Testing service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package apptestiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/apptest"
)

// AppTestAPI provides an interface to enable mocking the
// apptest.AppTest service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// AWS Mainframe Modernization Application Testing.
//	func myFunc(svc apptestiface.AppTestAPI) bool {
//	    // Make svc.CreateTestCase request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := apptest.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockAppTestClient struct {
//	    apptestiface.AppTestAPI
//	}
//	func (m *mockAppTestClient) CreateTestCase(input *apptest.CreateTestCaseInput) (*apptest.CreateTestCaseOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockAppTestClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type AppTestAPI interface {
	CreateTestCase(*apptest.CreateTestCaseInput) (*apptest.CreateTestCaseOutput, error)
	CreateTestCaseWithContext(aws.Context, *apptest.CreateTestCaseInput, ...request.Option) (*apptest.CreateTestCaseOutput, error)
	CreateTestCaseRequest(*apptest.CreateTestCaseInput) (*request.Request, *apptest.CreateTestCaseOutput)

	CreateTestConfiguration(*apptest.CreateTestConfigurationInput) (*apptest.CreateTestConfigurationOutput, error)
	CreateTestConfigurationWithContext(aws.Context, *apptest.CreateTestConfigurationInput, ...request.Option) (*apptest.CreateTestConfigurationOutput, error)
	CreateTestConfigurationRequest(*apptest.CreateTestConfigurationInput) (*request.Request, *apptest.CreateTestConfigurationOutput)

	CreateTestSuite(*apptest.CreateTestSuiteInput) (*apptest.CreateTestSuiteOutput, error)
	CreateTestSuiteWithContext(aws.Context, *apptest.CreateTestSuiteInput, ...request.Option) (*apptest.CreateTestSuiteOutput, error)
	CreateTestSuiteRequest(*apptest.CreateTestSuiteInput) (*request.Request, *apptest.CreateTestSuiteOutput)

	DeleteTestCase(*apptest.DeleteTestCaseInput) (*apptest.DeleteTestCaseOutput, error)
	DeleteTestCaseWithContext(aws.Context, *apptest.DeleteTestCaseInput, ...request.Option) (*apptest.DeleteTestCaseOutput, error)
	DeleteTestCaseRequest(*apptest.DeleteTestCaseInput) (*request.Request, *apptest.DeleteTestCaseOutput)

	DeleteTestConfiguration(*apptest.DeleteTestConfigurationInput) (*apptest.DeleteTestConfigurationOutput, error)
	DeleteTestConfigurationWithContext(aws.Context, *apptest.DeleteTestConfigurationInput, ...request.Option) (*apptest.DeleteTestConfigurationOutput, error)
	DeleteTestConfigurationRequest(*apptest.DeleteTestConfigurationInput) (*request.Request, *apptest.DeleteTestConfigurationOutput)

	DeleteTestRun(*apptest.DeleteTestRunInput) (*apptest.DeleteTestRunOutput, error)
	DeleteTestRunWithContext(aws.Context, *apptest.DeleteTestRunInput, ...request.Option) (*apptest.DeleteTestRunOutput, error)
	DeleteTestRunRequest(*apptest.DeleteTestRunInput) (*request.Request, *apptest.DeleteTestRunOutput)

	DeleteTestSuite(*apptest.DeleteTestSuiteInput) (*apptest.DeleteTestSuiteOutput, error)
	DeleteTestSuiteWithContext(aws.Context, *apptest.DeleteTestSuiteInput, ...request.Option) (*apptest.DeleteTestSuiteOutput, error)
	DeleteTestSuiteRequest(*apptest.DeleteTestSuiteInput) (*request.Request, *apptest.DeleteTestSuiteOutput)

	GetTestCase(*apptest.GetTestCaseInput) (*apptest.GetTestCaseOutput, error)
	GetTestCaseWithContext(aws.Context, *apptest.GetTestCaseInput, ...request.Option) (*apptest.GetTestCaseOutput, error)
	GetTestCaseRequest(*apptest.GetTestCaseInput) (*request.Request, *apptest.GetTestCaseOutput)

	GetTestConfiguration(*apptest.GetTestConfigurationInput) (*apptest.GetTestConfigurationOutput, error)
	GetTestConfigurationWithContext(aws.Context, *apptest.GetTestConfigurationInput, ...request.Option) (*apptest.GetTestConfigurationOutput, error)
	GetTestConfigurationRequest(*apptest.GetTestConfigurationInput) (*request.Request, *apptest.GetTestConfigurationOutput)

	GetTestRunStep(*apptest.GetTestRunStepInput) (*apptest.GetTestRunStepOutput, error)
	GetTestRunStepWithContext(aws.Context, *apptest.GetTestRunStepInput, ...request.Option) (*apptest.GetTestRunStepOutput, error)
	GetTestRunStepRequest(*apptest.GetTestRunStepInput) (*request.Request, *apptest.GetTestRunStepOutput)

	GetTestSuite(*apptest.GetTestSuiteInput) (*apptest.GetTestSuiteOutput, error)
	GetTestSuiteWithContext(aws.Context, *apptest.GetTestSuiteInput, ...request.Option) (*apptest.GetTestSuiteOutput, error)
	GetTestSuiteRequest(*apptest.GetTestSuiteInput) (*request.Request, *apptest.GetTestSuiteOutput)

	ListTagsForResource(*apptest.ListTagsForResourceInput) (*apptest.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *apptest.ListTagsForResourceInput, ...request.Option) (*apptest.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*apptest.ListTagsForResourceInput) (*request.Request, *apptest.ListTagsForResourceOutput)

	ListTestCases(*apptest.ListTestCasesInput) (*apptest.ListTestCasesOutput, error)
	ListTestCasesWithContext(aws.Context, *apptest.ListTestCasesInput, ...request.Option) (*apptest.ListTestCasesOutput, error)
	ListTestCasesRequest(*apptest.ListTestCasesInput) (*request.Request, *apptest.ListTestCasesOutput)

	ListTestCasesPages(*apptest.ListTestCasesInput, func(*apptest.ListTestCasesOutput, bool) bool) error
	ListTestCasesPagesWithContext(aws.Context, *apptest.ListTestCasesInput, func(*apptest.ListTestCasesOutput, bool) bool, ...request.Option) error

	ListTestConfigurations(*apptest.ListTestConfigurationsInput) (*apptest.ListTestConfigurationsOutput, error)
	ListTestConfigurationsWithContext(aws.Context, *apptest.ListTestConfigurationsInput, ...request.Option) (*apptest.ListTestConfigurationsOutput, error)
	ListTestConfigurationsRequest(*apptest.ListTestConfigurationsInput) (*request.Request, *apptest.ListTestConfigurationsOutput)

	ListTestConfigurationsPages(*apptest.ListTestConfigurationsInput, func(*apptest.ListTestConfigurationsOutput, bool) bool) error
	ListTestConfigurationsPagesWithContext(aws.Context, *apptest.ListTestConfigurationsInput, func(*apptest.ListTestConfigurationsOutput, bool) bool, ...request.Option) error

	ListTestRunSteps(*apptest.ListTestRunStepsInput) (*apptest.ListTestRunStepsOutput, error)
	ListTestRunStepsWithContext(aws.Context, *apptest.ListTestRunStepsInput, ...request.Option) (*apptest.ListTestRunStepsOutput, error)
	ListTestRunStepsRequest(*apptest.ListTestRunStepsInput) (*request.Request, *apptest.ListTestRunStepsOutput)

	ListTestRunStepsPages(*apptest.ListTestRunStepsInput, func(*apptest.ListTestRunStepsOutput, bool) bool) error
	ListTestRunStepsPagesWithContext(aws.Context, *apptest.ListTestRunStepsInput, func(*apptest.ListTestRunStepsOutput, bool) bool, ...request.Option) error

	ListTestRunTestCases(*apptest.ListTestRunTestCasesInput) (*apptest.ListTestRunTestCasesOutput, error)
	ListTestRunTestCasesWithContext(aws.Context, *apptest.ListTestRunTestCasesInput, ...request.Option) (*apptest.ListTestRunTestCasesOutput, error)
	ListTestRunTestCasesRequest(*apptest.ListTestRunTestCasesInput) (*request.Request, *apptest.ListTestRunTestCasesOutput)

	ListTestRunTestCasesPages(*apptest.ListTestRunTestCasesInput, func(*apptest.ListTestRunTestCasesOutput, bool) bool) error
	ListTestRunTestCasesPagesWithContext(aws.Context, *apptest.ListTestRunTestCasesInput, func(*apptest.ListTestRunTestCasesOutput, bool) bool, ...request.Option) error

	ListTestRuns(*apptest.ListTestRunsInput) (*apptest.ListTestRunsOutput, error)
	ListTestRunsWithContext(aws.Context, *apptest.ListTestRunsInput, ...request.Option) (*apptest.ListTestRunsOutput, error)
	ListTestRunsRequest(*apptest.ListTestRunsInput) (*request.Request, *apptest.ListTestRunsOutput)

	ListTestRunsPages(*apptest.ListTestRunsInput, func(*apptest.ListTestRunsOutput, bool) bool) error
	ListTestRunsPagesWithContext(aws.Context, *apptest.ListTestRunsInput, func(*apptest.ListTestRunsOutput, bool) bool, ...request.Option) error

	ListTestSuites(*apptest.ListTestSuitesInput) (*apptest.ListTestSuitesOutput, error)
	ListTestSuitesWithContext(aws.Context, *apptest.ListTestSuitesInput, ...request.Option) (*apptest.ListTestSuitesOutput, error)
	ListTestSuitesRequest(*apptest.ListTestSuitesInput) (*request.Request, *apptest.ListTestSuitesOutput)

	ListTestSuitesPages(*apptest.ListTestSuitesInput, func(*apptest.ListTestSuitesOutput, bool) bool) error
	ListTestSuitesPagesWithContext(aws.Context, *apptest.ListTestSuitesInput, func(*apptest.ListTestSuitesOutput, bool) bool, ...request.Option) error

	StartTestRun(*apptest.StartTestRunInput) (*apptest.StartTestRunOutput, error)
	StartTestRunWithContext(aws.Context, *apptest.StartTestRunInput, ...request.Option) (*apptest.StartTestRunOutput, error)
	StartTestRunRequest(*apptest.StartTestRunInput) (*request.Request, *apptest.StartTestRunOutput)

	TagResource(*apptest.TagResourceInput) (*apptest.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *apptest.TagResourceInput, ...request.Option) (*apptest.TagResourceOutput, error)
	TagResourceRequest(*apptest.TagResourceInput) (*request.Request, *apptest.TagResourceOutput)

	UntagResource(*apptest.UntagResourceInput) (*apptest.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *apptest.UntagResourceInput, ...request.Option) (*apptest.UntagResourceOutput, error)
	UntagResourceRequest(*apptest.UntagResourceInput) (*request.Request, *apptest.UntagResourceOutput)

	UpdateTestCase(*apptest.UpdateTestCaseInput) (*apptest.UpdateTestCaseOutput, error)
	UpdateTestCaseWithContext(aws.Context, *apptest.UpdateTestCaseInput, ...request.Option) (*apptest.UpdateTestCaseOutput, error)
	UpdateTestCaseRequest(*apptest.UpdateTestCaseInput) (*request.Request, *apptest.UpdateTestCaseOutput)

	UpdateTestConfiguration(*apptest.UpdateTestConfigurationInput) (*apptest.UpdateTestConfigurationOutput, error)
	UpdateTestConfigurationWithContext(aws.Context, *apptest.UpdateTestConfigurationInput, ...request.Option) (*apptest.UpdateTestConfigurationOutput, error)
	UpdateTestConfigurationRequest(*apptest.UpdateTestConfigurationInput) (*request.Request, *apptest.UpdateTestConfigurationOutput)

	UpdateTestSuite(*apptest.UpdateTestSuiteInput) (*apptest.UpdateTestSuiteOutput, error)
	UpdateTestSuiteWithContext(aws.Context, *apptest.UpdateTestSuiteInput, ...request.Option) (*apptest.UpdateTestSuiteOutput, error)
	UpdateTestSuiteRequest(*apptest.UpdateTestSuiteInput) (*request.Request, *apptest.UpdateTestSuiteOutput)
}

var _ AppTestAPI = (*apptest.AppTest)(nil)
