/*
 * Decompiled with CFR 0.152.
 */
package org.olsr.v1.info.proxy;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@ObjectClassDefinition(name="OLSRd Info Proxy", description="Configuration for the OLSRd Info Proxy service")
@interface Config {
    public static final String ADDRESS_DEFAULT = "127.0.0.1";
    public static final int LOCAL_PORT_DEFAULT = 2301;
    public static final int LOCAL_PORT_MIN = 1;
    public static final int LOCAL_PORT_MAX = 65535;
    public static final int PORT_MIN = 1;
    public static final int PORT_MAX = 65535;
    public static final int PORT_TXTINFO_DEFAULT = 2006;
    public static final int PORT_JSONINFO_DEFAULT = 2007;
    public static final int CONNECT_TIMEOUT_DEFAULT = 500;
    public static final int CONNECT_TIMEOUT_MIN = 1;
    public static final int CONNECT_TIMEOUT_MAX = 60000;
    public static final int SOCKET_TIMEOUT_DEFAULT = 1000;
    public static final int SOCKET_TIMEOUT_MIN = 1;
    public static final int SOCKET_TIMEOUT_MAX = 60000;
    public static final int RANDOM_SLEEP_DEFAULT = 250;
    public static final int RANDOM_SLEEP_MIN = 100;
    public static final int CONNECTION_RETRIES_DEFAULT = 4;
    public static final int CONNECTION_RETRIES_MIN = 0;

    @AttributeDefinition(required=false, description="The host name or IP address of the OLSRd info plugins (default = 127.0.0.1)")
    public String address() default "127.0.0.1";

    @AttributeDefinition(min="1", max="65535", required=false, description="The preferred local port to connect from to the OLSRd info plugins (default = 2301)")
    public int localPort() default 2301;

    @AttributeDefinition(min="1", max="65535", required=false, description="The port of the OLSRd txtinfo plugin (default = 2006)")
    public int portTxtInfo() default 2006;

    @AttributeDefinition(min="1", max="65535", required=false, description="The port of the OLSRd jsoninfo plugin (default = 2007)")
    public int portJsonInfo() default 2007;

    @AttributeDefinition(min="1", max="60000", required=false, description="The connection timeout (msec) (default = 500)")
    public int connectionTimeout() default 500;

    @AttributeDefinition(min="1", max="60000", required=false, description="The socket (read) timeout (msec) (default = 1000)")
    public int socketTimeout() default 1000;

    @AttributeDefinition(min="100", required=false, description="The maximum number of random msec to sleep before reconnecting after a connection failure (default = 250)")
    public int randomSleep() default 250;

    @AttributeDefinition(min="0", required=false, description="The number of connection retries to perform after a connection failure (default = 4)")
    public int connectionRetries() default 4;
}

