﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/connect/model/AssociatedContactSummary.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Connect {
namespace Model {

AssociatedContactSummary::AssociatedContactSummary(JsonView jsonValue) { *this = jsonValue; }

AssociatedContactSummary& AssociatedContactSummary::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("ContactId")) {
    m_contactId = jsonValue.GetString("ContactId");
    m_contactIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("ContactArn")) {
    m_contactArn = jsonValue.GetString("ContactArn");
    m_contactArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("InitiationTimestamp")) {
    m_initiationTimestamp = jsonValue.GetDouble("InitiationTimestamp");
    m_initiationTimestampHasBeenSet = true;
  }
  if (jsonValue.ValueExists("DisconnectTimestamp")) {
    m_disconnectTimestamp = jsonValue.GetDouble("DisconnectTimestamp");
    m_disconnectTimestampHasBeenSet = true;
  }
  if (jsonValue.ValueExists("InitialContactId")) {
    m_initialContactId = jsonValue.GetString("InitialContactId");
    m_initialContactIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("PreviousContactId")) {
    m_previousContactId = jsonValue.GetString("PreviousContactId");
    m_previousContactIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("RelatedContactId")) {
    m_relatedContactId = jsonValue.GetString("RelatedContactId");
    m_relatedContactIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("InitiationMethod")) {
    m_initiationMethod = ContactInitiationMethodMapper::GetContactInitiationMethodForName(jsonValue.GetString("InitiationMethod"));
    m_initiationMethodHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Channel")) {
    m_channel = ChannelMapper::GetChannelForName(jsonValue.GetString("Channel"));
    m_channelHasBeenSet = true;
  }
  return *this;
}

JsonValue AssociatedContactSummary::Jsonize() const {
  JsonValue payload;

  if (m_contactIdHasBeenSet) {
    payload.WithString("ContactId", m_contactId);
  }

  if (m_contactArnHasBeenSet) {
    payload.WithString("ContactArn", m_contactArn);
  }

  if (m_initiationTimestampHasBeenSet) {
    payload.WithDouble("InitiationTimestamp", m_initiationTimestamp.SecondsWithMSPrecision());
  }

  if (m_disconnectTimestampHasBeenSet) {
    payload.WithDouble("DisconnectTimestamp", m_disconnectTimestamp.SecondsWithMSPrecision());
  }

  if (m_initialContactIdHasBeenSet) {
    payload.WithString("InitialContactId", m_initialContactId);
  }

  if (m_previousContactIdHasBeenSet) {
    payload.WithString("PreviousContactId", m_previousContactId);
  }

  if (m_relatedContactIdHasBeenSet) {
    payload.WithString("RelatedContactId", m_relatedContactId);
  }

  if (m_initiationMethodHasBeenSet) {
    payload.WithString("InitiationMethod", ContactInitiationMethodMapper::GetNameForContactInitiationMethod(m_initiationMethod));
  }

  if (m_channelHasBeenSet) {
    payload.WithString("Channel", ChannelMapper::GetNameForChannel(m_channel));
  }

  return payload;
}

}  // namespace Model
}  // namespace Connect
}  // namespace Aws
