﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/amplify/model/CertificateType.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>

using namespace Aws::Utils;

namespace Aws {
namespace Amplify {
namespace Model {
namespace CertificateTypeMapper {

static const int AMPLIFY_MANAGED_HASH = HashingUtils::HashString("AMPLIFY_MANAGED");
static const int CUSTOM_HASH = HashingUtils::HashString("CUSTOM");

CertificateType GetCertificateTypeForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == AMPLIFY_MANAGED_HASH) {
    return CertificateType::AMPLIFY_MANAGED;
  } else if (hashCode == CUSTOM_HASH) {
    return CertificateType::CUSTOM;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<CertificateType>(hashCode);
  }

  return CertificateType::NOT_SET;
}

Aws::String GetNameForCertificateType(CertificateType enumValue) {
  switch (enumValue) {
    case CertificateType::NOT_SET:
      return {};
    case CertificateType::AMPLIFY_MANAGED:
      return "AMPLIFY_MANAGED";
    case CertificateType::CUSTOM:
      return "CUSTOM";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace CertificateTypeMapper
}  // namespace Model
}  // namespace Amplify
}  // namespace Aws
