/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.action;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xpack.idp.saml.support.SamlAuthenticationState;

public class SamlInitiateSingleSignOnRequest
extends ActionRequest {
    private String spEntityId;
    private String assertionConsumerService;
    private SamlAuthenticationState samlAuthenticationState;

    public SamlInitiateSingleSignOnRequest(StreamInput in) throws IOException {
        super(in);
        this.spEntityId = in.readString();
        this.assertionConsumerService = in.readString();
        this.samlAuthenticationState = (SamlAuthenticationState)in.readOptionalWriteable(SamlAuthenticationState::new);
    }

    public SamlInitiateSingleSignOnRequest() {
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (Strings.isNullOrEmpty((String)this.spEntityId)) {
            validationException = ValidateActions.addValidationError((String)"entity_id is missing", validationException);
        }
        if (Strings.isNullOrEmpty((String)this.assertionConsumerService)) {
            validationException = ValidateActions.addValidationError((String)"acs is missing", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public String getSpEntityId() {
        return this.spEntityId;
    }

    public void setSpEntityId(String spEntityId) {
        this.spEntityId = spEntityId;
    }

    public String getAssertionConsumerService() {
        return this.assertionConsumerService;
    }

    public void setAssertionConsumerService(String assertionConsumerService) {
        this.assertionConsumerService = assertionConsumerService;
    }

    public SamlAuthenticationState getSamlAuthenticationState() {
        return this.samlAuthenticationState;
    }

    public void setSamlAuthenticationState(SamlAuthenticationState samlAuthenticationState) {
        this.samlAuthenticationState = samlAuthenticationState;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.spEntityId);
        out.writeString(this.assertionConsumerService);
        out.writeOptionalWriteable((Writeable)this.samlAuthenticationState);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{spEntityId='" + this.spEntityId + "', acs='" + this.assertionConsumerService + "'}";
    }
}

