/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.monitoring.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.monitoring.MonitoredSystem;
import org.elasticsearch.xpack.core.monitoring.action.MonitoringIndex;
import org.elasticsearch.xpack.core.monitoring.exporter.MonitoringDoc;

public class MonitoringBulkDoc
implements Writeable {
    private final MonitoredSystem system;
    private final String type;
    private final String id;
    private final long timestamp;
    private final long intervalMillis;
    private final BytesReference source;
    private final XContentType xContentType;

    public MonitoringBulkDoc(MonitoredSystem system, String type, @Nullable String id, long timestamp, long intervalMillis, BytesReference source, XContentType xContentType) {
        this.system = Objects.requireNonNull(system);
        this.type = Objects.requireNonNull(type);
        this.id = Strings.isNullOrEmpty((String)id) ? null : id;
        this.timestamp = timestamp;
        this.intervalMillis = intervalMillis;
        this.source = Objects.requireNonNull(source);
        this.xContentType = Objects.requireNonNull(xContentType);
    }

    public MonitoringBulkDoc(StreamInput in) throws IOException {
        this.system = MonitoredSystem.fromSystem(in.readOptionalString());
        if (in.getVersion().before(Version.V_6_0_0_rc1)) {
            in.readOptionalString();
            in.readOptionalString();
        }
        this.timestamp = in.readVLong();
        if (in.getVersion().before(Version.V_6_0_0_rc1)) {
            in.readOptionalWriteable(MonitoringDoc.Node::new);
            MonitoringIndex.readFrom(in);
        }
        this.type = in.readOptionalString();
        this.id = in.readOptionalString();
        this.source = in.readBytesReference();
        this.xContentType = this.source != BytesArray.EMPTY ? (XContentType)in.readEnum(XContentType.class) : XContentType.JSON;
        long interval = 0L;
        if (in.getVersion().onOrAfter(Version.V_6_0_0_rc1)) {
            interval = in.readVLong();
        }
        this.intervalMillis = interval;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.system.getSystem());
        if (out.getVersion().before(Version.V_6_0_0_rc1)) {
            out.writeOptionalString("7");
            out.writeOptionalString(null);
        }
        out.writeVLong(this.timestamp);
        if (out.getVersion().before(Version.V_6_0_0_rc1)) {
            out.writeOptionalWriteable(null);
            MonitoringIndex.IGNORED_DATA.writeTo(out);
        }
        out.writeOptionalString(this.type);
        out.writeOptionalString(this.id);
        out.writeBytesReference(this.source);
        if (this.source != BytesArray.EMPTY) {
            out.writeEnum((Enum)this.xContentType);
        }
        if (out.getVersion().onOrAfter(Version.V_6_0_0_rc1)) {
            out.writeVLong(this.intervalMillis);
        }
    }

    public MonitoredSystem getSystem() {
        return this.system;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getIntervalMillis() {
        return this.intervalMillis;
    }

    public BytesReference getSource() {
        return this.source;
    }

    public XContentType getXContentType() {
        return this.xContentType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MonitoringBulkDoc that = (MonitoringBulkDoc)o;
        return this.timestamp == that.timestamp && this.intervalMillis == that.intervalMillis && this.system == that.system && Objects.equals(this.type, that.type) && Objects.equals(this.id, that.id) && Objects.equals(this.source, that.source) && this.xContentType == that.xContentType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.system, this.type, this.id, this.timestamp, this.intervalMillis, this.source, this.xContentType});
    }
}

