/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

public class ShapPath {
    private static final double DBL_EPSILON = Double.MIN_VALUE;
    private final PathElement[] pathElements;
    private final double[] scale;
    private final int elementAndScaleOffset;

    public ShapPath(ShapPath parentPath, int nextIndex) {
        this.elementAndScaleOffset = parentPath.elementAndScaleOffset + nextIndex;
        this.pathElements = parentPath.pathElements;
        this.scale = parentPath.scale;
        for (int i = 0; i < nextIndex; ++i) {
            this.pathElements[this.elementAndScaleOffset + i].featureIndex = parentPath.getElement(i).featureIndex;
            this.pathElements[this.elementAndScaleOffset + i].fractionZeros = parentPath.getElement(i).fractionZeros;
            this.pathElements[this.elementAndScaleOffset + i].fractionOnes = parentPath.getElement(i).fractionOnes;
            this.scale[this.elementAndScaleOffset + i] = parentPath.getScale(i);
        }
    }

    public ShapPath(PathElement[] elements, double[] scale) {
        this.pathElements = elements;
        this.scale = scale;
        this.elementAndScaleOffset = 0;
    }

    public int extend(double fractionZero, double fractionOne, int featureIndex, int nextIndex) {
        this.setValues(nextIndex, fractionOne, fractionZero, featureIndex);
        this.setScale(nextIndex, nextIndex == 0 ? 1.0 : 0.0);
        double stepDown = fractionOne / (double)(nextIndex + 1);
        double stepUp = fractionZero / (double)(nextIndex + 1);
        double countDown = (double)nextIndex * stepDown;
        double countUp = stepUp;
        int i = nextIndex - 1;
        while (i >= 0) {
            this.setScale(i + 1, this.getScale(i + 1) + this.getScale(i) * countDown);
            this.setScale(i, this.getScale(i) * countUp);
            --i;
            countDown -= stepDown;
            countUp += stepUp;
        }
        return nextIndex + 1;
    }

    public double sumUnwoundPath(int pathIndex, int nextIndex) {
        double total = 0.0;
        int pathDepth = nextIndex - 1;
        double nextFractionOne = this.getScale(pathDepth);
        double fractionOne = this.fractionOnes(pathIndex);
        double fractionZero = this.fractionZeros(pathIndex);
        if (fractionOne != 0.0) {
            double pD = pathDepth + 1;
            double stepUp = fractionZero / pD;
            double stepDown = fractionOne / pD;
            double countUp = stepUp;
            double countDown = (pD - 1.0) * stepDown;
            int i = pathDepth - 1;
            while (i >= 0) {
                double tmp = nextFractionOne / countDown;
                nextFractionOne = this.getScale(i) - tmp * countUp;
                total += tmp;
                --i;
                countUp += stepUp;
                countDown -= stepDown;
            }
        } else {
            double pD = pathDepth;
            for (int i = 0; i < pathDepth; ++i) {
                double d = pD;
                pD = d - 1.0;
                total += this.getScale(i) / d;
            }
            total *= (double)(pathDepth + 1) / (fractionZero + Double.MIN_VALUE);
        }
        return total;
    }

    public int unwind(int pathIndex, int nextIndex) {
        int pathDepth = nextIndex - 1;
        double nextFractionOne = this.getScale(pathDepth);
        double fractionOne = this.fractionOnes(pathIndex);
        double fractionZero = this.fractionZeros(pathIndex);
        if (fractionOne != 0.0) {
            double stepUp = fractionZero / (double)(pathDepth + 1);
            double stepDown = fractionOne / (double)nextIndex;
            double countUp = 0.0;
            double countDown = (double)nextIndex * stepDown;
            int i = pathDepth;
            while (i >= 0) {
                double tmp = nextFractionOne / countDown;
                nextFractionOne = this.getScale(i) - tmp * countUp;
                this.setScale(i, tmp);
                --i;
                countUp += stepUp;
                countDown -= stepDown;
            }
        } else {
            double stepDown = (fractionZero + Double.MIN_VALUE) / (double)(pathDepth + 1);
            double countDown = (double)pathDepth * stepDown;
            int i = 0;
            while (i <= pathDepth) {
                this.setScale(i, this.getScale(i) / countDown);
                ++i;
                countDown -= stepDown;
            }
        }
        for (int i = pathIndex; i < pathDepth; ++i) {
            PathElement element = this.getElement(i + 1);
            this.setValues(i, element.fractionOnes, element.fractionZeros, element.featureIndex);
        }
        return nextIndex - 1;
    }

    private void setValues(int index, double fractionOnes, double fractionZeros, int featureIndex) {
        this.pathElements[index + this.elementAndScaleOffset].fractionOnes = fractionOnes;
        this.pathElements[index + this.elementAndScaleOffset].fractionZeros = fractionZeros;
        this.pathElements[index + this.elementAndScaleOffset].featureIndex = featureIndex;
    }

    private double getScale(int offset) {
        return this.scale[offset + this.elementAndScaleOffset];
    }

    private void setScale(int offset, double value) {
        this.scale[offset + this.elementAndScaleOffset] = value;
    }

    public double fractionOnes(int pathIndex) {
        return this.pathElements[pathIndex + this.elementAndScaleOffset].fractionOnes;
    }

    public double fractionZeros(int pathIndex) {
        return this.pathElements[pathIndex + this.elementAndScaleOffset].fractionZeros;
    }

    public int findFeatureIndex(int splitFeature, int nextIndex) {
        for (int i = this.elementAndScaleOffset; i < this.elementAndScaleOffset + nextIndex; ++i) {
            if (this.pathElements[i].featureIndex != splitFeature) continue;
            return i - this.elementAndScaleOffset;
        }
        return -1;
    }

    public int featureIndex(int pathIndex) {
        return this.pathElements[pathIndex + this.elementAndScaleOffset].featureIndex;
    }

    private PathElement getElement(int offset) {
        return this.pathElements[offset + this.elementAndScaleOffset];
    }

    public static final class PathElement {
        private double fractionOnes = 1.0;
        private double fractionZeros = 1.0;
        private int featureIndex = -1;
    }
}

