/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Objects;
import java.util.function.BiPredicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.ClusterStateActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

public class BranchingStep
extends ClusterStateActionStep {
    public static final String NAME = "branch";
    private static final Logger logger = LogManager.getLogger(BranchingStep.class);
    private final Step.StepKey nextStepKeyOnFalse;
    private final Step.StepKey nextStepKeyOnTrue;
    private final BiPredicate<Index, ClusterState> predicate;
    private final SetOnce<Boolean> predicateValue;

    public BranchingStep(Step.StepKey key, Step.StepKey nextStepKeyOnFalse, Step.StepKey nextStepKeyOnTrue, BiPredicate<Index, ClusterState> predicate) {
        super(key, null);
        this.nextStepKeyOnFalse = nextStepKeyOnFalse;
        this.nextStepKeyOnTrue = nextStepKeyOnTrue;
        this.predicate = predicate;
        this.predicateValue = new SetOnce();
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    public ClusterState performAction(Index index, ClusterState clusterState) {
        IndexMetadata indexMetadata = clusterState.metadata().index(index);
        if (indexMetadata == null) {
            logger.debug("[{}] lifecycle action for index [{}] executed but index no longer exists", (Object)this.getKey().getAction(), (Object)index.getName());
            return clusterState;
        }
        this.predicateValue.set((Object)this.predicate.test(index, clusterState));
        return clusterState;
    }

    @Override
    public final Step.StepKey getNextStepKey() {
        if (this.predicateValue.get() == null) {
            throw new IllegalStateException("Cannot call getNextStepKey before performAction");
        }
        return (Boolean)this.predicateValue.get() != false ? this.nextStepKeyOnTrue : this.nextStepKeyOnFalse;
    }

    final Step.StepKey getNextStepKeyOnFalse() {
        return this.nextStepKeyOnFalse;
    }

    final Step.StepKey getNextStepKeyOnTrue() {
        return this.nextStepKeyOnTrue;
    }

    public final BiPredicate<Index, ClusterState> getPredicate() {
        return this.predicate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BranchingStep that = (BranchingStep)o;
        return super.equals(o) && Objects.equals(this.nextStepKeyOnFalse, that.nextStepKeyOnFalse) && Objects.equals(this.nextStepKeyOnTrue, that.nextStepKeyOnTrue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.nextStepKeyOnFalse, this.nextStepKeyOnTrue);
    }
}

