/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4.internal;

import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.http.HttpHeadersValidationException;
import org.elasticsearch.http.HttpPipelinedRequest;
import org.elasticsearch.http.HttpPreRequest;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.http.netty4.Netty4HttpHeaderValidator;
import org.elasticsearch.http.netty4.Netty4HttpRequest;
import org.elasticsearch.http.netty4.internal.HttpHeadersWithAuthenticationContext;
import org.elasticsearch.http.netty4.internal.HttpValidator;
import org.elasticsearch.rest.RestRequest;

public final class HttpHeadersAuthenticatorUtils {
    private HttpHeadersAuthenticatorUtils() {
    }

    public static Netty4HttpHeaderValidator getValidatorInboundHandler(HttpValidator validator, ThreadContext threadContext) {
        return new Netty4HttpHeaderValidator((httpRequest, channel, listener) -> {
            if (httpRequest.headers() instanceof HttpHeadersWithAuthenticationContext) {
                validator.validate(httpRequest, channel, (ActionListener<Void>)ActionListener.wrap(aVoid -> {
                    ((HttpHeadersWithAuthenticationContext)httpRequest.headers()).setAuthenticationContext(threadContext.newStoredContext(false));
                    listener.onResponse(null);
                }, e -> listener.onFailure((Exception)new HttpHeadersValidationException(e))));
            } else {
                listener.onFailure((Exception)new HttpHeadersValidationException((Exception)new IllegalStateException("Cannot authenticate unwrapped requests")));
            }
        }, threadContext);
    }

    public static HttpMessage wrapAsMessageWithAuthenticationContext(HttpMessage newlyDecodedMessage) {
        assert (newlyDecodedMessage instanceof io.netty.handler.codec.http.HttpRequest);
        DefaultHttpRequest httpRequest = (DefaultHttpRequest)newlyDecodedMessage;
        HttpHeadersWithAuthenticationContext httpHeadersWithAuthenticationContext = new HttpHeadersWithAuthenticationContext(newlyDecodedMessage.headers());
        return new DefaultHttpRequest(httpRequest.protocolVersion(), httpRequest.method(), httpRequest.uri(), (HttpHeaders)httpHeadersWithAuthenticationContext);
    }

    public static ThreadContext.StoredContext extractAuthenticationContext(HttpRequest request) {
        HttpHeadersWithAuthenticationContext authenticatedHeaders = HttpHeadersAuthenticatorUtils.unwrapAuthenticatedHeaders(request);
        return authenticatedHeaders != null ? (ThreadContext.StoredContext)authenticatedHeaders.authenticationContextSetOnce.get() : null;
    }

    public static HttpPreRequest asHttpPreRequest(final io.netty.handler.codec.http.HttpRequest request) {
        return new HttpPreRequest(){

            public RestRequest.Method method() {
                return Netty4HttpRequest.translateRequestMethod(request.method());
            }

            public String uri() {
                return request.uri();
            }

            public Map<String, List<String>> getHeaders() {
                return Netty4HttpRequest.getHttpHeadersAsMap(request.headers());
            }
        };
    }

    private static HttpHeadersWithAuthenticationContext unwrapAuthenticatedHeaders(HttpRequest request) {
        if (request instanceof HttpPipelinedRequest) {
            request = ((HttpPipelinedRequest)request).getDelegateRequest();
        }
        if (!(request instanceof Netty4HttpRequest)) {
            return null;
        }
        if (!(((Netty4HttpRequest)request).getNettyRequest().headers() instanceof HttpHeadersWithAuthenticationContext)) {
            return null;
        }
        return (HttpHeadersWithAuthenticationContext)((Netty4HttpRequest)request).getNettyRequest().headers();
    }
}

