/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import org.elasticsearch.client.FilterClient;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public class RestCancellableNodeClient
extends FilterClient {
    private static final Map<HttpChannel, CloseListener> httpChannels = new ConcurrentHashMap<HttpChannel, CloseListener>();
    private final NodeClient client;
    private final HttpChannel httpChannel;

    public RestCancellableNodeClient(NodeClient client, HttpChannel httpChannel) {
        super(client);
        this.client = client;
        this.httpChannel = httpChannel;
    }

    public static int getNumChannels() {
        return httpChannels.size();
    }

    static int getNumTasks() {
        return httpChannels.values().stream().mapToInt(CloseListener::getNumTasks).sum();
    }

    static int getNumTasks(HttpChannel channel) {
        CloseListener listener = httpChannels.get(channel);
        return listener == null ? 0 : listener.getNumTasks();
    }

    @Override
    public <Request extends ActionRequest, Response extends ActionResponse> void doExecute(ActionType<Response> action, Request request, final ActionListener<Response> listener) {
        final CloseListener closeListener = httpChannels.computeIfAbsent(this.httpChannel, channel -> new CloseListener());
        final TaskHolder taskHolder = new TaskHolder();
        Task task = this.client.executeLocally(action, request, new ActionListener<Response>(){

            @Override
            public void onResponse(Response response) {
                try {
                    closeListener.unregisterTask(taskHolder);
                }
                finally {
                    listener.onResponse(response);
                }
            }

            @Override
            public void onFailure(Exception e) {
                try {
                    closeListener.unregisterTask(taskHolder);
                }
                finally {
                    listener.onFailure(e);
                }
            }
        });
        assert (task instanceof CancellableTask) : action.name() + " is not cancellable";
        TaskId taskId = new TaskId(this.client.getLocalNodeId(), task.getId());
        closeListener.registerTask(taskHolder, taskId);
        closeListener.maybeRegisterChannel(this.httpChannel);
    }

    private void cancelTask(TaskId taskId) {
        CancelTasksRequest req = ((CancelTasksRequest)new CancelTasksRequest().setTaskId(taskId)).setReason("http channel [" + this.httpChannel + "] closed");
        new OriginSettingClient(this.client, "tasks").admin().cluster().cancelTasks(req, ActionListener.wrap(() -> {}));
    }

    private class CloseListener
    implements ActionListener<Void> {
        private final AtomicReference<HttpChannel> channel = new AtomicReference();
        private final Set<TaskId> tasks = new HashSet<TaskId>();

        CloseListener() {
        }

        synchronized int getNumTasks() {
            return this.tasks.size();
        }

        void maybeRegisterChannel(HttpChannel httpChannel) {
            if (this.channel.compareAndSet(null, httpChannel)) {
                httpChannel.addCloseListener(this);
            }
        }

        synchronized void registerTask(TaskHolder taskHolder, TaskId taskId) {
            taskHolder.taskId = taskId;
            if (!taskHolder.completed) {
                this.tasks.add(taskId);
            }
        }

        synchronized void unregisterTask(TaskHolder taskHolder) {
            if (taskHolder.taskId != null) {
                this.tasks.remove(taskHolder.taskId);
            }
            taskHolder.completed = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onResponse(Void aVoid) {
            ArrayList<TaskId> toCancel;
            HttpChannel httpChannel = this.channel.get();
            assert (httpChannel != null) : "channel not registered";
            CloseListener closeListener = (CloseListener)httpChannels.remove(httpChannel);
            assert (closeListener != null) : "channel not found in the map of tracked channels";
            CloseListener closeListener2 = this;
            synchronized (closeListener2) {
                toCancel = new ArrayList<TaskId>(this.tasks);
                this.tasks.clear();
            }
            for (TaskId taskId : toCancel) {
                RestCancellableNodeClient.this.cancelTask(taskId);
            }
        }

        @Override
        public void onFailure(Exception e) {
            this.onResponse(null);
        }
    }

    private static class TaskHolder {
        private TaskId taskId;
        private boolean completed = false;

        private TaskHolder() {
        }
    }
}

