/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.text.ParseException;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.geo.GeometryParser;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.geo.SpatialStrategy;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.mapper.GeoShapeQueryable;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractGeometryQueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class GeoShapeQueryBuilder
extends AbstractGeometryQueryBuilder<GeoShapeQueryBuilder> {
    public static final String NAME = "geo_shape";
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(GeoShapeQueryBuilder.class);
    protected static final ParseField STRATEGY_FIELD = new ParseField("strategy", new String[0]);
    private SpatialStrategy strategy;

    public GeoShapeQueryBuilder(String fieldName, Geometry shape) {
        super(fieldName, shape);
    }

    public GeoShapeQueryBuilder(String fieldName, Supplier<Geometry> shapeSupplier, String indexedShapeId, @Nullable String indexedShapeType) {
        super(fieldName, shapeSupplier, indexedShapeId, indexedShapeType);
    }

    @Deprecated
    public GeoShapeQueryBuilder(String fieldName, String indexedShapeId, String indexedShapeType) {
        super(fieldName, indexedShapeId, indexedShapeType);
    }

    public GeoShapeQueryBuilder(String fieldName, String indexedShapeId) {
        super(fieldName, indexedShapeId);
    }

    public GeoShapeQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.strategy = in.readOptionalWriteable(SpatialStrategy::readFromStream);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        super.doWriteTo(out);
        out.writeOptionalWriteable(this.strategy);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public GeoShapeQueryBuilder relation(ShapeRelation relation) {
        if (relation == null) {
            throw new IllegalArgumentException("No Shape Relation defined");
        }
        if (SpatialStrategy.TERM.equals(this.strategy) && relation != ShapeRelation.INTERSECTS) {
            throw new IllegalArgumentException("current strategy [" + this.strategy.getStrategyName() + "] only supports relation [" + ShapeRelation.INTERSECTS.getRelationName() + "] found relation [" + relation.getRelationName() + "]");
        }
        this.relation = relation;
        return this;
    }

    public GeoShapeQueryBuilder strategy(SpatialStrategy strategy) {
        if (strategy != null && strategy == SpatialStrategy.TERM && this.relation != ShapeRelation.INTERSECTS) {
            throw new IllegalArgumentException("strategy [" + strategy.getStrategyName() + "] only supports relation [" + ShapeRelation.INTERSECTS.getRelationName() + "] found relation [" + this.relation.getRelationName() + "]");
        }
        this.strategy = strategy;
        return this;
    }

    public SpatialStrategy strategy() {
        return this.strategy;
    }

    @Override
    public void doShapeQueryXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.strategy != null) {
            builder.field(STRATEGY_FIELD.getPreferredName(), this.strategy.getStrategyName());
        }
    }

    protected GeoShapeQueryBuilder newShapeQueryBuilder(String fieldName, Geometry shape) {
        return new GeoShapeQueryBuilder(fieldName, shape);
    }

    protected GeoShapeQueryBuilder newShapeQueryBuilder(String fieldName, Supplier<Geometry> shapeSupplier, String indexedShapeId, String indexedShapeType) {
        return new GeoShapeQueryBuilder(fieldName, shapeSupplier, indexedShapeId, indexedShapeType);
    }

    @Override
    public Query buildShapeQuery(SearchExecutionContext context, MappedFieldType fieldType) {
        if (!(fieldType instanceof GeoShapeQueryable)) {
            throw new QueryShardException(context, "Field [" + this.fieldName + "] is of unsupported type [" + fieldType.typeName() + "] for [" + NAME + "] query", new Object[0]);
        }
        GeoShapeQueryable ft = (GeoShapeQueryable)((Object)fieldType);
        return new ConstantScoreQuery(ft.geoShapeQuery(this.shape, fieldType.name(), this.strategy, this.relation, context));
    }

    @Override
    protected boolean doEquals(GeoShapeQueryBuilder other) {
        return super.doEquals(other) && Objects.equals(this.strategy, other.strategy);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(super.doHashCode(), this.strategy);
    }

    @Override
    protected GeoShapeQueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        GeoShapeQueryBuilder builder = (GeoShapeQueryBuilder)super.doRewrite(queryRewriteContext);
        builder.strategy(this.strategy);
        return builder;
    }

    public static GeoShapeQueryBuilder fromXContent(XContentParser parser) throws IOException {
        ParsedGeoShapeQueryParams pgsqp = (ParsedGeoShapeQueryParams)AbstractGeometryQueryBuilder.parsedParamsFromXContent(parser, new ParsedGeoShapeQueryParams());
        if (pgsqp.type != null) {
            deprecationLogger.critical(DeprecationCategory.TYPES, "geo_share_query_with_types", "[types removal] Types are deprecated in [geo_shape] queries. The type should no longer be specified in the [indexed_shape] section.", new Object[0]);
        }
        GeoShapeQueryBuilder builder = pgsqp.shape != null ? new GeoShapeQueryBuilder(pgsqp.fieldName, pgsqp.shape) : new GeoShapeQueryBuilder(pgsqp.fieldName, pgsqp.id, pgsqp.type);
        if (pgsqp.index != null) {
            builder.indexedShapeIndex(pgsqp.index);
        }
        if (pgsqp.shapePath != null) {
            builder.indexedShapePath(pgsqp.shapePath);
        }
        if (pgsqp.shapeRouting != null) {
            builder.indexedShapeRouting(pgsqp.shapeRouting);
        }
        if (pgsqp.relation != null) {
            builder.relation(pgsqp.relation);
        }
        if (pgsqp.strategy != null) {
            builder.strategy(pgsqp.strategy);
        }
        if (pgsqp.queryName != null) {
            builder.queryName(pgsqp.queryName);
        }
        builder.boost(pgsqp.boost);
        builder.ignoreUnmapped(pgsqp.ignoreUnmapped);
        return builder;
    }

    private static class ParsedGeoShapeQueryParams
    extends AbstractGeometryQueryBuilder.ParsedGeometryQueryParams {
        SpatialStrategy strategy;
        private final GeometryParser geometryParser = new GeometryParser(true, true, true);

        private ParsedGeoShapeQueryParams() {
        }

        @Override
        protected boolean parseXContentField(XContentParser parser) throws IOException {
            if (AbstractGeometryQueryBuilder.SHAPE_FIELD.match(parser.currentName(), parser.getDeprecationHandler())) {
                try {
                    this.shape = this.geometryParser.parse(parser);
                }
                catch (ParseException e) {
                    throw new IOException(e);
                }
                return true;
            }
            if (STRATEGY_FIELD.match(parser.currentName(), parser.getDeprecationHandler())) {
                String strategyName = parser.text();
                SpatialStrategy strategy = SpatialStrategy.fromString(strategyName, deprecationLogger);
                if (strategy == null) {
                    throw new ParsingException(parser.getTokenLocation(), "Unknown strategy [" + strategyName + " ]", new Object[0]);
                }
                this.strategy = strategy;
                return true;
            }
            return false;
        }
    }
}

