/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;

public class MappingMetadata
extends AbstractDiffable<MappingMetadata> {
    private final String type;
    private final CompressedXContent source;
    private Routing routing;

    public MappingMetadata(DocumentMapper docMapper) {
        this.type = docMapper.type();
        this.source = docMapper.mappingSource();
        this.routing = new Routing(docMapper.routingFieldMapper().required());
    }

    public MappingMetadata(CompressedXContent mapping) {
        this.source = mapping;
        Map mappingMap = (Map)XContentHelper.convertToMap(mapping.compressedReference(), true).v2();
        if (mappingMap.size() != 1) {
            throw new IllegalStateException("Can't derive type from mapping, no root type: " + mapping.string());
        }
        this.type = (String)mappingMap.keySet().iterator().next();
        this.initMappers((Map)mappingMap.get(this.type));
    }

    public MappingMetadata(String type, Map<String, Object> mapping) throws IOException {
        this.type = type;
        this.source = new CompressedXContent((builder, params) -> builder.mapContents(mapping), XContentType.JSON, ToXContent.EMPTY_PARAMS);
        Map withoutType = mapping;
        if (mapping.size() == 1 && mapping.containsKey(type)) {
            withoutType = (Map)mapping.get(type);
        }
        this.initMappers(withoutType);
    }

    private void initMappers(Map<String, Object> withoutType) {
        if (withoutType.containsKey("_routing")) {
            boolean required = false;
            Map routingNode = (Map)withoutType.get("_routing");
            for (Map.Entry entry : routingNode.entrySet()) {
                String fieldName = (String)entry.getKey();
                Object fieldNode = entry.getValue();
                if (!fieldName.equals("required")) continue;
                try {
                    required = XContentMapValues.nodeBooleanValue(fieldNode);
                }
                catch (IllegalArgumentException ex) {
                    throw new IllegalArgumentException("Failed to create mapping for type [" + this.type() + "]. Illegal value in field [_routing.required].", ex);
                }
            }
            this.routing = new Routing(required);
        } else {
            this.routing = Routing.EMPTY;
        }
    }

    void updateDefaultMapping(MappingMetadata defaultMapping) {
        if (this.routing == Routing.EMPTY) {
            this.routing = defaultMapping.routing();
        }
    }

    public String type() {
        return this.type;
    }

    public CompressedXContent source() {
        return this.source;
    }

    public Map<String, Object> sourceAsMap() throws ElasticsearchParseException {
        Map mapping = (Map)XContentHelper.convertToMap(this.source.compressedReference(), true).v2();
        if (mapping.size() == 1 && mapping.containsKey(this.type())) {
            mapping = (Map)mapping.get(this.type());
        }
        return mapping;
    }

    public Map<String, Object> getSourceAsMap() throws ElasticsearchParseException {
        return this.sourceAsMap();
    }

    public Routing routing() {
        return this.routing;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.type());
        this.source().writeTo(out);
        out.writeBoolean(this.routing().required());
        if (out.getVersion().before(Version.V_6_0_0_alpha1)) {
            out.writeBoolean(false);
            out.writeString(DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.pattern());
            out.writeOptionalString("now");
            out.writeOptionalBoolean(null);
        }
        if (out.getVersion().before(Version.V_7_0_0)) {
            out.writeBoolean(false);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappingMetadata that = (MappingMetadata)o;
        if (!this.routing.equals(that.routing)) {
            return false;
        }
        if (!this.source.equals(that.source)) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.source.hashCode();
        result = 31 * result + this.routing.hashCode();
        return result;
    }

    public MappingMetadata(StreamInput in) throws IOException {
        this.type = in.readString();
        this.source = CompressedXContent.readCompressedString(in);
        this.routing = new Routing(in.readBoolean());
        if (in.getVersion().before(Version.V_6_0_0_alpha1)) {
            boolean enabled = in.readBoolean();
            if (enabled) {
                throw new IllegalArgumentException("_timestamp may not be enabled");
            }
            in.readString();
            in.readOptionalString();
            in.readOptionalBoolean();
        }
        if (in.getVersion().before(Version.V_7_0_0)) {
            in.readBoolean();
        }
    }

    public static Diff<MappingMetadata> readDiffFrom(StreamInput in) throws IOException {
        return MappingMetadata.readDiffFrom(MappingMetadata::new, in);
    }

    public static class Routing {
        public static final Routing EMPTY = new Routing(false);
        private final boolean required;

        public Routing(boolean required) {
            this.required = required;
        }

        public boolean required() {
            return this.required;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Routing routing = (Routing)o;
            return this.required == routing.required;
        }

        public int hashCode() {
            return this.getClass().hashCode() + (this.required ? 1 : 0);
        }
    }
}

