/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.versionfield;

import java.io.IOException;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.xpack.versionfield.VersionEncoder;

public final class VersionScriptDocValues
extends ScriptDocValues<String> {
    private final SortedSetDocValues in;
    private long[] ords = new long[0];
    private int count;

    public VersionScriptDocValues(SortedSetDocValues in) {
        this.in = in;
    }

    public void setNextDocId(int docId) throws IOException {
        this.count = 0;
        if (this.in.advanceExact(docId)) {
            long ord = this.in.nextOrd();
            while (ord != -1L) {
                this.ords = ArrayUtil.grow((long[])this.ords, (int)(this.count + 1));
                this.ords[this.count++] = ord;
                ord = this.in.nextOrd();
            }
        }
    }

    public String getValue() {
        return this.get(0);
    }

    public String get(int index) {
        if (this.count == 0) {
            throw new IllegalStateException("A document doesn't have a value for a field! Use doc[<field>].size()==0 to check if a document is missing a field!");
        }
        try {
            return VersionEncoder.decodeVersion(this.in.lookupOrd(this.ords[index]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int size() {
        return this.count;
    }
}

