/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.topmetrics;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.MultiValuesSourceFieldConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ContextParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.analytics.topmetrics.TopMetricsAggregator;
import org.elasticsearch.xpack.analytics.topmetrics.TopMetricsAggregatorFactory;

public class TopMetricsAggregationBuilder
extends AbstractAggregationBuilder<TopMetricsAggregationBuilder> {
    public static final String NAME = "top_metrics";
    public static final ParseField METRIC_FIELD = new ParseField("metrics", new String[0]);
    static final ValuesSourceRegistry.RegistryKey<TopMetricsAggregator.MetricValuesSupplier> REGISTRY_KEY = new ValuesSourceRegistry.RegistryKey("top_metrics", TopMetricsAggregator.MetricValuesSupplier.class);
    private static final int DEFAULT_SIZE = 1;
    public static final ConstructingObjectParser<TopMetricsAggregationBuilder, String> PARSER = new ConstructingObjectParser("top_metrics", false, (args, name) -> {
        int size;
        List sorts = (List)args[0];
        int n = size = args[1] == null ? 1 : (Integer)args[1];
        if (size < 1) {
            throw new IllegalArgumentException("[size] must be more than 0 but was [" + size + "]");
        }
        List metricFields = (List)args[2];
        return new TopMetricsAggregationBuilder((String)name, sorts, size, metricFields);
    });
    private final List<SortBuilder<?>> sortBuilders;
    private final int size;
    private final List<MultiValuesSourceFieldConfig> metricFields;

    public static void registerAggregators(ValuesSourceRegistry.Builder registry) {
        registry.registerUsage(NAME);
        registry.register(REGISTRY_KEY, org.elasticsearch.core.List.of((Object)CoreValuesSourceType.NUMERIC), TopMetricsAggregator::buildNumericMetricValues, false);
        registry.register(REGISTRY_KEY, org.elasticsearch.core.List.of((Object)CoreValuesSourceType.BOOLEAN, (Object)CoreValuesSourceType.DATE), TopMetricsAggregator.LongMetricValues::new, false);
        registry.register(REGISTRY_KEY, org.elasticsearch.core.List.of((Object)CoreValuesSourceType.KEYWORD, (Object)CoreValuesSourceType.IP), TopMetricsAggregator.SegmentOrdsValues::new, false);
    }

    public TopMetricsAggregationBuilder(String name, List<SortBuilder<?>> sortBuilders, int size, List<MultiValuesSourceFieldConfig> metricFields) {
        super(name);
        if (sortBuilders.size() != 1) {
            throw new IllegalArgumentException("[sort] must contain exactly one sort");
        }
        this.sortBuilders = sortBuilders;
        this.size = size;
        this.metricFields = metricFields;
    }

    public TopMetricsAggregationBuilder(TopMetricsAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super((AbstractAggregationBuilder)clone, factoriesBuilder, metadata);
        this.sortBuilders = clone.sortBuilders;
        this.size = clone.size;
        this.metricFields = clone.metricFields;
    }

    public TopMetricsAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        List sortBuilders;
        this.sortBuilders = sortBuilders = in.readNamedWriteableList(SortBuilder.class);
        this.size = in.readVInt();
        this.metricFields = in.readList(MultiValuesSourceFieldConfig::new);
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteableList(this.sortBuilders);
        out.writeVInt(this.size);
        out.writeList(this.metricFields);
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new TopMetricsAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.NONE;
    }

    protected AggregatorFactory doBuild(AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        return new TopMetricsAggregatorFactory(this.name, context, parent, subFactoriesBuilder, this.metadata, this.sortBuilders, this.size, this.metricFields);
    }

    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray(SearchSourceBuilder.SORT_FIELD.getPreferredName());
        for (SortBuilder<?> sort : this.sortBuilders) {
            sort.toXContent(builder, params);
        }
        builder.endArray();
        builder.field(SearchSourceBuilder.SIZE_FIELD.getPreferredName(), this.size);
        builder.startArray(METRIC_FIELD.getPreferredName());
        for (MultiValuesSourceFieldConfig metricField : this.metricFields) {
            metricField.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public String getType() {
        return NAME;
    }

    List<SortBuilder<?>> getSortBuilders() {
        return this.sortBuilders;
    }

    int getSize() {
        return this.size;
    }

    List<MultiValuesSourceFieldConfig> getMetricFields() {
        return this.metricFields;
    }

    public Optional<Set<String>> getOutputFieldNames() {
        return Optional.of(this.metricFields.stream().map(mf -> mf.getFieldName()).collect(Collectors.toSet()));
    }

    private static /* synthetic */ MultiValuesSourceFieldConfig lambda$static$2(ContextParser metricParser, XContentParser p, String n) throws IOException {
        return ((MultiValuesSourceFieldConfig.Builder)metricParser.parse(p, null)).build();
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, n) -> SortBuilder.fromXContent((XContentParser)p), SearchSourceBuilder.SORT_FIELD, ObjectParser.ValueType.OBJECT_ARRAY_OR_STRING);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), SearchSourceBuilder.SIZE_FIELD);
        ObjectParser metricParser = MultiValuesSourceFieldConfig.PARSER.build(true, false, false, false);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (arg_0, arg_1) -> TopMetricsAggregationBuilder.lambda$static$2((ContextParser)metricParser, arg_0, arg_1), METRIC_FIELD);
    }
}

