/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.utils.persistence;

import java.util.Objects;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.IndexingPressure;

public class LimitAwareBulkIndexer
implements AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger(LimitAwareBulkIndexer.class);
    private static final int BATCH_SIZE = 1000;
    private final long bytesLimit;
    private final Consumer<BulkRequest> executor;
    private BulkRequest currentBulkRequest = new BulkRequest();
    private long currentRamBytes;

    public LimitAwareBulkIndexer(Settings settings, Consumer<BulkRequest> executor) {
        this((long)Math.ceil(0.5 * (double)((ByteSizeValue)IndexingPressure.MAX_INDEXING_BYTES.get(settings)).getBytes()), executor);
    }

    LimitAwareBulkIndexer(long bytesLimit, Consumer<BulkRequest> executor) {
        this.bytesLimit = bytesLimit;
        this.executor = Objects.requireNonNull(executor);
    }

    public void addAndExecuteIfNeeded(IndexRequest indexRequest) {
        if (this.currentRamBytes + indexRequest.ramBytesUsed() > this.bytesLimit || this.currentBulkRequest.numberOfActions() == 1000) {
            this.execute();
        }
        this.currentBulkRequest.add(indexRequest);
        this.currentRamBytes += indexRequest.ramBytesUsed();
    }

    private void execute() {
        if (this.currentBulkRequest.numberOfActions() > 0) {
            LOGGER.debug("Executing bulk request; current bytes [{}]; bytes limit [{}]; number of actions [{}]", (Object)this.currentRamBytes, (Object)this.bytesLimit, (Object)this.currentBulkRequest.numberOfActions());
            this.executor.accept(this.currentBulkRequest);
            this.currentBulkRequest = new BulkRequest();
            this.currentRamBytes = 0L;
        }
    }

    @Override
    public void close() {
        this.execute();
    }
}

