/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import com.maxmind.db.NoCache;
import com.maxmind.db.NodeCache;
import com.maxmind.db.Reader;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.model.AbstractResponse;
import com.maxmind.geoip2.model.AsnResponse;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.model.CountryResponse;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.CheckedBiFunction;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.ingest.geoip.GeoIpCache;

class DatabaseReaderLazyLoader
implements Closeable {
    private static final boolean LOAD_DATABASE_ON_HEAP = Booleans.parseBoolean((String)System.getProperty("es.geoip.load_db_on_heap", "false"));
    private static final Logger LOGGER = LogManager.getLogger(DatabaseReaderLazyLoader.class);
    private final String md5;
    private final GeoIpCache cache;
    private final Path databasePath;
    private final CheckedSupplier<DatabaseReader, IOException> loader;
    final SetOnce<DatabaseReader> databaseReader;
    final SetOnce<String> databaseType;
    private volatile boolean deleteDatabaseFileOnClose;
    private final AtomicInteger currentUsages = new AtomicInteger(0);

    DatabaseReaderLazyLoader(GeoIpCache cache, Path databasePath, String md5) {
        this(cache, databasePath, md5, DatabaseReaderLazyLoader.createDatabaseLoader(databasePath));
    }

    DatabaseReaderLazyLoader(GeoIpCache cache, Path databasePath, String md5, CheckedSupplier<DatabaseReader, IOException> loader) {
        this.cache = cache;
        this.databasePath = Objects.requireNonNull(databasePath);
        this.md5 = md5;
        this.loader = Objects.requireNonNull(loader);
        this.databaseReader = new SetOnce();
        this.databaseType = new SetOnce();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String getDatabaseType() throws IOException {
        if (this.databaseType.get() == null) {
            SetOnce<String> setOnce = this.databaseType;
            synchronized (setOnce) {
                if (this.databaseType.get() == null) {
                    long fileSize = this.databaseFileSize();
                    if (fileSize <= 512L) {
                        throw new IOException("unexpected file length [" + fileSize + "] for [" + this.databasePath + "]");
                    }
                    int[] databaseTypeMarker = new int[]{100, 97, 116, 97, 98, 97, 115, 101, 95, 116, 121, 112, 101};
                    try (InputStream in = this.databaseInputStream();){
                        int actualBytesRead;
                        long skipped = in.skip(fileSize - 512L);
                        if (skipped != fileSize - 512L) {
                            throw new IOException("failed to skip [" + (fileSize - 512L) + "] bytes while reading [" + this.databasePath + "]");
                        }
                        byte[] tail = new byte[512];
                        int read = 0;
                        do {
                            if ((actualBytesRead = in.read(tail, read, 512 - read)) != -1) continue;
                            throw new IOException("unexpected end of stream [" + this.databasePath + "] after reading [" + read + "] bytes");
                        } while ((read += actualBytesRead) != 512);
                        int metadataOffset = -1;
                        int markerOffset = 0;
                        for (int i = 0; i < tail.length; ++i) {
                            byte b = tail[i];
                            markerOffset = b == databaseTypeMarker[markerOffset] ? ++markerOffset : 0;
                            if (markerOffset != databaseTypeMarker.length) continue;
                            metadataOffset = i + 1;
                            break;
                        }
                        if (metadataOffset == -1) {
                            throw new IOException("database type marker not found");
                        }
                        int offsetByte = tail[metadataOffset] & 0xFF;
                        int type = offsetByte >>> 5;
                        if (type != 2) {
                            throw new IOException("type must be UTF-8 string");
                        }
                        int size = offsetByte & 0x1F;
                        this.databaseType.set((Object)new String(tail, metadataOffset + 1, size, StandardCharsets.UTF_8));
                    }
                }
            }
        }
        return (String)this.databaseType.get();
    }

    long databaseFileSize() throws IOException {
        return Files.size(this.databasePath);
    }

    InputStream databaseInputStream() throws IOException {
        return Files.newInputStream(this.databasePath, new OpenOption[0]);
    }

    @Nullable
    CityResponse getCity(InetAddress ipAddress) {
        return (CityResponse)this.getResponse(ipAddress, DatabaseReader::tryCity);
    }

    @Nullable
    CountryResponse getCountry(InetAddress ipAddress) {
        return (CountryResponse)this.getResponse(ipAddress, DatabaseReader::tryCountry);
    }

    @Nullable
    AsnResponse getAsn(InetAddress ipAddress) {
        return (AsnResponse)this.getResponse(ipAddress, DatabaseReader::tryAsn);
    }

    boolean preLookup() {
        return this.currentUsages.updateAndGet(current -> current < 0 ? current : current + 1) > 0;
    }

    void postLookup() throws IOException {
        if (this.currentUsages.updateAndGet(current -> current > 0 ? current - 1 : current + 1) == -1) {
            this.doClose();
        }
    }

    int current() {
        return this.currentUsages.get();
    }

    @Nullable
    private <T extends AbstractResponse> T getResponse(InetAddress ipAddress, CheckedBiFunction<DatabaseReader, InetAddress, Optional<T>, Exception> responseProvider) {
        SpecialPermission.check();
        return (T)AccessController.doPrivileged(() -> this.cache.putIfAbsent(ipAddress, this.databasePath.toString(), ip -> {
            try {
                return ((Optional)responseProvider.apply((Object)this.get(), (Object)ipAddress)).orElse(null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatabaseReader get() throws IOException {
        if (this.databaseReader.get() == null) {
            SetOnce<DatabaseReader> setOnce = this.databaseReader;
            synchronized (setOnce) {
                if (this.databaseReader.get() == null) {
                    this.databaseReader.set((Object)((DatabaseReader)this.loader.get()));
                    LOGGER.debug("loaded [{}] geo-IP database", (Object)this.databasePath);
                }
            }
        }
        return (DatabaseReader)this.databaseReader.get();
    }

    String getMd5() {
        return this.md5;
    }

    public void close(boolean deleteDatabaseFileOnClose) throws IOException {
        this.deleteDatabaseFileOnClose = deleteDatabaseFileOnClose;
        this.close();
    }

    @Override
    public void close() throws IOException {
        if (this.currentUsages.updateAndGet(u -> -1 - u) == -1) {
            this.doClose();
        }
    }

    private void doClose() throws IOException {
        IOUtils.close((Closeable)((Closeable)this.databaseReader.get()));
        int numEntriesEvicted = this.cache.purgeCacheEntriesForDatabase(this.databasePath);
        LOGGER.info("evicted [{}] entries from cache after reloading database [{}]", (Object)numEntriesEvicted, (Object)this.databasePath);
        if (this.deleteDatabaseFileOnClose) {
            LOGGER.info("deleting [{}]", (Object)this.databasePath);
            Files.delete(this.databasePath);
        }
    }

    private static CheckedSupplier<DatabaseReader, IOException> createDatabaseLoader(Path databasePath) {
        return () -> {
            DatabaseReader.Builder builder = DatabaseReaderLazyLoader.createDatabaseBuilder(databasePath).withCache((NodeCache)NoCache.getInstance());
            if (LOAD_DATABASE_ON_HEAP) {
                builder.fileMode(Reader.FileMode.MEMORY);
            } else {
                builder.fileMode(Reader.FileMode.MEMORY_MAPPED);
            }
            return builder.build();
        };
    }

    @SuppressForbidden(reason="Maxmind API requires java.io.File")
    private static DatabaseReader.Builder createDatabaseBuilder(Path databasePath) {
        return new DatabaseReader.Builder(databasePath.toFile());
    }
}

