/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.http;

import java.util.Collections;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.monitoring.exporter.MonitoringTemplateUtils;
import org.elasticsearch.xpack.monitoring.exporter.http.HttpResource;
import org.elasticsearch.xpack.monitoring.exporter.http.PublishableHttpResource;

public class PipelineHttpResource
extends PublishableHttpResource {
    private static final Logger logger = LogManager.getLogger(PipelineHttpResource.class);
    private final String pipelineName;
    private final Supplier<byte[]> pipeline;

    public PipelineHttpResource(String resourceOwnerName, @Nullable TimeValue masterTimeout, String pipelineName, Supplier<byte[]> pipeline) {
        super(resourceOwnerName, masterTimeout, PublishableHttpResource.RESOURCE_VERSION_PARAMETERS);
        this.pipelineName = Objects.requireNonNull(pipelineName);
        this.pipeline = Objects.requireNonNull(pipeline);
    }

    @Override
    protected void doCheck(RestClient client, ActionListener<Boolean> listener) {
        this.versionCheckForResource(client, listener, logger, "/_ingest/pipeline", this.pipelineName, "monitoring pipeline", this.resourceOwnerName, "monitoring cluster", XContentType.JSON.xContent(), MonitoringTemplateUtils.LAST_UPDATED_VERSION);
    }

    @Override
    protected void doPublish(RestClient client, ActionListener<HttpResource.ResourcePublishResult> listener) {
        this.putResource(client, listener, logger, "/_ingest/pipeline", this.pipelineName, Collections.emptyMap(), this::pipelineToHttpEntity, "monitoring pipeline", this.resourceOwnerName, "monitoring cluster");
    }

    HttpEntity pipelineToHttpEntity() {
        return new ByteArrayEntity(this.pipeline.get(), ContentType.APPLICATION_JSON);
    }
}

