/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid;

import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileUtils;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.AbstractGeoTileGridTiler;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoShapeCellValues;

public class UnboundedGeoTileGridTiler
extends AbstractGeoTileGridTiler {
    private final long maxTiles;

    public UnboundedGeoTileGridTiler(int precision) {
        super(precision);
        this.maxTiles = this.tiles * this.tiles;
    }

    @Override
    protected boolean validTile(int x, int y, int z) {
        return true;
    }

    @Override
    protected long getMaxCells() {
        return this.maxTiles;
    }

    @Override
    protected int setValuesForFullyContainedTile(int xTile, int yTile, int zTile, GeoShapeCellValues values, int valuesIndex) {
        int splits = 1 << this.precision - zTile;
        int minX = xTile * splits;
        int minY = yTile * splits;
        int maxX = minX + splits;
        int maxY = minY + splits;
        for (int i = minX; i < maxX; ++i) {
            for (int j = minY; j < maxY; ++j) {
                assert (this.validTile(i, j, this.precision));
                values.add(valuesIndex++, GeoTileUtils.longEncodeTiles((int)this.precision, (long)i, (long)j));
            }
        }
        return valuesIndex;
    }
}

