/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid;

import java.io.IOException;
import org.elasticsearch.geometry.utils.Geohash;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoRelation;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoShapeValues;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoGridTiler;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoShapeCellValues;

abstract class AbstractGeoHashGridTiler
extends GeoGridTiler {
    AbstractGeoHashGridTiler(int precision) {
        super(precision);
    }

    protected abstract boolean validHash(String var1);

    @Override
    public long encode(double x, double y) {
        return Geohash.longEncode((double)x, (double)y, (int)this.precision);
    }

    @Override
    public int setValues(GeoShapeCellValues values, GeoShapeValues.GeoShapeValue geoValue) throws IOException {
        if (this.precision == 0) {
            return 1;
        }
        GeoShapeValues.BoundingBox bounds = geoValue.boundingBox();
        assert (bounds.minX() <= bounds.maxX());
        if (bounds.minX() == bounds.maxX() && bounds.minY() == bounds.maxY()) {
            return this.setValue(values, geoValue, bounds);
        }
        return this.setValuesByRasterization("", values, 0, geoValue);
    }

    protected int setValuesByBruteForceScan(GeoShapeCellValues values, GeoShapeValues.GeoShapeValue geoValue, GeoShapeValues.BoundingBox bounds) throws IOException {
        int idx = 0;
        String min = Geohash.stringEncode((double)bounds.minX(), (double)bounds.minY(), (int)this.precision);
        String max = Geohash.stringEncode((double)bounds.maxX(), (double)bounds.maxY(), (int)this.precision);
        String minNeighborBelow = Geohash.getNeighbor((String)min, (int)this.precision, (int)0, (int)-1);
        double minY = Geohash.decodeLatitude((String)(minNeighborBelow == null ? min : minNeighborBelow));
        double minX = Geohash.decodeLongitude((String)min);
        double maxY = Geohash.decodeLatitude((String)max);
        double maxX = Geohash.decodeLongitude((String)max);
        for (double i = minX; i <= maxX; i += Geohash.lonWidthInDegrees((int)this.precision)) {
            for (double j = minY; j <= maxY; j += Geohash.latHeightInDegrees((int)this.precision)) {
                String hash = Geohash.stringEncode((double)i, (double)j, (int)this.precision);
                GeoRelation relation = this.relateTile(geoValue, hash);
                if (relation == GeoRelation.QUERY_DISJOINT) continue;
                values.resizeCell(idx + 1);
                values.add(idx++, this.encode(i, j));
            }
        }
        return idx;
    }

    protected int setValue(GeoShapeCellValues docValues, GeoShapeValues.GeoShapeValue geoValue, GeoShapeValues.BoundingBox bounds) throws IOException {
        String hash = Geohash.stringEncode((double)bounds.minX(), (double)bounds.minY(), (int)this.precision);
        if (this.relateTile(geoValue, hash) != GeoRelation.QUERY_DISJOINT) {
            docValues.resizeCell(1);
            docValues.add(0, Geohash.longEncode((String)hash));
            return 1;
        }
        return 0;
    }

    private GeoRelation relateTile(GeoShapeValues.GeoShapeValue geoValue, String hash) throws IOException {
        return this.validHash(hash) ? geoValue.relate(Geohash.toBoundingBox((String)hash)) : GeoRelation.QUERY_DISJOINT;
    }

    protected int setValuesByRasterization(String hash, GeoShapeCellValues values, int valuesIndex, GeoShapeValues.GeoShapeValue geoValue) throws IOException {
        String[] hashes = Geohash.getSubGeohashes((String)hash);
        for (int i = 0; i < hashes.length; ++i) {
            GeoRelation relation = this.relateTile(geoValue, hashes[i]);
            if (relation == GeoRelation.QUERY_CROSSES) {
                if (hashes[i].length() == this.precision) {
                    values.resizeCell(valuesIndex + 1);
                    values.add(valuesIndex++, Geohash.longEncode((String)hashes[i]));
                    continue;
                }
                valuesIndex = this.setValuesByRasterization(hashes[i], values, valuesIndex, geoValue);
                continue;
            }
            if (relation != GeoRelation.QUERY_INSIDE) continue;
            if (hashes[i].length() == this.precision) {
                values.resizeCell(valuesIndex + 1);
                values.add(valuesIndex++, Geohash.longEncode((String)hashes[i]));
                continue;
            }
            int numTilesAtPrecision = this.getNumTilesAtPrecision(this.precision, hash.length());
            values.resizeCell(this.getNewSize(valuesIndex, numTilesAtPrecision + 1));
            valuesIndex = this.setValuesForFullyContainedTile(hashes[i], values, valuesIndex, this.precision);
        }
        return valuesIndex;
    }

    private int getNewSize(int valuesIndex, int increment) {
        long newSize = (long)valuesIndex + (long)increment;
        if (newSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Tile aggregation array overflow");
        }
        return (int)newSize;
    }

    private int getNumTilesAtPrecision(int finalPrecision, int currentPrecision) {
        long numTilesAtPrecision = Math.min((long)Math.pow(32.0, finalPrecision - currentPrecision) + 1L, this.getMaxCells());
        if (numTilesAtPrecision > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Tile aggregation array overflow");
        }
        return (int)numTilesAtPrecision;
    }

    protected int setValuesForFullyContainedTile(String hash, GeoShapeCellValues values, int valuesIndex, int targetPrecision) {
        String[] hashes = Geohash.getSubGeohashes((String)hash);
        for (int i = 0; i < hashes.length; ++i) {
            if (!this.validHash(hashes[i])) continue;
            if (hashes[i].length() == targetPrecision) {
                values.add(valuesIndex++, Geohash.longEncode((String)hashes[i]));
                continue;
            }
            valuesIndex = this.setValuesForFullyContainedTile(hashes[i], values, valuesIndex, targetPrecision);
        }
        return valuesIndex;
    }
}

