/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.annotations;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.directorywalker.DirectoryScanner;
import com.thoughtworks.qdox.directorywalker.FileVisitor;
import com.thoughtworks.qdox.directorywalker.SuffixFilter;
import com.thoughtworks.qdox.model.AbstractInheritableJavaEntity;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.testng.TestRunner;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotation;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.JDK14TagFactory;

public class JDK14AnnotationFinder
implements IAnnotationFinder {
    private JDK14TagFactory m_tagFactory = new JDK14TagFactory();
    private JavaDocBuilder m_docBuilder = new JavaDocBuilder();

    public void addSources(String[] filePaths) {
        if (filePaths == null) {
            if (TestRunner.getVerbose() > 1) {
                JDK14AnnotationFinder.ppp("Array of source paths is null");
            }
            return;
        }
        for (int i = 0; i < filePaths.length; ++i) {
            try {
                this.m_docBuilder.addSource(new FileReader(filePaths[i]));
                continue;
            }
            catch (FileNotFoundException fnfe) {
                JDK14AnnotationFinder.ppp("File does not exist [" + filePaths[i] + "]");
                continue;
            }
            catch (Throwable t) {
                Utils.log(this.getClass().getName(), 1, "[WARNING] cannot parse source: " + filePaths[i] + "\n    " + t.getMessage());
            }
        }
    }

    public void addSourceDirs(String[] dirPaths) {
        if (dirPaths == null) {
            if (TestRunner.getVerbose() > 1) {
                JDK14AnnotationFinder.ppp("Array of source directory paths is null");
            }
            return;
        }
        for (int i = 0; i < dirPaths.length; ++i) {
            File dir2 = new File(dirPaths[i]);
            DirectoryScanner scanner = new DirectoryScanner(dir2);
            scanner.addFilter(new SuffixFilter(".java"));
            scanner.scan(new FileVisitor(){

                public void visitFile(File currentFile) {
                    JDK14AnnotationFinder.this.addSources(new String[]{currentFile.getAbsolutePath()});
                }
            });
        }
    }

    public IAnnotation findAnnotation(Class cls, Class annotationClass) {
        return this.m_tagFactory.createTag(annotationClass, this.m_docBuilder.getClassByName(cls.getName()));
    }

    public IAnnotation findAnnotation(Method m, Class annotationClass) {
        return this.findMethodAnnotation(m.getName(), m.getParameterTypes(), m.getDeclaringClass(), annotationClass);
    }

    public IAnnotation findAnnotation(Constructor m, Class annotationClass) {
        String name = this.stripPackage(m.getName());
        return this.findMethodAnnotation(name, m.getParameterTypes(), m.getDeclaringClass(), annotationClass);
    }

    private String stripPackage(String name) {
        String result = name;
        int index = result.lastIndexOf(".");
        if (index > 0) {
            result = result.substring(index + 1);
        }
        return result;
    }

    private IAnnotation findMethodAnnotation(String methodName, Class[] parameterTypes, Class methodClass, Class annotationClass) {
        IAnnotation result = null;
        JavaClass jc = this.m_docBuilder.getClassByName(methodClass.getName());
        if (jc != null) {
            ArrayList<JavaMethod> methods = new ArrayList<JavaMethod>();
            JavaMethod[] allMethods = jc.getMethods();
            for (int i = 0; i < allMethods.length; ++i) {
                JavaMethod jm = allMethods[i];
                if (!this.methodsAreEqual(jm, methodName, parameterTypes)) continue;
                methods.add(jm);
            }
            JavaMethod method = null;
            if (methods.size() > 0) {
                method = (JavaMethod)methods.get(0);
                result = this.findTag(annotationClass, result, method);
            }
        } else {
            JDK14AnnotationFinder.ppp("COULDN'T RESOLVE CLASS " + methodClass.getName());
        }
        return result;
    }

    private boolean methodsAreEqual(JavaMethod jm, String methodName, Class[] parameterTypes) {
        boolean result = jm.getName().equals(methodName) && jm.getParameters().length == parameterTypes.length;
        return result;
    }

    private IAnnotation findTag(Class annotationClass, IAnnotation result, AbstractInheritableJavaEntity entity) {
        return this.m_tagFactory.createTag(annotationClass, entity);
    }

    private static void ppp(String s) {
        System.out.println("[JDK14AnnotationFinder] " + s);
    }
}

