/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.optimizers.impl.refl;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.mvel.ASTNode;
import org.mvel.Accessor;
import org.mvel.AccessorNode;
import org.mvel.CompileException;
import org.mvel.DataConversion;
import org.mvel.ExecutableStatement;
import org.mvel.PropertyAccessException;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.optimizers.AbstractOptimizer;
import org.mvel.optimizers.AccessorOptimizer;
import org.mvel.optimizers.impl.refl.ArrayAccessor;
import org.mvel.optimizers.impl.refl.ArrayAccessorNest;
import org.mvel.optimizers.impl.refl.ArrayLength;
import org.mvel.optimizers.impl.refl.ConstructorAccessor;
import org.mvel.optimizers.impl.refl.FieldAccessor;
import org.mvel.optimizers.impl.refl.Fold;
import org.mvel.optimizers.impl.refl.GetterAccessor;
import org.mvel.optimizers.impl.refl.IndexedCharSeqAccessor;
import org.mvel.optimizers.impl.refl.IndexedCharSeqAccessorNest;
import org.mvel.optimizers.impl.refl.ListAccessor;
import org.mvel.optimizers.impl.refl.ListAccessorNest;
import org.mvel.optimizers.impl.refl.MapAccessor;
import org.mvel.optimizers.impl.refl.MapAccessorNest;
import org.mvel.optimizers.impl.refl.MethodAccessor;
import org.mvel.optimizers.impl.refl.Return;
import org.mvel.optimizers.impl.refl.StaticReferenceAccessor;
import org.mvel.optimizers.impl.refl.StaticVarAccessor;
import org.mvel.optimizers.impl.refl.ThisValueAccessor;
import org.mvel.optimizers.impl.refl.Union;
import org.mvel.optimizers.impl.refl.VariableAccessor;
import org.mvel.optimizers.impl.refl.collection.ArrayCreator;
import org.mvel.optimizers.impl.refl.collection.ExprValueAccessor;
import org.mvel.optimizers.impl.refl.collection.ListCreator;
import org.mvel.optimizers.impl.refl.collection.MapCreator;
import org.mvel.util.ArrayTools;
import org.mvel.util.CollectionParser;
import org.mvel.util.ParseTools;
import org.mvel.util.PropertyTools;
import org.mvel.util.StringAppender;

public class ReflectiveAccessorOptimizer
extends AbstractOptimizer
implements AccessorOptimizer {
    private AccessorNode rootNode;
    private AccessorNode currNode;
    private Object ctx;
    private Object thisRef;
    private Object val;
    private VariableResolverFactory variableFactory;
    private static final int DONE = -1;
    private static final Object[] EMPTYARG = new Object[0];
    private static final Class[] EMPTYCLS = new Class[0];
    private boolean first = true;
    private static final Map<String, Accessor> REFLECTIVE_ACCESSOR_CACHE = new WeakHashMap<String, Accessor>();
    private Class returnType;

    public ReflectiveAccessorOptimizer() {
    }

    private ReflectiveAccessorOptimizer(char[] property, Object ctx, Object thisRef, VariableResolverFactory variableFactory) {
        this.expr = property;
        this.length = property != null ? property.length : 0;
        this.ctx = ctx;
        this.variableFactory = variableFactory;
        this.thisRef = thisRef;
    }

    public static Object get(String expression, Object ctx) {
        if (REFLECTIVE_ACCESSOR_CACHE.containsKey(expression)) {
            return REFLECTIVE_ACCESSOR_CACHE.get(expression).getValue(ctx, null, null);
        }
        Accessor accessor = new ReflectiveAccessorOptimizer().optimizeAccessor(expression.toCharArray(), ctx, null, null, false);
        REFLECTIVE_ACCESSOR_CACHE.put(expression, accessor);
        return accessor.getValue(ctx, null, null);
    }

    @Override
    public Accessor optimizeAccessor(char[] property, Object ctx, Object thisRef, VariableResolverFactory factory, boolean root) {
        this.currNode = null;
        this.rootNode = null;
        this.cursor = 0;
        this.start = 0;
        this.first = true;
        this.expr = property;
        this.length = property.length;
        this.ctx = ctx;
        this.thisRef = thisRef;
        this.variableFactory = factory;
        return this.compileGetChain();
    }

    private Accessor compileGetChain() {
        Object curr = this.ctx;
        try {
            while (this.cursor < this.length) {
                switch (this.nextSubToken()) {
                    case 0: {
                        curr = this.getBeanProperty(curr, this.capture());
                        break;
                    }
                    case 1: {
                        curr = this.getMethod(curr, this.capture());
                        break;
                    }
                    case 2: {
                        curr = this.getCollectionProperty(curr, this.capture());
                        break;
                    }
                }
                this.first = false;
                if (curr == null) continue;
                this.returnType = curr.getClass();
            }
            this.val = curr;
            return this.rootNode;
        }
        catch (InvocationTargetException e) {
            throw new PropertyAccessException("could not access property", e);
        }
        catch (IllegalAccessException e) {
            throw new PropertyAccessException("could not access property", e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new PropertyAccessException("array or collections index out of bounds (property: " + new String(this.expr) + ")", e);
        }
        catch (PropertyAccessException e) {
            throw new PropertyAccessException("failed to access property: <<" + new String(this.expr) + ">> in: " + (this.ctx != null ? this.ctx.getClass() : null), e);
        }
        catch (CompileException e) {
            throw e;
        }
        catch (NullPointerException e) {
            throw new PropertyAccessException("null pointer exception in property: " + new String(this.expr), e);
        }
        catch (Exception e) {
            throw new PropertyAccessException("unknown exception in expression: " + new String(this.expr), e);
        }
    }

    private void addAccessorNode(AccessorNode an) {
        if (this.rootNode == null) {
            this.rootNode = this.currNode = an;
        } else {
            this.currNode = this.currNode.setNextNode(an);
        }
    }

    private Object getBeanProperty(Object ctx, String property) throws IllegalAccessException, InvocationTargetException {
        Member member;
        if (this.first && this.variableFactory != null && this.variableFactory.isResolveable(property)) {
            VariableAccessor accessor = new VariableAccessor(property, this.variableFactory);
            this.addAccessorNode(accessor);
            return this.variableFactory.getVariableResolver(property).getValue();
        }
        Class<?> cls = ctx instanceof Class ? (Class<?>)ctx : (ctx != null ? ctx.getClass() : null);
        Member member2 = member = cls != null ? PropertyTools.getFieldOrAccessor(cls, property) : null;
        if (member instanceof Field) {
            FieldAccessor accessor = new FieldAccessor();
            accessor.setField((Field)member);
            this.addAccessorNode(accessor);
            return ((Field)member).get(ctx);
        }
        if (member != null) {
            Object o;
            try {
                o = ((Method)member).invoke(ctx, EMPTYARG);
                GetterAccessor accessor = new GetterAccessor((Method)member);
                this.addAccessorNode(accessor);
            }
            catch (IllegalAccessException e) {
                Method iFaceMeth = ParseTools.determineActualTargetMethod((Method)member);
                GetterAccessor accessor = new GetterAccessor(iFaceMeth);
                this.addAccessorNode(accessor);
                o = iFaceMeth.invoke(ctx, EMPTYARG);
            }
            return o;
        }
        if (ctx instanceof Map && ((Map)ctx).containsKey(property)) {
            MapAccessor accessor = new MapAccessor();
            accessor.setProperty(property);
            this.addAccessorNode(accessor);
            return ((Map)ctx).get(property);
        }
        if ("this".equals(property)) {
            ThisValueAccessor accessor = new ThisValueAccessor();
            this.addAccessorNode(accessor);
            return this.thisRef;
        }
        if (LITERALS.containsKey(property)) {
            StaticReferenceAccessor accessor = new StaticReferenceAccessor();
            accessor.setLiteral(LITERALS.get(property));
            this.addAccessorNode(accessor);
            return accessor.getLiteral();
        }
        Object tryStaticMethodRef = this.tryStaticAccess();
        if (tryStaticMethodRef != null) {
            if (tryStaticMethodRef instanceof Class) {
                StaticReferenceAccessor accessor = new StaticReferenceAccessor();
                accessor.setLiteral(tryStaticMethodRef);
                this.addAccessorNode(accessor);
                return tryStaticMethodRef;
            }
            StaticVarAccessor accessor = new StaticVarAccessor((Field)tryStaticMethodRef);
            this.addAccessorNode(accessor);
            return ((Field)tryStaticMethodRef).get(null);
        }
        if (ctx instanceof Class) {
            Class c = (Class)ctx;
            for (Method m : c.getMethods()) {
                if (!property.equals(m.getName())) continue;
                StaticReferenceAccessor accessor = new StaticReferenceAccessor();
                accessor.setLiteral(m);
                this.addAccessorNode(accessor);
                return m;
            }
        }
        throw new PropertyAccessException("could not access property ('" + property + "')");
    }

    private Object getCollectionProperty(Object ctx, String prop) throws Exception {
        if (prop.length() > 0) {
            ctx = this.getBeanProperty(ctx, prop);
        }
        int start = ++this.cursor;
        this.whiteSpaceSkip();
        if (this.cursor == this.length) {
            throw new PropertyAccessException("unterminated '['");
        }
        if (!this.scanTo(']')) {
            throw new PropertyAccessException("unterminated '['");
        }
        String item = new String(this.expr, start, this.cursor - start);
        boolean itemSubExpr = true;
        Object idx = null;
        try {
            idx = Integer.parseInt(item);
            itemSubExpr = false;
        }
        catch (Exception e) {
            // empty catch block
        }
        ExecutableStatement itemStmt = null;
        if (itemSubExpr) {
            itemStmt = (ExecutableStatement)ParseTools.subCompileExpression(item);
            idx = itemStmt.getValue(ctx, this.thisRef, this.variableFactory);
        }
        ++this.cursor;
        if (ctx instanceof Map) {
            if (itemSubExpr) {
                MapAccessorNest accessor = new MapAccessorNest();
                accessor.setProperty(itemStmt);
                this.addAccessorNode(accessor);
            } else {
                MapAccessor accessor = new MapAccessor();
                accessor.setProperty(Integer.parseInt(item));
                this.addAccessorNode(accessor);
            }
            return ((Map)ctx).get(idx);
        }
        if (ctx instanceof List) {
            if (itemSubExpr) {
                ListAccessorNest accessor = new ListAccessorNest();
                accessor.setIndex(itemStmt);
                this.addAccessorNode(accessor);
            } else {
                ListAccessor accessor = new ListAccessor();
                accessor.setIndex(Integer.parseInt(item));
                this.addAccessorNode(accessor);
            }
            return ((List)ctx).get((Integer)idx);
        }
        if (ctx instanceof Object[]) {
            if (itemSubExpr) {
                ArrayAccessorNest accessor = new ArrayAccessorNest();
                accessor.setIndex(itemStmt);
                this.addAccessorNode(accessor);
            } else {
                ArrayAccessor accessor = new ArrayAccessor();
                accessor.setIndex(Integer.parseInt(item));
                this.addAccessorNode(accessor);
            }
            return ((Object[])ctx)[(Integer)idx];
        }
        if (ctx instanceof CharSequence) {
            if (itemSubExpr) {
                IndexedCharSeqAccessorNest accessor = new IndexedCharSeqAccessorNest();
                accessor.setIndex(itemStmt);
                this.addAccessorNode(accessor);
            } else {
                IndexedCharSeqAccessor accessor = new IndexedCharSeqAccessor();
                accessor.setIndex(Integer.parseInt(item));
                this.addAccessorNode(accessor);
            }
            return Character.valueOf(((CharSequence)ctx).charAt((Integer)idx));
        }
        throw new PropertyAccessException("illegal use of []: unknown type: " + (ctx == null ? null : ctx.getClass().getName()));
    }

    private Object getMethod(Object ctx, String name) throws Exception {
        ExecutableStatement[] es;
        Object[] args;
        if (this.first && this.variableFactory.isResolveable(name)) {
            Method m = (Method)this.variableFactory.getVariableResolver(name).getValue();
            ctx = m.getDeclaringClass();
            name = m.getName();
            this.first = false;
        }
        int st = this.cursor;
        int depth = 1;
        while (this.cursor++ < this.length - 1 && depth != 0) {
            switch (this.expr[this.cursor]) {
                case '(': {
                    ++depth;
                    break;
                }
                case ')': {
                    --depth;
                }
            }
        }
        --this.cursor;
        String tk = this.cursor - st > 1 ? new String(this.expr, st + 1, this.cursor - st - 1) : "";
        ++this.cursor;
        if (tk.length() == 0) {
            args = ParseTools.EMPTY_OBJ_ARR;
            es = null;
        } else {
            String[] subtokens = ParseTools.parseParameterList(tk.toCharArray(), 0, -1);
            es = new ExecutableStatement[subtokens.length];
            args = new Object[subtokens.length];
            for (int i = 0; i < subtokens.length; ++i) {
                es[i] = (ExecutableStatement)ParseTools.subCompileExpression(subtokens[i]);
                args[i] = es[i].getValue(this.ctx, this.variableFactory);
            }
        }
        Class<?> cls = ctx instanceof Class ? ctx : ctx.getClass();
        Class<?>[] parameterTypes = null;
        Method m = ParseTools.getBestCandidate(args, name, cls.getMethods());
        if (m != null) {
            parameterTypes = m.getParameterTypes();
        }
        if (m == null && (m = ParseTools.getBestCandidate(args, name, cls.getClass().getDeclaredMethods())) != null) {
            parameterTypes = m.getParameterTypes();
        }
        if (m == null) {
            StringAppender errorBuild = new StringAppender();
            for (int i = 0; i < args.length; ++i) {
                errorBuild.append(args[i] != null ? args[i].getClass().getName() : null);
                if (i >= args.length - 1) continue;
                errorBuild.append(", ");
            }
            if ("size".equals(name) && args.length == 0 && cls.isArray()) {
                this.addAccessorNode(new ArrayLength());
                return Array.getLength(ctx);
            }
            throw new PropertyAccessException("unable to resolve method: " + cls.getName() + "." + name + "(" + errorBuild.toString() + ") [arglength=" + args.length + "]");
        }
        if (es != null) {
            for (int i = 0; i < es.length; ++i) {
                ExecutableStatement cExpr = es[i];
                if (cExpr.getKnownIngressType() == null) {
                    cExpr.setKnownIngressType(parameterTypes[i]);
                    cExpr.computeTypeConversionRule();
                }
                if (cExpr.isConvertableIngressEgress()) continue;
                args[i] = DataConversion.convert(args[i], parameterTypes[i]);
            }
        } else {
            for (int i = 0; i < args.length; ++i) {
                args[i] = DataConversion.convert(args[i], parameterTypes[i]);
            }
        }
        MethodAccessor access = new MethodAccessor();
        access.setMethod(ParseTools.getWidenedTarget(m));
        access.setParms(es);
        this.addAccessorNode(access);
        return m.invoke(ctx, args);
    }

    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory) throws Exception {
        return this.rootNode.getValue(ctx, elCtx, variableFactory);
    }

    public static void main(String[] args) {
        new ReflectiveAccessorOptimizer().optimizeCollection("[test, foo, bar, {1,2,3}]".toCharArray(), null, null, null);
    }

    private Accessor _getAccessor(Object o) {
        if (o instanceof List) {
            Accessor[] a = new Accessor[((List)o).size()];
            int i = 0;
            for (Object item : (List)o) {
                a[i++] = this._getAccessor(item);
            }
            return new ListCreator(a);
        }
        if (o instanceof Map) {
            Accessor[] k = new Accessor[((Map)o).size()];
            Accessor[] v = new Accessor[k.length];
            int i = 0;
            for (Object item : ((Map)o).keySet()) {
                k[i] = this._getAccessor(item);
                v[i++] = this._getAccessor(((Map)o).get(item));
            }
            return new MapCreator(k, v);
        }
        if (o instanceof Object[]) {
            Accessor[] a = new Accessor[((Object[])o).length];
            int i = 0;
            for (Object item : (Object[])o) {
                a[i++] = this._getAccessor(item);
            }
            return new ArrayCreator(a);
        }
        return new ExprValueAccessor((String)o);
    }

    @Override
    public Accessor optimizeCollection(char[] property, Object ctx, Object thisRef, VariableResolverFactory factory) {
        this.ctx = ctx;
        this.thisRef = thisRef;
        this.variableFactory = factory;
        CollectionParser parser = new CollectionParser();
        Object o = ((List)parser.parseCollection(property)).get(0);
        Accessor root = this._getAccessor(o);
        int end = parser.getEnd() + 2;
        if (end < property.length) {
            return new Union(root, ParseTools.subset(property, end));
        }
        return root;
    }

    @Override
    public Accessor optimizeObjectCreation(char[] property, Object ctx, Object thisRef, VariableResolverFactory factory) {
        this.expr = property;
        this.length = property.length;
        this.cursor = 0;
        try {
            AccessorNode contructor = ReflectiveAccessorOptimizer.compileConstructor(property, ctx, factory);
            this.val = contructor.getValue(property, thisRef, factory);
            return contructor;
        }
        catch (Exception e) {
            throw new CompileException("could not create constructor", e);
        }
    }

    @Override
    public Accessor optimizeFold(char[] property, Object ctx, Object thisRef, VariableResolverFactory factory) {
        this.expr = property;
        this.length = property.length;
        this.cursor = 0;
        this.greedy = false;
        if (this.expr[this.cursor] == '(') {
            this.balancedCapture('(');
            this.length = this.cursor;
            this.cursor = 1;
        }
        ASTNode var = this.nextToken();
        if (!this.nextToken().isOperator(34)) {
            throw new CompileException("expected fold operator");
        }
        this.greedy = true;
        Fold fold = new Fold(var.getNameAsArray(), new ExprValueAccessor(this.nextToken().getName()));
        if (this.length < property.length - 1) {
            this.cursor += 2;
            Union union = new Union(fold, ParseTools.subset(property, this.cursor));
            this.val = union.getValue(ctx, thisRef, factory);
            return union;
        }
        this.val = fold.getValue(ctx, thisRef, factory);
        return fold;
    }

    private void setRootNode(AccessorNode rootNode) {
        this.rootNode = this.currNode = rootNode;
    }

    private AccessorNode getRootNode() {
        return this.rootNode;
    }

    @Override
    public Object getResultOptPass() {
        return this.val;
    }

    public static AccessorNode compileConstructor(char[] expression, Object ctx, VariableResolverFactory vars) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException {
        String[] cnsRes = ParseTools.captureContructorAndResidual(expression);
        String[] constructorParms = ParseTools.parseMethodOrConstructor(cnsRes[0].toCharArray());
        if (constructorParms != null) {
            String s = new String(ParseTools.subset(expression, 0, ArrayTools.findFirst('(', expression)));
            Class cls = ParseTools.findClass(vars, s);
            ExecutableStatement[] cStmts = new ExecutableStatement[constructorParms.length];
            for (int i = 0; i < constructorParms.length; ++i) {
                cStmts[i] = (ExecutableStatement)ParseTools.subCompileExpression(constructorParms[i]);
            }
            Object[] parms = new Object[constructorParms.length];
            for (int i = 0; i < constructorParms.length; ++i) {
                parms[i] = cStmts[i].getValue(ctx, vars);
            }
            Constructor cns = ParseTools.getBestConstructorCanadidate(parms, cls);
            if (cns == null) {
                throw new CompileException("unable to find constructor for: " + cls.getName());
            }
            for (int i = 0; i < parms.length; ++i) {
                parms[i] = DataConversion.convert(parms[i], cns.getParameterTypes()[i]);
            }
            AccessorNode ca = new ConstructorAccessor(cns, cStmts);
            if (cnsRes.length > 1) {
                ReflectiveAccessorOptimizer compiledOptimizer = new ReflectiveAccessorOptimizer(cnsRes[1].toCharArray(), cns.newInstance(parms), ctx, vars);
                compiledOptimizer.setRootNode(ca);
                compiledOptimizer.compileGetChain();
                ca = compiledOptimizer.getRootNode();
            }
            return ca;
        }
        Constructor<?> cns = Class.forName(new String(expression)).getConstructor(EMPTYCLS);
        AccessorNode ca = new ConstructorAccessor(cns, null);
        if (cnsRes.length > 1) {
            ReflectiveAccessorOptimizer compiledOptimizer = new ReflectiveAccessorOptimizer(cnsRes[1].toCharArray(), cns.newInstance(null), ctx, vars);
            compiledOptimizer.setRootNode(ca);
            compiledOptimizer.compileGetChain();
            ca = compiledOptimizer.getRootNode();
        }
        return ca;
    }

    @Override
    public Accessor optimizeReturn(char[] property, Object ctx, Object thisRef, VariableResolverFactory factory) {
        ExecutableStatement stmt = (ExecutableStatement)ParseTools.subCompileExpression(property);
        Return ret = new Return(stmt);
        this.val = stmt.getValue(ctx, thisRef, factory);
        return ret;
    }

    @Override
    public Class getEgressType() {
        return this.returnType;
    }
}

