/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.ast;

import org.mvel.ASTNode;
import org.mvel.CompileException;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.util.ParseTools;

public class ImportNode
extends ASTNode {
    private Class importClass;

    public ImportNode(char[] expr, int fields) {
        super(expr, fields);
        try {
            this.importClass = Class.forName(new String(expr));
        }
        catch (ClassNotFoundException e) {
            throw new CompileException("class not found: " + new String(expr));
        }
    }

    @Override
    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        ParseTools.findClassImportResolverFactory(factory).addClass(this.importClass);
        return this.importClass;
    }

    @Override
    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return this.getReducedValueAccelerated(ctx, thisValue, factory);
    }

    public Class getImportClass() {
        return this.importClass;
    }
}

