/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.ast;

import org.mvel.ASTNode;
import org.mvel.CompileException;
import org.mvel.ExecutableStatement;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.util.ParseTools;

public class AssertNode
extends ASTNode {
    public ExecutableStatement assertion;

    public AssertNode(char[] expr, int fields) {
        super(expr, fields);
        this.assertion = (ExecutableStatement)ParseTools.subCompileExpression(expr);
    }

    @Override
    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        try {
            Boolean bool = (Boolean)this.assertion.getValue(ctx, thisValue, factory);
            if (!bool.booleanValue()) {
                throw new AssertionError((Object)("assertion failed in expression: " + new String(this.name)));
            }
            return bool;
        }
        catch (ClassCastException e) {
            throw new CompileException("assertion does not contain a boolean statement");
        }
    }

    @Override
    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return this.getReducedValueAccelerated(ctx, thisValue, factory);
    }
}

