// Code generated by protoc-gen-go4grpc; DO NOT EDIT
// source: maintner.proto

/*
Package maintpb is a generated protocol buffer package.

It is generated from these files:

	maintner.proto

It has these top-level messages:

	Mutation
	GithubMutation
	GithubIssueMutation
	BoolChange
	StringChange
	GithubLabel
	GithubMilestone
	GithubIssueEvent
	GithubDismissedReviewEvent
	GithubCommit
	GithubReview
	GithubIssueSyncStatus
	GithubIssueCommentMutation
	GithubUser
	GithubTeam
	GitMutation
	GitRepo
	GitCommit
	GitDiffTree
	GitDiffTreeFile
	GerritMutation
	GitRef
*/
package maintpb

import (
	fmt "fmt"

	proto "github.com/golang/protobuf/proto"

	math "math"

	google_protobuf "github.com/golang/protobuf/ptypes/timestamp"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type Mutation struct {
	GithubIssue *GithubIssueMutation `protobuf:"bytes,1,opt,name=github_issue,json=githubIssue" json:"github_issue,omitempty"`
	Github      *GithubMutation      `protobuf:"bytes,3,opt,name=github" json:"github,omitempty"`
	Git         *GitMutation         `protobuf:"bytes,2,opt,name=git" json:"git,omitempty"`
	Gerrit      *GerritMutation      `protobuf:"bytes,4,opt,name=gerrit" json:"gerrit,omitempty"`
}

func (m *Mutation) Reset()                    { *m = Mutation{} }
func (m *Mutation) String() string            { return proto.CompactTextString(m) }
func (*Mutation) ProtoMessage()               {}
func (*Mutation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *Mutation) GetGithubIssue() *GithubIssueMutation {
	if m != nil {
		return m.GithubIssue
	}
	return nil
}

func (m *Mutation) GetGithub() *GithubMutation {
	if m != nil {
		return m.Github
	}
	return nil
}

func (m *Mutation) GetGit() *GitMutation {
	if m != nil {
		return m.Git
	}
	return nil
}

func (m *Mutation) GetGerrit() *GerritMutation {
	if m != nil {
		return m.Gerrit
	}
	return nil
}

type GithubMutation struct {
	Owner string `protobuf:"bytes,1,opt,name=owner" json:"owner,omitempty"`
	Repo  string `protobuf:"bytes,2,opt,name=repo" json:"repo,omitempty"`
	// Updated labels. (All must have id set at least)
	Labels []*GithubLabel `protobuf:"bytes,3,rep,name=labels" json:"labels,omitempty"`
	// Updated milestones. (All must have id set at least)
	Milestones []*GithubMilestone `protobuf:"bytes,4,rep,name=milestones" json:"milestones,omitempty"`
}

func (m *GithubMutation) Reset()                    { *m = GithubMutation{} }
func (m *GithubMutation) String() string            { return proto.CompactTextString(m) }
func (*GithubMutation) ProtoMessage()               {}
func (*GithubMutation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *GithubMutation) GetOwner() string {
	if m != nil {
		return m.Owner
	}
	return ""
}

func (m *GithubMutation) GetRepo() string {
	if m != nil {
		return m.Repo
	}
	return ""
}

func (m *GithubMutation) GetLabels() []*GithubLabel {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *GithubMutation) GetMilestones() []*GithubMilestone {
	if m != nil {
		return m.Milestones
	}
	return nil
}

type GithubIssueMutation struct {
	Owner  string `protobuf:"bytes,1,opt,name=owner" json:"owner,omitempty"`
	Repo   string `protobuf:"bytes,2,opt,name=repo" json:"repo,omitempty"`
	Number int32  `protobuf:"varint,3,opt,name=number" json:"number,omitempty"`
	// not_exist is set true if the issue has been found to not exist.
	// If true, the owner/repo/number fields above must still be set.
	// If a future issue mutation for the same number arrives without
	// not_exist set, then the issue comes back to life.
	NotExist         bool                       `protobuf:"varint,13,opt,name=not_exist,json=notExist" json:"not_exist,omitempty"`
	Id               int64                      `protobuf:"varint,12,opt,name=id" json:"id,omitempty"`
	User             *GithubUser                `protobuf:"bytes,4,opt,name=user" json:"user,omitempty"`
	Assignees        []*GithubUser              `protobuf:"bytes,10,rep,name=assignees" json:"assignees,omitempty"`
	DeletedAssignees []int64                    `protobuf:"varint,11,rep,packed,name=deleted_assignees,json=deletedAssignees" json:"deleted_assignees,omitempty"`
	Created          *google_protobuf.Timestamp `protobuf:"bytes,5,opt,name=created" json:"created,omitempty"`
	Updated          *google_protobuf.Timestamp `protobuf:"bytes,6,opt,name=updated" json:"updated,omitempty"`
	Title            string                     `protobuf:"bytes,9,opt,name=title" json:"title,omitempty"`
	// body_change changes the body field (the top post, which isn't a comment).
	// It is now used in preference to the old body field.
	BodyChange *StringChange `protobuf:"bytes,31,opt,name=body_change,json=bodyChange" json:"body_change,omitempty"`
	// body was the old way to change the body, but it doesn't support removing the
	// body text, which is common on PRs. New mutations use body_change instead.
	Body        string `protobuf:"bytes,7,opt,name=body" json:"body,omitempty"`
	NoMilestone bool   `protobuf:"varint,15,opt,name=no_milestone,json=noMilestone" json:"no_milestone,omitempty"`
	// When setting a milestone, only the milestone_id must be set.
	// TODO: allow num or title to be used if Github only returns those? So far unneeded.
	// The num and title, if non-zero, are treated as if they were a GithubMutation.Milestone update.
	MilestoneId    int64                         `protobuf:"varint,16,opt,name=milestone_id,json=milestoneId" json:"milestone_id,omitempty"`
	MilestoneNum   int64                         `protobuf:"varint,17,opt,name=milestone_num,json=milestoneNum" json:"milestone_num,omitempty"`
	MilestoneTitle string                        `protobuf:"bytes,18,opt,name=milestone_title,json=milestoneTitle" json:"milestone_title,omitempty"`
	Closed         *BoolChange                   `protobuf:"bytes,19,opt,name=closed" json:"closed,omitempty"`
	Locked         *BoolChange                   `protobuf:"bytes,25,opt,name=locked" json:"locked,omitempty"`
	PullRequest    bool                          `protobuf:"varint,28,opt,name=pull_request,json=pullRequest" json:"pull_request,omitempty"`
	ClosedAt       *google_protobuf.Timestamp    `protobuf:"bytes,21,opt,name=closed_at,json=closedAt" json:"closed_at,omitempty"`
	ClosedBy       *GithubUser                   `protobuf:"bytes,22,opt,name=closed_by,json=closedBy" json:"closed_by,omitempty"`
	RemoveLabel    []int64                       `protobuf:"varint,23,rep,packed,name=remove_label,json=removeLabel" json:"remove_label,omitempty"`
	AddLabel       []*GithubLabel                `protobuf:"bytes,24,rep,name=add_label,json=addLabel" json:"add_label,omitempty"`
	Comment        []*GithubIssueCommentMutation `protobuf:"bytes,8,rep,name=comment" json:"comment,omitempty"`
	CommentStatus  *GithubIssueSyncStatus        `protobuf:"bytes,14,opt,name=comment_status,json=commentStatus" json:"comment_status,omitempty"`
	Event          []*GithubIssueEvent           `protobuf:"bytes,26,rep,name=event" json:"event,omitempty"`
	EventStatus    *GithubIssueSyncStatus        `protobuf:"bytes,27,opt,name=event_status,json=eventStatus" json:"event_status,omitempty"`
	Review         []*GithubReview               `protobuf:"bytes,29,rep,name=review" json:"review,omitempty"`
	ReviewStatus   *GithubIssueSyncStatus        `protobuf:"bytes,30,opt,name=review_status,json=reviewStatus" json:"review_status,omitempty"`
}

func (m *GithubIssueMutation) Reset()                    { *m = GithubIssueMutation{} }
func (m *GithubIssueMutation) String() string            { return proto.CompactTextString(m) }
func (*GithubIssueMutation) ProtoMessage()               {}
func (*GithubIssueMutation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *GithubIssueMutation) GetOwner() string {
	if m != nil {
		return m.Owner
	}
	return ""
}

func (m *GithubIssueMutation) GetRepo() string {
	if m != nil {
		return m.Repo
	}
	return ""
}

func (m *GithubIssueMutation) GetNumber() int32 {
	if m != nil {
		return m.Number
	}
	return 0
}

func (m *GithubIssueMutation) GetNotExist() bool {
	if m != nil {
		return m.NotExist
	}
	return false
}

func (m *GithubIssueMutation) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *GithubIssueMutation) GetUser() *GithubUser {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *GithubIssueMutation) GetAssignees() []*GithubUser {
	if m != nil {
		return m.Assignees
	}
	return nil
}

func (m *GithubIssueMutation) GetDeletedAssignees() []int64 {
	if m != nil {
		return m.DeletedAssignees
	}
	return nil
}

func (m *GithubIssueMutation) GetCreated() *google_protobuf.Timestamp {
	if m != nil {
		return m.Created
	}
	return nil
}

func (m *GithubIssueMutation) GetUpdated() *google_protobuf.Timestamp {
	if m != nil {
		return m.Updated
	}
	return nil
}

func (m *GithubIssueMutation) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *GithubIssueMutation) GetBodyChange() *StringChange {
	if m != nil {
		return m.BodyChange
	}
	return nil
}

func (m *GithubIssueMutation) GetBody() string {
	if m != nil {
		return m.Body
	}
	return ""
}

func (m *GithubIssueMutation) GetNoMilestone() bool {
	if m != nil {
		return m.NoMilestone
	}
	return false
}

func (m *GithubIssueMutation) GetMilestoneId() int64 {
	if m != nil {
		return m.MilestoneId
	}
	return 0
}

func (m *GithubIssueMutation) GetMilestoneNum() int64 {
	if m != nil {
		return m.MilestoneNum
	}
	return 0
}

func (m *GithubIssueMutation) GetMilestoneTitle() string {
	if m != nil {
		return m.MilestoneTitle
	}
	return ""
}

func (m *GithubIssueMutation) GetClosed() *BoolChange {
	if m != nil {
		return m.Closed
	}
	return nil
}

func (m *GithubIssueMutation) GetLocked() *BoolChange {
	if m != nil {
		return m.Locked
	}
	return nil
}

func (m *GithubIssueMutation) GetPullRequest() bool {
	if m != nil {
		return m.PullRequest
	}
	return false
}

func (m *GithubIssueMutation) GetClosedAt() *google_protobuf.Timestamp {
	if m != nil {
		return m.ClosedAt
	}
	return nil
}

func (m *GithubIssueMutation) GetClosedBy() *GithubUser {
	if m != nil {
		return m.ClosedBy
	}
	return nil
}

func (m *GithubIssueMutation) GetRemoveLabel() []int64 {
	if m != nil {
		return m.RemoveLabel
	}
	return nil
}

func (m *GithubIssueMutation) GetAddLabel() []*GithubLabel {
	if m != nil {
		return m.AddLabel
	}
	return nil
}

func (m *GithubIssueMutation) GetComment() []*GithubIssueCommentMutation {
	if m != nil {
		return m.Comment
	}
	return nil
}

func (m *GithubIssueMutation) GetCommentStatus() *GithubIssueSyncStatus {
	if m != nil {
		return m.CommentStatus
	}
	return nil
}

func (m *GithubIssueMutation) GetEvent() []*GithubIssueEvent {
	if m != nil {
		return m.Event
	}
	return nil
}

func (m *GithubIssueMutation) GetEventStatus() *GithubIssueSyncStatus {
	if m != nil {
		return m.EventStatus
	}
	return nil
}

func (m *GithubIssueMutation) GetReview() []*GithubReview {
	if m != nil {
		return m.Review
	}
	return nil
}

func (m *GithubIssueMutation) GetReviewStatus() *GithubIssueSyncStatus {
	if m != nil {
		return m.ReviewStatus
	}
	return nil
}

// BoolChange represents a change to a boolean value.
// (Notably, the wrapper type permits representing a change to false.)
type BoolChange struct {
	Val bool `protobuf:"varint,1,opt,name=val" json:"val,omitempty"`
}

func (m *BoolChange) Reset()                    { *m = BoolChange{} }
func (m *BoolChange) String() string            { return proto.CompactTextString(m) }
func (*BoolChange) ProtoMessage()               {}
func (*BoolChange) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *BoolChange) GetVal() bool {
	if m != nil {
		return m.Val
	}
	return false
}

// StringChange represents a change to a boolean value.
// (Notably, the wrapper type permits representing a change to the empty string.)
type StringChange struct {
	Val string `protobuf:"bytes,1,opt,name=val" json:"val,omitempty"`
}

func (m *StringChange) Reset()                    { *m = StringChange{} }
func (m *StringChange) String() string            { return proto.CompactTextString(m) }
func (*StringChange) ProtoMessage()               {}
func (*StringChange) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *StringChange) GetVal() string {
	if m != nil {
		return m.Val
	}
	return ""
}

type GithubLabel struct {
	Id   int64  `protobuf:"varint,1,opt,name=id" json:"id,omitempty"`
	Name string `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
}

func (m *GithubLabel) Reset()                    { *m = GithubLabel{} }
func (m *GithubLabel) String() string            { return proto.CompactTextString(m) }
func (*GithubLabel) ProtoMessage()               {}
func (*GithubLabel) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *GithubLabel) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *GithubLabel) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type GithubMilestone struct {
	Id int64 `protobuf:"varint,1,opt,name=id" json:"id,omitempty"`
	// Following only need to be non-zero on changes:
	Title  string      `protobuf:"bytes,2,opt,name=title" json:"title,omitempty"`
	Closed *BoolChange `protobuf:"bytes,3,opt,name=closed" json:"closed,omitempty"`
	Number int64       `protobuf:"varint,4,opt,name=number" json:"number,omitempty"`
}

func (m *GithubMilestone) Reset()                    { *m = GithubMilestone{} }
func (m *GithubMilestone) String() string            { return proto.CompactTextString(m) }
func (*GithubMilestone) ProtoMessage()               {}
func (*GithubMilestone) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *GithubMilestone) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *GithubMilestone) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *GithubMilestone) GetClosed() *BoolChange {
	if m != nil {
		return m.Closed
	}
	return nil
}

func (m *GithubMilestone) GetNumber() int64 {
	if m != nil {
		return m.Number
	}
	return 0
}

// See https://developer.github.com/v3/activity/events/types/#issuesevent
// for some info.
type GithubIssueEvent struct {
	// Required:
	Id int64 `protobuf:"varint,1,opt,name=id" json:"id,omitempty"`
	// event_type can be one of "assigned", "unassigned", "labeled",
	// "unlabeled", "opened", "edited", "milestoned", "demilestoned",
	// "closed", "reopened", "referenced", "renamed" or anything else
	// that Github adds in the future.
	EventType string                     `protobuf:"bytes,2,opt,name=event_type,json=eventType" json:"event_type,omitempty"`
	ActorId   int64                      `protobuf:"varint,3,opt,name=actor_id,json=actorId" json:"actor_id,omitempty"`
	Created   *google_protobuf.Timestamp `protobuf:"bytes,4,opt,name=created" json:"created,omitempty"`
	// label is populated for "labeled" and "unlabeled" events.
	// The label will usually not have an ID, due to Github's API
	// not returning one.
	Label *GithubLabel `protobuf:"bytes,5,opt,name=label" json:"label,omitempty"`
	// milestone is populated for "milestoned" and "demilestoned" events.
	// The label will usually not have an ID, due to Github's API
	// not returning one.
	Milestone *GithubMilestone `protobuf:"bytes,6,opt,name=milestone" json:"milestone,omitempty"`
	// For "assigned", "unassigned":
	AssigneeId int64 `protobuf:"varint,7,opt,name=assignee_id,json=assigneeId" json:"assignee_id,omitempty"`
	AssignerId int64 `protobuf:"varint,8,opt,name=assigner_id,json=assignerId" json:"assigner_id,omitempty"`
	// For "referenced", "closed":
	Commit *GithubCommit `protobuf:"bytes,9,opt,name=commit" json:"commit,omitempty"`
	// For "renamed" events:
	RenameFrom        string      `protobuf:"bytes,11,opt,name=rename_from,json=renameFrom" json:"rename_from,omitempty"`
	RenameTo          string      `protobuf:"bytes,12,opt,name=rename_to,json=renameTo" json:"rename_to,omitempty"`
	ReviewerId        int64       `protobuf:"varint,13,opt,name=reviewer_id,json=reviewerId" json:"reviewer_id,omitempty"`
	ReviewRequesterId int64       `protobuf:"varint,14,opt,name=review_requester_id,json=reviewRequesterId" json:"review_requester_id,omitempty"`
	TeamReviewer      *GithubTeam `protobuf:"bytes,16,opt,name=team_reviewer,json=teamReviewer" json:"team_reviewer,omitempty"`
	// Contents of a dismissed review event, see dismissed_review in
	// https://developer.github.com/v3/issues/events/ for more info
	DismissedReview *GithubDismissedReviewEvent `protobuf:"bytes,15,opt,name=dismissed_review,json=dismissedReview" json:"dismissed_review,omitempty"`
	// other_json is usually empty. If Github adds event types or fields
	// in the future, this captures those added fields. If non-empty it
	// will be a JSON object with the fields that weren't understood.
	OtherJson []byte `protobuf:"bytes,10,opt,name=other_json,json=otherJson,proto3" json:"other_json,omitempty"`
}

func (m *GithubIssueEvent) Reset()                    { *m = GithubIssueEvent{} }
func (m *GithubIssueEvent) String() string            { return proto.CompactTextString(m) }
func (*GithubIssueEvent) ProtoMessage()               {}
func (*GithubIssueEvent) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *GithubIssueEvent) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *GithubIssueEvent) GetEventType() string {
	if m != nil {
		return m.EventType
	}
	return ""
}

func (m *GithubIssueEvent) GetActorId() int64 {
	if m != nil {
		return m.ActorId
	}
	return 0
}

func (m *GithubIssueEvent) GetCreated() *google_protobuf.Timestamp {
	if m != nil {
		return m.Created
	}
	return nil
}

func (m *GithubIssueEvent) GetLabel() *GithubLabel {
	if m != nil {
		return m.Label
	}
	return nil
}

func (m *GithubIssueEvent) GetMilestone() *GithubMilestone {
	if m != nil {
		return m.Milestone
	}
	return nil
}

func (m *GithubIssueEvent) GetAssigneeId() int64 {
	if m != nil {
		return m.AssigneeId
	}
	return 0
}

func (m *GithubIssueEvent) GetAssignerId() int64 {
	if m != nil {
		return m.AssignerId
	}
	return 0
}

func (m *GithubIssueEvent) GetCommit() *GithubCommit {
	if m != nil {
		return m.Commit
	}
	return nil
}

func (m *GithubIssueEvent) GetRenameFrom() string {
	if m != nil {
		return m.RenameFrom
	}
	return ""
}

func (m *GithubIssueEvent) GetRenameTo() string {
	if m != nil {
		return m.RenameTo
	}
	return ""
}

func (m *GithubIssueEvent) GetReviewerId() int64 {
	if m != nil {
		return m.ReviewerId
	}
	return 0
}

func (m *GithubIssueEvent) GetReviewRequesterId() int64 {
	if m != nil {
		return m.ReviewRequesterId
	}
	return 0
}

func (m *GithubIssueEvent) GetTeamReviewer() *GithubTeam {
	if m != nil {
		return m.TeamReviewer
	}
	return nil
}

func (m *GithubIssueEvent) GetDismissedReview() *GithubDismissedReviewEvent {
	if m != nil {
		return m.DismissedReview
	}
	return nil
}

func (m *GithubIssueEvent) GetOtherJson() []byte {
	if m != nil {
		return m.OtherJson
	}
	return nil
}

// Contents of a dismissed review event - when someone leaves a
// review requesting changes and someone else dismisses it. See
// https://developer.github.com/v3/issues/events for more information.
type GithubDismissedReviewEvent struct {
	ReviewId         int64  `protobuf:"varint,1,opt,name=review_id,json=reviewId" json:"review_id,omitempty"`
	DismissalMessage string `protobuf:"bytes,3,opt,name=dismissal_message,json=dismissalMessage" json:"dismissal_message,omitempty"`
	State            string `protobuf:"bytes,4,opt,name=state" json:"state,omitempty"`
}

func (m *GithubDismissedReviewEvent) Reset()                    { *m = GithubDismissedReviewEvent{} }
func (m *GithubDismissedReviewEvent) String() string            { return proto.CompactTextString(m) }
func (*GithubDismissedReviewEvent) ProtoMessage()               {}
func (*GithubDismissedReviewEvent) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *GithubDismissedReviewEvent) GetReviewId() int64 {
	if m != nil {
		return m.ReviewId
	}
	return 0
}

func (m *GithubDismissedReviewEvent) GetDismissalMessage() string {
	if m != nil {
		return m.DismissalMessage
	}
	return ""
}

func (m *GithubDismissedReviewEvent) GetState() string {
	if m != nil {
		return m.State
	}
	return ""
}

type GithubCommit struct {
	Owner    string `protobuf:"bytes,1,opt,name=owner" json:"owner,omitempty"`
	Repo     string `protobuf:"bytes,2,opt,name=repo" json:"repo,omitempty"`
	CommitId string `protobuf:"bytes,3,opt,name=commit_id,json=commitId" json:"commit_id,omitempty"`
}

func (m *GithubCommit) Reset()                    { *m = GithubCommit{} }
func (m *GithubCommit) String() string            { return proto.CompactTextString(m) }
func (*GithubCommit) ProtoMessage()               {}
func (*GithubCommit) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *GithubCommit) GetOwner() string {
	if m != nil {
		return m.Owner
	}
	return ""
}

func (m *GithubCommit) GetRepo() string {
	if m != nil {
		return m.Repo
	}
	return ""
}

func (m *GithubCommit) GetCommitId() string {
	if m != nil {
		return m.CommitId
	}
	return ""
}

// Contents of a pull request review - when someone
// comments, requests changes, or approves changes
// on a pull request. See
// https://developer.github.com/v3/pulls/reviews/ for more information.
type GithubReview struct {
	// Required:
	Id               int64                      `protobuf:"varint,1,opt,name=id" json:"id,omitempty"`
	ActorId          int64                      `protobuf:"varint,2,opt,name=actor_id,json=actorId" json:"actor_id,omitempty"`
	Created          *google_protobuf.Timestamp `protobuf:"bytes,3,opt,name=created" json:"created,omitempty"`
	Body             string                     `protobuf:"bytes,4,opt,name=body" json:"body,omitempty"`
	State            string                     `protobuf:"bytes,5,opt,name=state" json:"state,omitempty"`
	CommitId         string                     `protobuf:"bytes,6,opt,name=commit_id,json=commitId" json:"commit_id,omitempty"`
	ActorAssociation string                     `protobuf:"bytes,7,opt,name=actor_association,json=actorAssociation" json:"actor_association,omitempty"`
	// other_json is usually empty.
	OtherJson []byte `protobuf:"bytes,8,opt,name=other_json,json=otherJson,proto3" json:"other_json,omitempty"`
}

func (m *GithubReview) Reset()                    { *m = GithubReview{} }
func (m *GithubReview) String() string            { return proto.CompactTextString(m) }
func (*GithubReview) ProtoMessage()               {}
func (*GithubReview) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *GithubReview) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *GithubReview) GetActorId() int64 {
	if m != nil {
		return m.ActorId
	}
	return 0
}

func (m *GithubReview) GetCreated() *google_protobuf.Timestamp {
	if m != nil {
		return m.Created
	}
	return nil
}

func (m *GithubReview) GetBody() string {
	if m != nil {
		return m.Body
	}
	return ""
}

func (m *GithubReview) GetState() string {
	if m != nil {
		return m.State
	}
	return ""
}

func (m *GithubReview) GetCommitId() string {
	if m != nil {
		return m.CommitId
	}
	return ""
}

func (m *GithubReview) GetActorAssociation() string {
	if m != nil {
		return m.ActorAssociation
	}
	return ""
}

func (m *GithubReview) GetOtherJson() []byte {
	if m != nil {
		return m.OtherJson
	}
	return nil
}

// GithubIssueSyncStatus notes where syncing is at for comments
// on an issue,
// This mutation type is only made at/after the same top-level mutation
// which created the corresponding comments.
type GithubIssueSyncStatus struct {
	// server_date is the "Date" response header from Github for the
	// final HTTP response.
	ServerDate *google_protobuf.Timestamp `protobuf:"bytes,1,opt,name=server_date,json=serverDate" json:"server_date,omitempty"`
}

func (m *GithubIssueSyncStatus) Reset()                    { *m = GithubIssueSyncStatus{} }
func (m *GithubIssueSyncStatus) String() string            { return proto.CompactTextString(m) }
func (*GithubIssueSyncStatus) ProtoMessage()               {}
func (*GithubIssueSyncStatus) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *GithubIssueSyncStatus) GetServerDate() *google_protobuf.Timestamp {
	if m != nil {
		return m.ServerDate
	}
	return nil
}

type GithubIssueCommentMutation struct {
	Id      int64                      `protobuf:"varint,1,opt,name=id" json:"id,omitempty"`
	User    *GithubUser                `protobuf:"bytes,2,opt,name=user" json:"user,omitempty"`
	Body    string                     `protobuf:"bytes,3,opt,name=body" json:"body,omitempty"`
	Created *google_protobuf.Timestamp `protobuf:"bytes,4,opt,name=created" json:"created,omitempty"`
	Updated *google_protobuf.Timestamp `protobuf:"bytes,5,opt,name=updated" json:"updated,omitempty"`
}

func (m *GithubIssueCommentMutation) Reset()                    { *m = GithubIssueCommentMutation{} }
func (m *GithubIssueCommentMutation) String() string            { return proto.CompactTextString(m) }
func (*GithubIssueCommentMutation) ProtoMessage()               {}
func (*GithubIssueCommentMutation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *GithubIssueCommentMutation) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *GithubIssueCommentMutation) GetUser() *GithubUser {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *GithubIssueCommentMutation) GetBody() string {
	if m != nil {
		return m.Body
	}
	return ""
}

func (m *GithubIssueCommentMutation) GetCreated() *google_protobuf.Timestamp {
	if m != nil {
		return m.Created
	}
	return nil
}

func (m *GithubIssueCommentMutation) GetUpdated() *google_protobuf.Timestamp {
	if m != nil {
		return m.Updated
	}
	return nil
}

type GithubUser struct {
	Id    int64  `protobuf:"varint,1,opt,name=id" json:"id,omitempty"`
	Login string `protobuf:"bytes,2,opt,name=login" json:"login,omitempty"`
}

func (m *GithubUser) Reset()                    { *m = GithubUser{} }
func (m *GithubUser) String() string            { return proto.CompactTextString(m) }
func (*GithubUser) ProtoMessage()               {}
func (*GithubUser) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *GithubUser) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *GithubUser) GetLogin() string {
	if m != nil {
		return m.Login
	}
	return ""
}

type GithubTeam struct {
	Id   int64  `protobuf:"varint,1,opt,name=id" json:"id,omitempty"`
	Slug string `protobuf:"bytes,2,opt,name=slug" json:"slug,omitempty"`
}

func (m *GithubTeam) Reset()                    { *m = GithubTeam{} }
func (m *GithubTeam) String() string            { return proto.CompactTextString(m) }
func (*GithubTeam) ProtoMessage()               {}
func (*GithubTeam) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *GithubTeam) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *GithubTeam) GetSlug() string {
	if m != nil {
		return m.Slug
	}
	return ""
}

type GitMutation struct {
	Repo *GitRepo `protobuf:"bytes,1,opt,name=repo" json:"repo,omitempty"`
	// commit adds a commit, or adds new information to a commit if fields
	// are added in the future.
	Commit *GitCommit `protobuf:"bytes,2,opt,name=commit" json:"commit,omitempty"`
}

func (m *GitMutation) Reset()                    { *m = GitMutation{} }
func (m *GitMutation) String() string            { return proto.CompactTextString(m) }
func (*GitMutation) ProtoMessage()               {}
func (*GitMutation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *GitMutation) GetRepo() *GitRepo {
	if m != nil {
		return m.Repo
	}
	return nil
}

func (m *GitMutation) GetCommit() *GitCommit {
	if m != nil {
		return m.Commit
	}
	return nil
}

// GitRepo identifies a git repo being mutated.
type GitRepo struct {
	// If go_repo is set, it identifies a go.googlesource.com/<go_repo> repo.
	GoRepo string `protobuf:"bytes,1,opt,name=go_repo,json=goRepo" json:"go_repo,omitempty"`
}

func (m *GitRepo) Reset()                    { *m = GitRepo{} }
func (m *GitRepo) String() string            { return proto.CompactTextString(m) }
func (*GitRepo) ProtoMessage()               {}
func (*GitRepo) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *GitRepo) GetGoRepo() string {
	if m != nil {
		return m.GoRepo
	}
	return ""
}

type GitCommit struct {
	Sha1 string `protobuf:"bytes,1,opt,name=sha1" json:"sha1,omitempty"`
	// raw is the "git cat-file commit $sha1" output.
	Raw      []byte       `protobuf:"bytes,2,opt,name=raw,proto3" json:"raw,omitempty"`
	DiffTree *GitDiffTree `protobuf:"bytes,3,opt,name=diff_tree,json=diffTree" json:"diff_tree,omitempty"`
}

func (m *GitCommit) Reset()                    { *m = GitCommit{} }
func (m *GitCommit) String() string            { return proto.CompactTextString(m) }
func (*GitCommit) ProtoMessage()               {}
func (*GitCommit) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *GitCommit) GetSha1() string {
	if m != nil {
		return m.Sha1
	}
	return ""
}

func (m *GitCommit) GetRaw() []byte {
	if m != nil {
		return m.Raw
	}
	return nil
}

func (m *GitCommit) GetDiffTree() *GitDiffTree {
	if m != nil {
		return m.DiffTree
	}
	return nil
}

// git diff-tree --numstat oldtree newtree
type GitDiffTree struct {
	File []*GitDiffTreeFile `protobuf:"bytes,1,rep,name=file" json:"file,omitempty"`
}

func (m *GitDiffTree) Reset()                    { *m = GitDiffTree{} }
func (m *GitDiffTree) String() string            { return proto.CompactTextString(m) }
func (*GitDiffTree) ProtoMessage()               {}
func (*GitDiffTree) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *GitDiffTree) GetFile() []*GitDiffTreeFile {
	if m != nil {
		return m.File
	}
	return nil
}

// GitDiffTreeFile represents one line of `git diff-tree --numstat` output.
type GitDiffTreeFile struct {
	File    string `protobuf:"bytes,1,opt,name=file" json:"file,omitempty"`
	Added   int64  `protobuf:"varint,2,opt,name=added" json:"added,omitempty"`
	Deleted int64  `protobuf:"varint,3,opt,name=deleted" json:"deleted,omitempty"`
	Binary  bool   `protobuf:"varint,4,opt,name=binary" json:"binary,omitempty"`
}

func (m *GitDiffTreeFile) Reset()                    { *m = GitDiffTreeFile{} }
func (m *GitDiffTreeFile) String() string            { return proto.CompactTextString(m) }
func (*GitDiffTreeFile) ProtoMessage()               {}
func (*GitDiffTreeFile) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *GitDiffTreeFile) GetFile() string {
	if m != nil {
		return m.File
	}
	return ""
}

func (m *GitDiffTreeFile) GetAdded() int64 {
	if m != nil {
		return m.Added
	}
	return 0
}

func (m *GitDiffTreeFile) GetDeleted() int64 {
	if m != nil {
		return m.Deleted
	}
	return 0
}

func (m *GitDiffTreeFile) GetBinary() bool {
	if m != nil {
		return m.Binary
	}
	return false
}

type GerritMutation struct {
	// Project is the Gerrit server and project, without scheme (https implied) or
	// trailing slash.
	Project string `protobuf:"bytes,1,opt,name=project" json:"project,omitempty"`
	// Commits to add.
	Commits []*GitCommit `protobuf:"bytes,2,rep,name=commits" json:"commits,omitempty"`
	// git refs to update.
	Refs []*GitRef `protobuf:"bytes,3,rep,name=refs" json:"refs,omitempty"`
	// deleted_refs are ref names to delete.
	DeletedRefs []string `protobuf:"bytes,4,rep,name=deleted_refs,json=deletedRefs" json:"deleted_refs,omitempty"`
}

func (m *GerritMutation) Reset()                    { *m = GerritMutation{} }
func (m *GerritMutation) String() string            { return proto.CompactTextString(m) }
func (*GerritMutation) ProtoMessage()               {}
func (*GerritMutation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *GerritMutation) GetProject() string {
	if m != nil {
		return m.Project
	}
	return ""
}

func (m *GerritMutation) GetCommits() []*GitCommit {
	if m != nil {
		return m.Commits
	}
	return nil
}

func (m *GerritMutation) GetRefs() []*GitRef {
	if m != nil {
		return m.Refs
	}
	return nil
}

func (m *GerritMutation) GetDeletedRefs() []string {
	if m != nil {
		return m.DeletedRefs
	}
	return nil
}

type GitRef struct {
	// ref is the git ref name, such as:
	//    HEAD
	//    refs/heads/master
	//    refs/changes/00/14700/1
	//    refs/changes/00/14700/meta
	//    refs/meta/config
	Ref string `protobuf:"bytes,1,opt,name=ref" json:"ref,omitempty"`
	// sha1 is the lowercase hex sha1
	Sha1 string `protobuf:"bytes,2,opt,name=sha1" json:"sha1,omitempty"`
}

func (m *GitRef) Reset()                    { *m = GitRef{} }
func (m *GitRef) String() string            { return proto.CompactTextString(m) }
func (*GitRef) ProtoMessage()               {}
func (*GitRef) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *GitRef) GetRef() string {
	if m != nil {
		return m.Ref
	}
	return ""
}

func (m *GitRef) GetSha1() string {
	if m != nil {
		return m.Sha1
	}
	return ""
}

func init() {
	proto.RegisterType((*Mutation)(nil), "maintpb.Mutation")
	proto.RegisterType((*GithubMutation)(nil), "maintpb.GithubMutation")
	proto.RegisterType((*GithubIssueMutation)(nil), "maintpb.GithubIssueMutation")
	proto.RegisterType((*BoolChange)(nil), "maintpb.BoolChange")
	proto.RegisterType((*StringChange)(nil), "maintpb.StringChange")
	proto.RegisterType((*GithubLabel)(nil), "maintpb.GithubLabel")
	proto.RegisterType((*GithubMilestone)(nil), "maintpb.GithubMilestone")
	proto.RegisterType((*GithubIssueEvent)(nil), "maintpb.GithubIssueEvent")
	proto.RegisterType((*GithubDismissedReviewEvent)(nil), "maintpb.GithubDismissedReviewEvent")
	proto.RegisterType((*GithubCommit)(nil), "maintpb.GithubCommit")
	proto.RegisterType((*GithubReview)(nil), "maintpb.GithubReview")
	proto.RegisterType((*GithubIssueSyncStatus)(nil), "maintpb.GithubIssueSyncStatus")
	proto.RegisterType((*GithubIssueCommentMutation)(nil), "maintpb.GithubIssueCommentMutation")
	proto.RegisterType((*GithubUser)(nil), "maintpb.GithubUser")
	proto.RegisterType((*GithubTeam)(nil), "maintpb.GithubTeam")
	proto.RegisterType((*GitMutation)(nil), "maintpb.GitMutation")
	proto.RegisterType((*GitRepo)(nil), "maintpb.GitRepo")
	proto.RegisterType((*GitCommit)(nil), "maintpb.GitCommit")
	proto.RegisterType((*GitDiffTree)(nil), "maintpb.GitDiffTree")
	proto.RegisterType((*GitDiffTreeFile)(nil), "maintpb.GitDiffTreeFile")
	proto.RegisterType((*GerritMutation)(nil), "maintpb.GerritMutation")
	proto.RegisterType((*GitRef)(nil), "maintpb.GitRef")
}

func init() { proto.RegisterFile("maintner.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 1540 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x57, 0x6d, 0x6f, 0xdb, 0xb6,
	0x13, 0x87, 0x9f, 0xa5, 0xb3, 0x93, 0xb8, 0x4c, 0xd3, 0xb2, 0xe9, 0x53, 0xfe, 0xea, 0x1f, 0x6b,
	0xd0, 0x07, 0xa7, 0xed, 0x86, 0xae, 0x40, 0x31, 0x0c, 0x69, 0xda, 0x0e, 0x2e, 0xd6, 0xbe, 0x60,
	0xd3, 0xd7, 0x82, 0x6c, 0xd1, 0x8e, 0x3a, 0x49, 0xf4, 0x24, 0x3a, 0x5d, 0x80, 0xbd, 0xea, 0xd7,
	0xd8, 0x8b, 0x0d, 0xfb, 0x4e, 0xfb, 0x3e, 0x03, 0x8f, 0xa4, 0x24, 0x3b, 0x4e, 0x93, 0xee, 0x1d,
	0xef, 0xee, 0x77, 0xe4, 0x1d, 0xef, 0x89, 0x84, 0xf5, 0x24, 0x88, 0x52, 0x99, 0xf2, 0x6c, 0x30,
	0xcb, 0x84, 0x14, 0xa4, 0x83, 0xf4, 0x6c, 0xb4, 0xfd, 0x7c, 0x1a, 0xc9, 0xa3, 0xf9, 0x68, 0x30,
	0x16, 0xc9, 0xde, 0x54, 0xc4, 0x41, 0x3a, 0xdd, 0x43, 0xc4, 0x68, 0x3e, 0xd9, 0x9b, 0xc9, 0x93,
	0x19, 0xcf, 0xf7, 0x64, 0x94, 0xf0, 0x5c, 0x06, 0xc9, 0xac, 0x5c, 0xe9, 0x5d, 0xbc, 0x7f, 0x6a,
	0xe0, 0xbc, 0x9d, 0xcb, 0x40, 0x46, 0x22, 0x25, 0x3f, 0x42, 0x4f, 0xef, 0xe5, 0x47, 0x79, 0x3e,
	0xe7, 0xb4, 0xb6, 0x53, 0xdb, 0xed, 0x3e, 0xb9, 0x31, 0x30, 0x27, 0x0d, 0x7e, 0x42, 0xe1, 0x50,
	0xc9, 0xac, 0x0e, 0xeb, 0x4e, 0x4b, 0x26, 0xd9, 0x83, 0xb6, 0x26, 0x69, 0x03, 0x55, 0xaf, 0x2e,
	0xa9, 0x16, 0x5a, 0x06, 0x46, 0xbe, 0x81, 0xc6, 0x34, 0x92, 0xb4, 0x8e, 0xe8, 0xcb, 0x55, 0x74,
	0x01, 0x55, 0x00, 0xdc, 0x98, 0x67, 0x59, 0x24, 0x69, 0x73, 0x79, 0x63, 0x64, 0x57, 0x36, 0x46,
	0xda, 0xfb, 0xbb, 0x06, 0xeb, 0x8b, 0x67, 0x92, 0xcb, 0xd0, 0x12, 0x9f, 0x52, 0x9e, 0xa1, 0x5b,
	0x2e, 0xd3, 0x04, 0x21, 0xd0, 0xcc, 0xf8, 0x4c, 0xa0, 0x09, 0x2e, 0xc3, 0x35, 0x79, 0x00, 0xed,
	0x38, 0x18, 0xf1, 0x38, 0xa7, 0x8d, 0x9d, 0xc6, 0xb2, 0x61, 0x47, 0xf3, 0xd1, 0xcf, 0x4a, 0xc8,
	0x0c, 0x86, 0x3c, 0x03, 0x48, 0xa2, 0x98, 0xe7, 0x52, 0xa4, 0x3c, 0xa7, 0x4d, 0xd4, 0xa0, 0xcb,
	0x8e, 0x5b, 0x00, 0xab, 0x60, 0xbd, 0x3f, 0x00, 0x36, 0x57, 0xdc, 0xe9, 0x57, 0x58, 0x7a, 0x05,
	0xda, 0xe9, 0x3c, 0x19, 0xf1, 0x0c, 0x2f, 0xbc, 0xc5, 0x0c, 0x45, 0xae, 0x83, 0x9b, 0x0a, 0xe9,
	0xf3, 0xdf, 0xa2, 0x5c, 0xd2, 0xb5, 0x9d, 0xda, 0xae, 0xc3, 0x9c, 0x54, 0xc8, 0x57, 0x8a, 0x26,
	0xeb, 0x50, 0x8f, 0x42, 0xda, 0xdb, 0xa9, 0xed, 0x36, 0x58, 0x3d, 0x0a, 0xc9, 0x5d, 0x68, 0xce,
	0x73, 0x9e, 0x99, 0xab, 0xdd, 0x5c, 0x32, 0xfd, 0x43, 0xce, 0x33, 0x86, 0x00, 0xf2, 0x18, 0xdc,
	0x20, 0xcf, 0xa3, 0x69, 0xca, 0x79, 0x4e, 0x01, 0x1d, 0x5d, 0x89, 0x2e, 0x51, 0xe4, 0x3e, 0x5c,
	0x0a, 0x79, 0xcc, 0x25, 0x0f, 0xfd, 0x52, 0xb5, 0xbb, 0xd3, 0xd8, 0x6d, 0xb0, 0xbe, 0x11, 0xec,
	0x17, 0xe0, 0xef, 0xa0, 0x33, 0xce, 0x78, 0x20, 0x79, 0x48, 0x5b, 0x68, 0xcb, 0xf6, 0x60, 0x2a,
	0xc4, 0x34, 0xe6, 0x03, 0x9b, 0xd0, 0x83, 0x43, 0x9b, 0xbf, 0xcc, 0x42, 0x95, 0xd6, 0x7c, 0x16,
	0xa2, 0x56, 0xfb, 0x7c, 0x2d, 0x03, 0x55, 0x77, 0x2c, 0x23, 0x19, 0x73, 0xea, 0xea, 0x3b, 0x46,
	0x82, 0x3c, 0x85, 0xee, 0x48, 0x84, 0x27, 0xfe, 0xf8, 0x28, 0x48, 0xa7, 0x9c, 0xde, 0xc6, 0xfd,
	0xb6, 0x0a, 0x1f, 0xdf, 0xcb, 0x2c, 0x4a, 0xa7, 0x07, 0x28, 0x64, 0xa0, 0x90, 0x7a, 0xad, 0x62,
	0xa3, 0x28, 0xda, 0xd1, 0xb1, 0x51, 0x6b, 0xf2, 0x3f, 0xe8, 0xa5, 0xc2, 0x2f, 0xc2, 0x4d, 0x37,
	0x30, 0x0c, 0xdd, 0x54, 0x14, 0xc9, 0xa0, 0x20, 0x85, 0xdc, 0x8f, 0x42, 0xda, 0xc7, 0x98, 0x74,
	0x0b, 0xde, 0x30, 0x24, 0x77, 0x60, 0xad, 0x84, 0xa4, 0xf3, 0x84, 0x5e, 0x42, 0x4c, 0xa9, 0xf7,
	0x6e, 0x9e, 0x90, 0xbb, 0xb0, 0x51, 0x82, 0xb4, 0x5b, 0x04, 0x2d, 0x59, 0x2f, 0xd8, 0x87, 0xe8,
	0xdf, 0x7d, 0x68, 0x8f, 0x63, 0x91, 0xf3, 0x90, 0x6e, 0x2e, 0x05, 0xfb, 0x85, 0x10, 0xb1, 0x71,
	0xcc, 0x40, 0x14, 0x38, 0x16, 0xe3, 0x5f, 0x78, 0x48, 0xaf, 0x7d, 0x01, 0xac, 0x21, 0xca, 0x95,
	0xd9, 0x3c, 0x8e, 0xfd, 0x8c, 0xff, 0x3a, 0xe7, 0xb9, 0xa4, 0x37, 0xb4, 0xb7, 0x8a, 0xc7, 0x34,
	0x8b, 0x7c, 0x0f, 0xae, 0xde, 0xd9, 0x0f, 0x24, 0xdd, 0x3a, 0x37, 0x54, 0x8e, 0x06, 0xef, 0x4b,
	0xf2, 0xa8, 0x50, 0x1c, 0x9d, 0xd0, 0x2b, 0x67, 0x67, 0xa9, 0xd1, 0x78, 0x81, 0x77, 0x9f, 0xf1,
	0x44, 0x1c, 0x73, 0x1f, 0x8b, 0x94, 0x5e, 0xc5, 0x8c, 0xeb, 0x6a, 0x1e, 0x96, 0x2f, 0x26, 0x73,
	0x18, 0x1a, 0x39, 0xfd, 0x42, 0x9d, 0x3b, 0x41, 0x18, 0x6a, 0x95, 0x1f, 0xa0, 0x33, 0x16, 0x49,
	0xc2, 0x53, 0x49, 0x1d, 0x54, 0xb8, 0xb3, 0xaa, 0x35, 0x1e, 0x68, 0x48, 0xd1, 0x92, 0xac, 0x0e,
	0x79, 0x05, 0xeb, 0x66, 0xe9, 0xe7, 0x32, 0x90, 0xf3, 0x9c, 0xae, 0xa3, 0x2f, 0xb7, 0x56, 0xed,
	0xf2, 0xfe, 0x24, 0x1d, 0xbf, 0x47, 0x14, 0x5b, 0x33, 0x5a, 0x9a, 0x24, 0x7b, 0xd0, 0xe2, 0xc7,
	0xca, 0x86, 0x6d, 0xb4, 0xe1, 0xda, 0x2a, 0xed, 0x57, 0x0a, 0xc0, 0x34, 0x8e, 0xec, 0x43, 0x0f,
	0x17, 0xf6, 0xd4, 0xeb, 0x17, 0x3a, 0xb5, 0x8b, 0x3a, 0xe6, 0xcc, 0x87, 0xd0, 0xce, 0xf8, 0x71,
	0xc4, 0x3f, 0xd1, 0x9b, 0x78, 0xe8, 0xd6, 0x92, 0x32, 0x43, 0x21, 0x33, 0x20, 0x72, 0x00, 0x6b,
	0x7a, 0x65, 0x8f, 0xbc, 0x75, 0xa1, 0x23, 0x7b, 0x5a, 0x49, 0x53, 0xde, 0x2d, 0x80, 0x32, 0xcf,
	0x48, 0x1f, 0x1a, 0xc7, 0x41, 0x8c, 0x1d, 0xd1, 0x61, 0x6a, 0xe9, 0xed, 0x40, 0xaf, 0x5a, 0x8f,
	0x55, 0x84, 0xab, 0x11, 0x8f, 0xa1, 0x5b, 0x09, 0xa4, 0xe9, 0x7b, 0xb5, 0xa2, 0xef, 0x11, 0x68,
	0xa6, 0x41, 0xc2, 0x6d, 0x43, 0x55, 0x6b, 0xef, 0x77, 0xd8, 0x58, 0xea, 0xd8, 0xa7, 0xd4, 0x8a,
	0xce, 0x51, 0xaf, 0x76, 0x8e, 0xb2, 0xb2, 0x1a, 0xe7, 0x57, 0x56, 0xd9, 0xb6, 0x9b, 0xb8, 0xad,
	0xa1, 0xbc, 0x3f, 0x5b, 0xd0, 0x5f, 0x8e, 0xe2, 0xa9, 0xf3, 0x6f, 0x02, 0xe8, 0x70, 0xaa, 0xd9,
	0x6e, 0x8c, 0x70, 0x91, 0x73, 0x78, 0x32, 0xe3, 0xe4, 0x1a, 0x38, 0xc1, 0x58, 0x8a, 0x4c, 0xf5,
	0x93, 0x06, 0x2a, 0x75, 0x90, 0x1e, 0x86, 0xd5, 0xfe, 0xda, 0xbc, 0x78, 0x7f, 0xbd, 0x07, 0x2d,
	0x5d, 0x24, 0xad, 0xd3, 0x53, 0xba, 0x28, 0x12, 0x0d, 0x21, 0x4f, 0xc1, 0x2d, 0x1b, 0x9e, 0xee,
	0xc6, 0x67, 0x8f, 0xc2, 0x12, 0x4a, 0x6e, 0x43, 0xd7, 0x8e, 0x07, 0x65, 0x77, 0x07, 0xed, 0x06,
	0xcb, 0x1a, 0x86, 0x15, 0x00, 0x3a, 0xe6, 0x2c, 0x00, 0x94, 0x6f, 0x0f, 0xa1, 0xad, 0xca, 0x24,
	0x92, 0xd8, 0xd0, 0x4f, 0x67, 0xe8, 0x01, 0x0a, 0x99, 0x01, 0xa9, 0xfd, 0x32, 0xae, 0x22, 0xee,
	0x4f, 0x32, 0x91, 0xd0, 0x2e, 0xde, 0x22, 0x68, 0xd6, 0xeb, 0x4c, 0x24, 0x6a, 0x82, 0x1a, 0x80,
	0x14, 0x38, 0x2b, 0x5d, 0xe6, 0x68, 0xc6, 0xa1, 0xd0, 0xda, 0x2a, 0x55, 0xb5, 0x35, 0x6b, 0xda,
	0x1a, 0xcb, 0x1a, 0x86, 0x64, 0x00, 0x9b, 0xa6, 0x00, 0x4c, 0x3f, 0xd4, 0xc0, 0x75, 0x04, 0x5e,
	0xd2, 0x22, 0x66, 0x25, 0xc3, 0x90, 0x3c, 0x83, 0x35, 0xc9, 0x83, 0xc4, 0xb7, 0x5b, 0xe0, 0x24,
	0x38, 0xdd, 0xe5, 0x0e, 0x79, 0x90, 0xb0, 0x9e, 0x42, 0x32, 0x03, 0x24, 0xef, 0xa0, 0x1f, 0x46,
	0x79, 0x12, 0xe5, 0xaa, 0x3d, 0x9a, 0x1a, 0xdd, 0x40, 0xe5, 0xe5, 0xe6, 0xf4, 0xd2, 0xc2, 0xb4,
	0xae, 0x6e, 0x11, 0x1b, 0xe1, 0x22, 0x57, 0x65, 0x97, 0x90, 0x47, 0x3c, 0xf3, 0x3f, 0xe6, 0x22,
	0xa5, 0xb0, 0x53, 0xdb, 0xed, 0x31, 0x17, 0x39, 0x6f, 0x72, 0x91, 0x7a, 0x9f, 0x6b, 0xb0, 0x7d,
	0xf6, 0x76, 0xfa, 0xd6, 0xd0, 0xef, 0x22, 0x65, 0x1d, 0xcd, 0x18, 0x86, 0xf8, 0x16, 0xd0, 0x4a,
	0x41, 0xec, 0x27, 0x3c, 0xcf, 0x83, 0x29, 0xc7, 0x14, 0x75, 0x59, 0xbf, 0x10, 0xbc, 0xd5, 0x7c,
	0x55, 0x65, 0xaa, 0x77, 0x70, 0xcc, 0x54, 0x97, 0x69, 0xe2, 0x4d, 0xd3, 0xa9, 0xf7, 0x1b, 0xde,
	0x07, 0xe8, 0x55, 0x83, 0xfa, 0x15, 0xef, 0xa5, 0xeb, 0xe0, 0xea, 0x04, 0xb0, 0xd5, 0xe1, 0x32,
	0x47, 0x33, 0x86, 0xa1, 0xf7, 0xb9, 0x6e, 0xf7, 0x35, 0x77, 0xb1, 0x5c, 0x79, 0xd5, 0xd2, 0xaa,
	0x9f, 0x59, 0x5a, 0x8d, 0x8b, 0x97, 0x96, 0x7d, 0x36, 0x34, 0x2b, 0xcf, 0x86, 0xc2, 0xf1, 0x56,
	0xc5, 0xf1, 0x45, 0xc3, 0xdb, 0x8b, 0x86, 0xab, 0x8b, 0xd5, 0x76, 0x05, 0x79, 0x2e, 0xc6, 0x11,
	0x8e, 0x1d, 0xf3, 0x14, 0xe9, 0xa3, 0x60, 0xbf, 0xe4, 0x2f, 0x05, 0xd8, 0x59, 0x0e, 0xf0, 0x21,
	0x6c, 0xad, 0x6c, 0xce, 0xe4, 0x39, 0x74, 0x73, 0x9e, 0x1d, 0xf3, 0xcc, 0x57, 0x0f, 0x28, 0xf3,
	0x37, 0xf8, 0x92, 0x97, 0xa0, 0xe1, 0x2f, 0x03, 0xc9, 0xd5, 0x37, 0x63, 0xfb, 0xec, 0x11, 0x79,
	0xea, 0xa2, 0xed, 0x8b, 0xb4, 0x7e, 0xde, 0x8b, 0xd4, 0x5e, 0x60, 0xa3, 0x72, 0x81, 0xff, 0xad,
	0xcb, 0x55, 0x5e, 0x91, 0xad, 0x0b, 0xbf, 0x22, 0xbd, 0x27, 0x00, 0xa5, 0x4d, 0xab, 0x26, 0x45,
	0x2c, 0xa6, 0x51, 0x6a, 0x27, 0x05, 0x12, 0xde, 0x23, 0xab, 0xa3, 0xaa, 0x79, 0xd5, 0x50, 0xca,
	0xe3, 0xf9, 0xd4, 0x66, 0xad, 0x5a, 0x7b, 0x3e, 0xce, 0xb1, 0xe2, 0xb6, 0xfe, 0x6f, 0x12, 0x5b,
	0x87, 0xa0, 0x5f, 0xbd, 0x1d, 0xc6, 0x67, 0xc2, 0xa4, 0xfa, 0xbd, 0xa2, 0x21, 0xea, 0x5b, 0x24,
	0x55, 0xdc, 0x62, 0x37, 0xf4, 0x3c, 0xe8, 0x18, 0x65, 0x72, 0x15, 0x3a, 0x53, 0xe1, 0x17, 0xfb,
	0xbb, 0xac, 0x3d, 0x15, 0x4a, 0xe0, 0x85, 0xe0, 0x16, 0x8a, 0x68, 0xe5, 0x51, 0xf0, 0xd8, 0x40,
	0x70, 0xad, 0xe6, 0x6f, 0x16, 0x7c, 0xc2, 0xd3, 0x7a, 0x4c, 0x2d, 0xd5, 0x13, 0x2b, 0x8c, 0x26,
	0x13, 0x5f, 0x66, 0x9c, 0x9b, 0xb2, 0x58, 0x98, 0x1e, 0x2f, 0xa3, 0xc9, 0xe4, 0x30, 0xe3, 0x9c,
	0x39, 0xa1, 0x59, 0x79, 0xcf, 0xd1, 0x55, 0x2b, 0x20, 0x0f, 0xa0, 0x39, 0x89, 0x62, 0x95, 0x6d,
	0xa7, 0x7e, 0x55, 0x16, 0xf3, 0x3a, 0x8a, 0x39, 0x43, 0x94, 0x97, 0xe0, 0xf0, 0xae, 0x0a, 0x94,
	0xa1, 0x66, 0x03, 0x34, 0x54, 0xad, 0x55, 0x58, 0x82, 0x30, 0xe4, 0xb6, 0x86, 0x35, 0x41, 0x28,
	0x74, 0xcc, 0x87, 0xc4, 0x8e, 0x4d, 0x43, 0xaa, 0x69, 0x3d, 0x8a, 0xd2, 0x20, 0xd3, 0x75, 0xea,
	0x30, 0x43, 0x79, 0x7f, 0xa9, 0x3f, 0xe6, 0xc2, 0xf7, 0x53, 0x6d, 0x32, 0xcb, 0xc4, 0x47, 0x3e,
	0x96, 0xe6, 0x44, 0x4b, 0x92, 0x07, 0xfa, 0xed, 0x18, 0xc9, 0x9c, 0xd6, 0xd1, 0x99, 0x55, 0xf1,
	0xb0, 0x10, 0x72, 0x47, 0x85, 0x78, 0x62, 0xff, 0x9f, 0x1b, 0x8b, 0x21, 0x9e, 0x30, 0x14, 0xaa,
	0x47, 0xae, 0xfd, 0x5b, 0x21, 0x58, 0x7d, 0x3d, 0x5d, 0xd6, 0x35, 0x3c, 0xc6, 0x27, 0xb9, 0x37,
	0x80, 0xb6, 0x56, 0xc1, 0xe8, 0xf0, 0x89, 0x7d, 0x1d, 0x65, 0x7c, 0x52, 0xc4, 0xb0, 0x5e, 0xc6,
	0x70, 0xd4, 0xc6, 0x64, 0xff, 0xf6, 0xdf, 0x00, 0x00, 0x00, 0xff, 0xff, 0xdd, 0x4d, 0xc5, 0xae,
	0x6d, 0x10, 0x00, 0x00,
}
