// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// FrontendBase Frontend Base
//
// HAProxy frontend configuration
// Example: {"default_backend":"test_backend","http_connection_mode":"http-keep-alive","maxconn":2000,"mode":"http","name":"test_frontend"}
//
// swagger:model frontend_base
type FrontendBase struct {

	// error files
	ErrorFiles []*Errorfile `json:"error_files,omitempty"`

	// error files from HTTP errors
	ErrorFilesFromHTTPErrors []*Errorfiles `json:"errorfiles_from_http_errors,omitempty"`

	// accept invalid http request
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	AcceptInvalidHTTPRequest string `json:"accept_invalid_http_request,omitempty"`

	// backlog
	Backlog *int64 `json:"backlog,omitempty"`

	// clflog
	Clflog bool `json:"clflog,omitempty"`

	// client fin timeout
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	ClientFinTimeout *int64 `json:"client_fin_timeout,omitempty"`

	// client timeout
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	ClientTimeout *int64 `json:"client_timeout,omitempty"`

	// clitcpka
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	Clitcpka string `json:"clitcpka,omitempty"`

	// clitcpka cnt
	ClitcpkaCnt *int64 `json:"clitcpka_cnt,omitempty"`

	// clitcpka idle
	ClitcpkaIdle *int64 `json:"clitcpka_idle,omitempty"`

	// clitcpka intvl
	ClitcpkaIntvl *int64 `json:"clitcpka_intvl,omitempty"`

	// compression
	Compression *Compression `json:"compression,omitempty"`

	// contstats
	// Enum: ["enabled"]
	// +kubebuilder:validation:Enum="enabled";
	Contstats string `json:"contstats,omitempty"`

	// default backend
	// Pattern: ^[A-Za-z0-9-_.:]+$
	// +kubebuilder:validation:Pattern=`^[A-Za-z0-9-_.:]+$`
	DefaultBackend string `json:"default_backend,omitempty"`

	// description
	Description string `json:"description,omitempty"`

	// disable h2 upgrade
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	DisableH2Upgrade string `json:"disable_h2_upgrade,omitempty"`

	// disabled
	Disabled bool `json:"disabled,omitempty"`

	// dontlog normal
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	DontlogNormal string `json:"dontlog_normal,omitempty"`

	// dontlognull
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	Dontlognull string `json:"dontlognull,omitempty"`

	// email alert
	EmailAlert *EmailAlert `json:"email_alert,omitempty"`

	// enabled
	Enabled bool `json:"enabled,omitempty"`

	// error log format
	ErrorLogFormat string `json:"error_log_format,omitempty"`

	// errorloc302
	Errorloc302 *Errorloc `json:"errorloc302,omitempty"`

	// errorloc303
	Errorloc303 *Errorloc `json:"errorloc303,omitempty"`

	// forwardfor
	Forwardfor *Forwardfor `json:"forwardfor,omitempty"`

	// from
	// Pattern: ^[A-Za-z0-9-_.:]+$
	// +kubebuilder:validation:Pattern=`^[A-Za-z0-9-_.:]+$`
	From string `json:"from,omitempty"`

	// guid
	// Pattern: ^[A-Za-z0-9-_.:]+$
	// +kubebuilder:validation:Pattern=`^[A-Za-z0-9-_.:]+$`
	GUID string `json:"guid,omitempty"`

	// h1 case adjust bogus client
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	H1CaseAdjustBogusClient string `json:"h1_case_adjust_bogus_client,omitempty"`

	// http buffer request
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	HTTPBufferRequest string `json:"http-buffer-request,omitempty"`

	// http use htx
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	HTTPUseHtx string `json:"http-use-htx,omitempty"`

	// http connection mode
	// Enum: ["httpclose","http-server-close","http-keep-alive"]
	// +kubebuilder:validation:Enum="httpclose","http-server-close","http-keep-alive";
	HTTPConnectionMode string `json:"http_connection_mode,omitempty"`

	// http ignore probes
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	HTTPIgnoreProbes string `json:"http_ignore_probes,omitempty"`

	// http keep alive timeout
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	HTTPKeepAliveTimeout *int64 `json:"http_keep_alive_timeout,omitempty"`

	// http no delay
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	HTTPNoDelay string `json:"http_no_delay,omitempty"`

	// http request timeout
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	HTTPRequestTimeout *int64 `json:"http_request_timeout,omitempty"`

	// http restrict req hdr names
	// Enum: ["preserve","delete","reject"]
	// +kubebuilder:validation:Enum="preserve","delete","reject";
	HTTPRestrictReqHdrNames string `json:"http_restrict_req_hdr_names,omitempty"`

	// http use proxy header
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	HTTPUseProxyHeader string `json:"http_use_proxy_header,omitempty"`

	// httplog
	Httplog bool `json:"httplog,omitempty"`

	// httpslog
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	Httpslog string `json:"httpslog,omitempty"`

	// id
	ID *int64 `json:"id,omitempty"`

	// idle close on response
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	IdleCloseOnResponse string `json:"idle_close_on_response,omitempty"`

	// independent streams
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	IndependentStreams string `json:"independent_streams,omitempty"`

	// log format
	LogFormat string `json:"log_format,omitempty"`

	// log format sd
	LogFormatSd string `json:"log_format_sd,omitempty"`

	// log separate errors
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	LogSeparateErrors string `json:"log_separate_errors,omitempty"`

	// log tag
	// Pattern: ^[A-Za-z0-9-_.:]+$
	// +kubebuilder:validation:Pattern=`^[A-Za-z0-9-_.:]+$`
	LogTag string `json:"log_tag,omitempty"`

	// logasap
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	Logasap string `json:"logasap,omitempty"`

	// maxconn
	Maxconn *int64 `json:"maxconn,omitempty"`

	// mode
	// Enum: ["http","tcp"]
	// +kubebuilder:validation:Enum="http","tcp";
	Mode string `json:"mode,omitempty"`

	// monitor fail
	MonitorFail *MonitorFail `json:"monitor_fail,omitempty"`

	// monitor uri
	MonitorURI MonitorURI `json:"monitor_uri,omitempty"`

	// name
	// Required: true
	// Pattern: ^[A-Za-z0-9-_.:]+$
	// +kubebuilder:validation:Pattern=`^[A-Za-z0-9-_.:]+$`
	Name string `json:"name"`

	// nolinger
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	Nolinger string `json:"nolinger,omitempty"`

	// originalto
	Originalto *Originalto `json:"originalto,omitempty"`

	// socket stats
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	SocketStats string `json:"socket_stats,omitempty"`

	// splice auto
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	SpliceAuto string `json:"splice_auto,omitempty"`

	// splice request
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	SpliceRequest string `json:"splice_request,omitempty"`

	// splice response
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	SpliceResponse string `json:"splice_response,omitempty"`

	// stats options
	StatsOptions *StatsOptions `json:"stats_options,omitempty"`

	// stick table
	StickTable *ConfigStickTable `json:"stick_table,omitempty"`

	// tarpit timeout
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	TarpitTimeout *int64 `json:"tarpit_timeout,omitempty"`

	// tcp smart accept
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	TCPSmartAccept string `json:"tcp_smart_accept,omitempty"`

	// tcpka
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	Tcpka string `json:"tcpka,omitempty"`

	// tcplog
	Tcplog bool `json:"tcplog,omitempty"`

	// unique id format
	UniqueIDFormat string `json:"unique_id_format,omitempty"`

	// unique id header
	UniqueIDHeader string `json:"unique_id_header,omitempty"`
}

// Validate validates this frontend base
func (m *FrontendBase) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateErrorFiles(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateErrorFilesFromHTTPErrors(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAcceptInvalidHTTPRequest(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClientFinTimeout(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClientTimeout(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClitcpka(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCompression(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateContstats(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDefaultBackend(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDisableH2Upgrade(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDontlogNormal(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDontlognull(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEmailAlert(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateErrorloc302(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateErrorloc303(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateForwardfor(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFrom(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGUID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateH1CaseAdjustBogusClient(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPBufferRequest(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPUseHtx(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPConnectionMode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPIgnoreProbes(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPKeepAliveTimeout(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPNoDelay(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPRequestTimeout(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPRestrictReqHdrNames(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPUseProxyHeader(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHttpslog(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIdleCloseOnResponse(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIndependentStreams(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLogSeparateErrors(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLogTag(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLogasap(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMonitorFail(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMonitorURI(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNolinger(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOriginalto(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSocketStats(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpliceAuto(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpliceRequest(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpliceResponse(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatsOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStickTable(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTarpitTimeout(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTCPSmartAccept(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTcpka(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FrontendBase) validateErrorFiles(formats strfmt.Registry) error {
	if swag.IsZero(m.ErrorFiles) { // not required
		return nil
	}

	for i := 0; i < len(m.ErrorFiles); i++ {
		if swag.IsZero(m.ErrorFiles[i]) { // not required
			continue
		}

		if m.ErrorFiles[i] != nil {
			if err := m.ErrorFiles[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("error_files" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("error_files" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *FrontendBase) validateErrorFilesFromHTTPErrors(formats strfmt.Registry) error {
	if swag.IsZero(m.ErrorFilesFromHTTPErrors) { // not required
		return nil
	}

	for i := 0; i < len(m.ErrorFilesFromHTTPErrors); i++ {
		if swag.IsZero(m.ErrorFilesFromHTTPErrors[i]) { // not required
			continue
		}

		if m.ErrorFilesFromHTTPErrors[i] != nil {
			if err := m.ErrorFilesFromHTTPErrors[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("errorfiles_from_http_errors" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("errorfiles_from_http_errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var frontendBaseTypeAcceptInvalidHTTPRequestPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		frontendBaseTypeAcceptInvalidHTTPRequestPropEnum = append(frontendBaseTypeAcceptInvalidHTTPRequestPropEnum, v)
	}
}

const (

	// FrontendBaseAcceptInvalidHTTPRequestEnabled captures enum value "enabled"
	FrontendBaseAcceptInvalidHTTPRequestEnabled string = "enabled"

	// FrontendBaseAcceptInvalidHTTPRequestDisabled captures enum value "disabled"
	FrontendBaseAcceptInvalidHTTPRequestDisabled string = "disabled"
)

// prop value enum
func (m *FrontendBase) validateAcceptInvalidHTTPRequestEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, frontendBaseTypeAcceptInvalidHTTPRequestPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FrontendBase) validateAcceptInvalidHTTPRequest(formats strfmt.Registry) error {
	if swag.IsZero(m.AcceptInvalidHTTPRequest) { // not required
		return nil
	}

	// value enum
	if err := m.validateAcceptInvalidHTTPRequestEnum("accept_invalid_http_request", "body", m.AcceptInvalidHTTPRequest); err != nil {
		return err
	}

	return nil
}

func (m *FrontendBase) validateClientFinTimeout(formats strfmt.Registry) error {
	if swag.IsZero(m.ClientFinTimeout) { // not required
		return nil
	}

	if err := validate.MinimumInt("client_fin_timeout", "body", *m.ClientFinTimeout, 0, false); err != nil {
		return err
	}

	return nil
}

func (m *FrontendBase) validateClientTimeout(formats strfmt.Registry) error {
	if swag.IsZero(m.ClientTimeout) { // not required
		return nil
	}

	if err := validate.MinimumInt("client_timeout", "body", *m.ClientTimeout, 0, false); err != nil {
		return err
	}

	return nil
}

var frontendBaseTypeClitcpkaPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		frontendBaseTypeClitcpkaPropEnum = append(frontendBaseTypeClitcpkaPropEnum, v)
	}
}

const (

	// FrontendBaseClitcpkaEnabled captures enum value "enabled"
	FrontendBaseClitcpkaEnabled string = "enabled"

	// FrontendBaseClitcpkaDisabled captures enum value "disabled"
	FrontendBaseClitcpkaDisabled string = "disabled"
)

// prop value enum
func (m *FrontendBase) validateClitcpkaEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, frontendBaseTypeClitcpkaPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FrontendBase) validateClitcpka(formats strfmt.Registry) error {
	if swag.IsZero(m.Clitcpka) { // not required
		return nil
	}

	// value enum
	if err := m.validateClitcpkaEnum("clitcpka", "body", m.Clitcpka); err != nil {
		return err
	}

	return nil
}

func (m *FrontendBase) validateCompression(formats strfmt.Registry) error {
	if swag.IsZero(m.Compression) { // not required
		return nil
	}

	if m.Compression != nil {
		if err := m.Compression.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("compression")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("compression")
			}
			return err
		}
	}

	return nil
}

var frontendBaseTypeContstatsPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		frontendBaseTypeContstatsPropEnum = append(frontendBaseTypeContstatsPropEnum, v)
	}
}

const (

	// FrontendBaseContstatsEnabled captures enum value "enabled"
	FrontendBaseContstatsEnabled string = "enabled"
)

// prop value enum
func (m *FrontendBase) validateContstatsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, frontendBaseTypeContstatsPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FrontendBase) validateContstats(formats strfmt.Registry) error {
	if swag.IsZero(m.Contstats) { // not required
		return nil
	}

	// value enum
	if err := m.validateContstatsEnum("contstats", "body", m.Contstats); err != nil {
		return err
	}

	return nil
}

func (m *FrontendBase) validateDefaultBackend(formats strfmt.Registry) error {
	if swag.IsZero(m.DefaultBackend) { // not required
		return nil
	}

	if err := validate.Pattern("default_backend", "body", m.DefaultBackend, `^[A-Za-z0-9-_.:]+$`); err != nil {
		return err
	}

	return nil
}

var frontendBaseTypeDisableH2UpgradePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		frontendBaseTypeDisableH2UpgradePropEnum = append(frontendBaseTypeDisableH2UpgradePropEnum, v)
	}
}

const (

	// FrontendBaseDisableH2UpgradeEnabled captures enum value "enabled"
	FrontendBaseDisableH2UpgradeEnabled string = "enabled"

	// FrontendBaseDisableH2UpgradeDisabled captures enum value "disabled"
	FrontendBaseDisableH2UpgradeDisabled string = "disabled"
)

// prop value enum
func (m *FrontendBase) validateDisableH2UpgradeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, frontendBaseTypeDisableH2UpgradePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FrontendBase) validateDisableH2Upgrade(formats strfmt.Registry) error {
	if swag.IsZero(m.DisableH2Upgrade) { // not required
		return nil
	}

	// value enum
	if err := m.validateDisableH2UpgradeEnum("disable_h2_upgrade", "body", m.DisableH2Upgrade); err != nil {
		return err
	}

	return nil
}

var frontendBaseTypeDontlogNormalPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		frontendBaseTypeDontlogNormalPropEnum = append(frontendBaseTypeDontlogNormalPropEnum, v)
	}
}

const (

	// FrontendBaseDontlogNormalEnabled captures enum value "enabled"
	FrontendBaseDontlogNormalEnabled string = "enabled"

	// FrontendBaseDontlogNormalDisabled captures enum value "disabled"
	FrontendBaseDontlogNormalDisabled string = "disabled"
)

// prop value enum
func (m *FrontendBase) validateDontlogNormalEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, frontendBaseTypeDontlogNormalPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FrontendBase) validateDontlogNormal(formats strfmt.Registry) error {
	if swag.IsZero(m.DontlogNormal) { // not required
		return nil
	}

	// value enum
	if err := m.validateDontlogNormalEnum("dontlog_normal", "body", m.DontlogNormal); err != nil {
		return err
	}

	return nil
}

var frontendBaseTypeDontlognullPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		frontendBaseTypeDontlognullPropEnum = append(frontendBaseTypeDontlognullPropEnum, v)
	}
}

const (

	// FrontendBaseDontlognullEnabled captures enum value "enabled"
	FrontendBaseDontlognullEnabled string = "enabled"

	// FrontendBaseDontlognullDisabled captures enum value "disabled"
	FrontendBaseDontlognullDisabled string = "disabled"
)

// prop value enum
func (m *FrontendBase) validateDontlognullEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, frontendBaseTypeDontlognullPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FrontendBase) validateDontlognull(formats strfmt.Registry) error {
	if swag.IsZero(m.Dontlognull) { // not required
		return nil
	}

	// value enum
	if err := m.validateDontlognullEnum("dontlognull", "body", m.Dontlognull); err != nil {
		return err
	}

	return nil
}

func (m *FrontendBase) validateEmailAlert(formats strfmt.Registry) error {
	if swag.IsZero(m.EmailAlert) { // not required
		return nil
	}

	if m.EmailAlert != nil {
		if err := m.EmailAlert.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("email_alert")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("email_alert")
			}
			return err
		}
	}

	return nil
}

func (m *FrontendBase) validateErrorloc302(formats strfmt.Registry) error {
	if swag.IsZero(m.Errorloc302) { // not required
		return nil
	}

	if m.Errorloc302 != nil {
		if err := m.Errorloc302.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("errorloc302")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("errorloc302")
			}
			return err
		}
	}

	return nil
}

func (m *FrontendBase) validateErrorloc303(formats strfmt.Registry) error {
	if swag.IsZero(m.Errorloc303) { // not required
		return nil
	}

	if m.Errorloc303 != nil {
		if err := m.Errorloc303.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("errorloc303")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("errorloc303")
			}
			return err
		}
	}

	return nil
}

func (m *FrontendBase) validateForwardfor(formats strfmt.Registry) error {
	if swag.IsZero(m.Forwardfor) { // not required
		return nil
	}

	if m.Forwardfor != nil {
		if err := m.Forwardfor.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("forwardfor")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("forwardfor")
			}
			return err
		}
	}

	return nil
}

func (m *FrontendBase) validateFrom(formats strfmt.Registry) error {
	if swag.IsZero(m.From) { // not required
		return nil
	}

	if err := validate.Pattern("from", "body", m.From, `^[A-Za-z0-9-_.:]+$`); err != nil {
		return err
	}

	return nil
}

func (m *FrontendBase) validateGUID(formats strfmt.Registry) error {
	if swag.IsZero(m.GUID) { // not required
		return nil
	}

	if err := validate.Pattern("guid", "body", m.GUID, `^[A-Za-z0-9-_.:]+$`); err != nil {
		return err
	}

	return nil
}

var frontendBaseTypeH1CaseAdjustBogusClientPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		frontendBaseTypeH1CaseAdjustBogusClientPropEnum = append(frontendBaseTypeH1CaseAdjustBogusClientPropEnum, v)
	}
}

const (

	// FrontendBaseH1CaseAdjustBogusClientEnabled captures enum value "enabled"
	FrontendBaseH1CaseAdjustBogusClientEnabled string = "enabled"

	// FrontendBaseH1CaseAdjustBogusClientDisabled captures enum value "disabled"
	FrontendBaseH1CaseAdjustBogusClientDisabled string = "disabled"
)

// prop value enum
func (m *FrontendBase) validateH1CaseAdjustBogusClientEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, frontendBaseTypeH1CaseAdjustBogusClientPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FrontendBase) validateH1CaseAdjustBogusClient(formats strfmt.Registry) error {
	if swag.IsZero(m.H1CaseAdjustBogusClient) { // not required
		return nil
	}

	// value enum
	if err := m.validateH1CaseAdjustBogusClientEnum("h1_case_adjust_bogus_client", "body", m.H1CaseAdjustBogusClient); err != nil {
		return err
	}

	return nil
}

var frontendBaseTypeHTTPBufferRequestPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		frontendBaseTypeHTTPBufferRequestPropEnum = append(frontendBaseTypeHTTPBufferRequestPropEnum, v)
	}
}

const (

	// FrontendBaseHTTPBufferRequestEnabled captures enum value "enabled"
	FrontendBaseHTTPBufferRequestEnabled string = "enabled"

	// FrontendBaseHTTPBufferRequestDisabled captures enum value "disabled"
	FrontendBaseHTTPBufferRequestDisabled string = "disabled"
)

// prop value enum
func (m *FrontendBase) validateHTTPBufferRequestEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, frontendBaseTypeHTTPBufferRequestPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FrontendBase) validateHTTPBufferRequest(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPBufferRequest) { // not required
		return nil
	}

	// value enum
	if err := m.validateHTTPBufferRequestEnum("http-buffer-request", "body", m.HTTPBufferRequest); err != nil {
		return err
	}

	return nil
}

var frontendBaseTypeHTTPUseHtxPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		frontendBaseTypeHTTPUseHtxPropEnum = append(frontendBaseTypeHTTPUseHtxPropEnum, v)
	}
}

const (

	// FrontendBaseHTTPUseHtxEnabled captures enum value "enabled"
	FrontendBaseHTTPUseHtxEnabled string = "enabled"

	// FrontendBaseHTTPUseHtxDisabled captures enum value "disabled"
	FrontendBaseHTTPUseHtxDisabled string = "disabled"
)

// prop value enum
func (m *FrontendBase) validateHTTPUseHtxEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, frontendBaseTypeHTTPUseHtxPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FrontendBase) validateHTTPUseHtx(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPUseHtx) { // not required
		return nil
	}

	// value enum
	if err := m.validateHTTPUseHtxEnum("http-use-htx", "body", m.HTTPUseHtx); err != nil {
		return err
	}

	return nil
}

var frontendBaseTypeHTTPConnectionModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["httpclose","http-server-close","http-keep-alive"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		frontendBaseTypeHTTPConnectionModePropEnum = append(frontendBaseTypeHTTPConnectionModePropEnum, v)
	}
}

const (

	// FrontendBaseHTTPConnectionModeHttpclose captures enum value "httpclose"
	FrontendBaseHTTPConnectionModeHttpclose string = "httpclose"

	// FrontendBaseHTTPConnectionModeHTTPDashServerDashClose captures enum value "http-server-close"
	FrontendBaseHTTPConnectionModeHTTPDashServerDashClose string = "http-server-close"

	// FrontendBaseHTTPConnectionModeHTTPDashKeepDashAlive captures enum value "http-keep-alive"
	FrontendBaseHTTPConnectionModeHTTPDashKeepDashAlive string = "http-keep-alive"
)

// prop value enum
func (m *FrontendBase) validateHTTPConnectionModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, frontendBaseTypeHTTPConnectionModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FrontendBase) validateHTTPConnectionMode(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPConnectionMode) { // not required
		return nil
	}

	// value enum
	if err := m.validateHTTPConnectionModeEnum("http_connection_mode", "body", m.HTTPConnectionMode); err != nil {
		return err
	}

	return nil
}

var frontendBaseTypeHTTPIgnoreProbesPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		frontendBaseTypeHTTPIgnoreProbesPropEnum = append(frontendBaseTypeHTTPIgnoreProbesPropEnum, v)
	}
}

const (

	// FrontendBaseHTTPIgnoreProbesEnabled captures enum value "enabled"
	FrontendBaseHTTPIgnoreProbesEnabled string = "enabled"

	// FrontendBaseHTTPIgnoreProbesDisabled captures enum value "disabled"
	FrontendBaseHTTPIgnoreProbesDisabled string = "disabled"
)

// prop value enum
func (m *FrontendBase) validateHTTPIgnoreProbesEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, frontendBaseTypeHTTPIgnoreProbesPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FrontendBase) validateHTTPIgnoreProbes(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPIgnoreProbes) { // not required
		return nil
	}

	// value enum
	if err := m.validateHTTPIgnoreProbesEnum("http_ignore_probes", "body", m.HTTPIgnoreProbes); err != nil {
		return err
	}

	return nil
}

func (m *FrontendBase) validateHTTPKeepAliveTimeout(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPKeepAliveTimeout) { // not required
		return nil
	}

	if err := validate.MinimumInt("http_keep_alive_timeout", "body", *m.HTTPKeepAliveTimeout, 0, false); err != nil {
		return err
	}

	return nil
}

var frontendBaseTypeHTTPNoDelayPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		frontendBaseTypeHTTPNoDelayPropEnum = append(frontendBaseTypeHTTPNoDelayPropEnum, v)
	}
}

const (

	// FrontendBaseHTTPNoDelayEnabled captures enum value "enabled"
	FrontendBaseHTTPNoDelayEnabled string = "enabled"

	// FrontendBaseHTTPNoDelayDisabled captures enum value "disabled"
	FrontendBaseHTTPNoDelayDisabled string = "disabled"
)

// prop value enum
func (m *FrontendBase) validateHTTPNoDelayEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, frontendBaseTypeHTTPNoDelayPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FrontendBase) validateHTTPNoDelay(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPNoDelay) { // not required
		return nil
	}

	// value enum
	if err := m.validateHTTPNoDelayEnum("http_no_delay", "body", m.HTTPNoDelay); err != nil {
		return err
	}

	return nil
}

func (m *FrontendBase) validateHTTPRequestTimeout(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPRequestTimeout) { // not required
		return nil
	}

	if err := validate.MinimumInt("http_request_timeout", "body", *m.HTTPRequestTimeout, 0, false); err != nil {
		return err
	}

	return nil
}

var frontendBaseTypeHTTPRestrictReqHdrNamesPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["preserve","delete","reject"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		frontendBaseTypeHTTPRestrictReqHdrNamesPropEnum = append(frontendBaseTypeHTTPRestrictReqHdrNamesPropEnum, v)
	}
}

const (

	// FrontendBaseHTTPRestrictReqHdrNamesPreserve captures enum value "preserve"
	FrontendBaseHTTPRestrictReqHdrNamesPreserve string = "preserve"

	// FrontendBaseHTTPRestrictReqHdrNamesDelete captures enum value "delete"
	FrontendBaseHTTPRestrictReqHdrNamesDelete string = "delete"

	// FrontendBaseHTTPRestrictReqHdrNamesReject captures enum value "reject"
	FrontendBaseHTTPRestrictReqHdrNamesReject string = "reject"
)

// prop value enum
func (m *FrontendBase) validateHTTPRestrictReqHdrNamesEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, frontendBaseTypeHTTPRestrictReqHdrNamesPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FrontendBase) validateHTTPRestrictReqHdrNames(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPRestrictReqHdrNames) { // not required
		return nil
	}

	// value enum
	if err := m.validateHTTPRestrictReqHdrNamesEnum("http_restrict_req_hdr_names", "body", m.HTTPRestrictReqHdrNames); err != nil {
		return err
	}

	return nil
}

var frontendBaseTypeHTTPUseProxyHeaderPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		frontendBaseTypeHTTPUseProxyHeaderPropEnum = append(frontendBaseTypeHTTPUseProxyHeaderPropEnum, v)
	}
}

const (

	// FrontendBaseHTTPUseProxyHeaderEnabled captures enum value "enabled"
	FrontendBaseHTTPUseProxyHeaderEnabled string = "enabled"

	// FrontendBaseHTTPUseProxyHeaderDisabled captures enum value "disabled"
	FrontendBaseHTTPUseProxyHeaderDisabled string = "disabled"
)

// prop value enum
func (m *FrontendBase) validateHTTPUseProxyHeaderEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, frontendBaseTypeHTTPUseProxyHeaderPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FrontendBase) validateHTTPUseProxyHeader(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPUseProxyHeader) { // not required
		return nil
	}

	// value enum
	if err := m.validateHTTPUseProxyHeaderEnum("http_use_proxy_header", "body", m.HTTPUseProxyHeader); err != nil {
		return err
	}

	return nil
}

var frontendBaseTypeHttpslogPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		frontendBaseTypeHttpslogPropEnum = append(frontendBaseTypeHttpslogPropEnum, v)
	}
}

const (

	// FrontendBaseHttpslogEnabled captures enum value "enabled"
	FrontendBaseHttpslogEnabled string = "enabled"

	// FrontendBaseHttpslogDisabled captures enum value "disabled"
	FrontendBaseHttpslogDisabled string = "disabled"
)

// prop value enum
func (m *FrontendBase) validateHttpslogEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, frontendBaseTypeHttpslogPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FrontendBase) validateHttpslog(formats strfmt.Registry) error {
	if swag.IsZero(m.Httpslog) { // not required
		return nil
	}

	// value enum
	if err := m.validateHttpslogEnum("httpslog", "body", m.Httpslog); err != nil {
		return err
	}

	return nil
}

var frontendBaseTypeIdleCloseOnResponsePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		frontendBaseTypeIdleCloseOnResponsePropEnum = append(frontendBaseTypeIdleCloseOnResponsePropEnum, v)
	}
}

const (

	// FrontendBaseIdleCloseOnResponseEnabled captures enum value "enabled"
	FrontendBaseIdleCloseOnResponseEnabled string = "enabled"

	// FrontendBaseIdleCloseOnResponseDisabled captures enum value "disabled"
	FrontendBaseIdleCloseOnResponseDisabled string = "disabled"
)

// prop value enum
func (m *FrontendBase) validateIdleCloseOnResponseEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, frontendBaseTypeIdleCloseOnResponsePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FrontendBase) validateIdleCloseOnResponse(formats strfmt.Registry) error {
	if swag.IsZero(m.IdleCloseOnResponse) { // not required
		return nil
	}

	// value enum
	if err := m.validateIdleCloseOnResponseEnum("idle_close_on_response", "body", m.IdleCloseOnResponse); err != nil {
		return err
	}

	return nil
}

var frontendBaseTypeIndependentStreamsPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		frontendBaseTypeIndependentStreamsPropEnum = append(frontendBaseTypeIndependentStreamsPropEnum, v)
	}
}

const (

	// FrontendBaseIndependentStreamsEnabled captures enum value "enabled"
	FrontendBaseIndependentStreamsEnabled string = "enabled"

	// FrontendBaseIndependentStreamsDisabled captures enum value "disabled"
	FrontendBaseIndependentStreamsDisabled string = "disabled"
)

// prop value enum
func (m *FrontendBase) validateIndependentStreamsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, frontendBaseTypeIndependentStreamsPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FrontendBase) validateIndependentStreams(formats strfmt.Registry) error {
	if swag.IsZero(m.IndependentStreams) { // not required
		return nil
	}

	// value enum
	if err := m.validateIndependentStreamsEnum("independent_streams", "body", m.IndependentStreams); err != nil {
		return err
	}

	return nil
}

var frontendBaseTypeLogSeparateErrorsPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		frontendBaseTypeLogSeparateErrorsPropEnum = append(frontendBaseTypeLogSeparateErrorsPropEnum, v)
	}
}

const (

	// FrontendBaseLogSeparateErrorsEnabled captures enum value "enabled"
	FrontendBaseLogSeparateErrorsEnabled string = "enabled"

	// FrontendBaseLogSeparateErrorsDisabled captures enum value "disabled"
	FrontendBaseLogSeparateErrorsDisabled string = "disabled"
)

// prop value enum
func (m *FrontendBase) validateLogSeparateErrorsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, frontendBaseTypeLogSeparateErrorsPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FrontendBase) validateLogSeparateErrors(formats strfmt.Registry) error {
	if swag.IsZero(m.LogSeparateErrors) { // not required
		return nil
	}

	// value enum
	if err := m.validateLogSeparateErrorsEnum("log_separate_errors", "body", m.LogSeparateErrors); err != nil {
		return err
	}

	return nil
}

func (m *FrontendBase) validateLogTag(formats strfmt.Registry) error {
	if swag.IsZero(m.LogTag) { // not required
		return nil
	}

	if err := validate.Pattern("log_tag", "body", m.LogTag, `^[A-Za-z0-9-_.:]+$`); err != nil {
		return err
	}

	return nil
}

var frontendBaseTypeLogasapPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		frontendBaseTypeLogasapPropEnum = append(frontendBaseTypeLogasapPropEnum, v)
	}
}

const (

	// FrontendBaseLogasapEnabled captures enum value "enabled"
	FrontendBaseLogasapEnabled string = "enabled"

	// FrontendBaseLogasapDisabled captures enum value "disabled"
	FrontendBaseLogasapDisabled string = "disabled"
)

// prop value enum
func (m *FrontendBase) validateLogasapEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, frontendBaseTypeLogasapPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FrontendBase) validateLogasap(formats strfmt.Registry) error {
	if swag.IsZero(m.Logasap) { // not required
		return nil
	}

	// value enum
	if err := m.validateLogasapEnum("logasap", "body", m.Logasap); err != nil {
		return err
	}

	return nil
}

var frontendBaseTypeModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["http","tcp"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		frontendBaseTypeModePropEnum = append(frontendBaseTypeModePropEnum, v)
	}
}

const (

	// FrontendBaseModeHTTP captures enum value "http"
	FrontendBaseModeHTTP string = "http"

	// FrontendBaseModeTCP captures enum value "tcp"
	FrontendBaseModeTCP string = "tcp"
)

// prop value enum
func (m *FrontendBase) validateModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, frontendBaseTypeModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FrontendBase) validateMode(formats strfmt.Registry) error {
	if swag.IsZero(m.Mode) { // not required
		return nil
	}

	// value enum
	if err := m.validateModeEnum("mode", "body", m.Mode); err != nil {
		return err
	}

	return nil
}

func (m *FrontendBase) validateMonitorFail(formats strfmt.Registry) error {
	if swag.IsZero(m.MonitorFail) { // not required
		return nil
	}

	if m.MonitorFail != nil {
		if err := m.MonitorFail.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("monitor_fail")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("monitor_fail")
			}
			return err
		}
	}

	return nil
}

func (m *FrontendBase) validateMonitorURI(formats strfmt.Registry) error {
	if swag.IsZero(m.MonitorURI) { // not required
		return nil
	}

	if err := m.MonitorURI.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("monitor_uri")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("monitor_uri")
		}
		return err
	}

	return nil
}

func (m *FrontendBase) validateName(formats strfmt.Registry) error {

	if err := validate.RequiredString("name", "body", m.Name); err != nil {
		return err
	}

	if err := validate.Pattern("name", "body", m.Name, `^[A-Za-z0-9-_.:]+$`); err != nil {
		return err
	}

	return nil
}

var frontendBaseTypeNolingerPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		frontendBaseTypeNolingerPropEnum = append(frontendBaseTypeNolingerPropEnum, v)
	}
}

const (

	// FrontendBaseNolingerEnabled captures enum value "enabled"
	FrontendBaseNolingerEnabled string = "enabled"

	// FrontendBaseNolingerDisabled captures enum value "disabled"
	FrontendBaseNolingerDisabled string = "disabled"
)

// prop value enum
func (m *FrontendBase) validateNolingerEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, frontendBaseTypeNolingerPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FrontendBase) validateNolinger(formats strfmt.Registry) error {
	if swag.IsZero(m.Nolinger) { // not required
		return nil
	}

	// value enum
	if err := m.validateNolingerEnum("nolinger", "body", m.Nolinger); err != nil {
		return err
	}

	return nil
}

func (m *FrontendBase) validateOriginalto(formats strfmt.Registry) error {
	if swag.IsZero(m.Originalto) { // not required
		return nil
	}

	if m.Originalto != nil {
		if err := m.Originalto.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("originalto")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("originalto")
			}
			return err
		}
	}

	return nil
}

var frontendBaseTypeSocketStatsPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		frontendBaseTypeSocketStatsPropEnum = append(frontendBaseTypeSocketStatsPropEnum, v)
	}
}

const (

	// FrontendBaseSocketStatsEnabled captures enum value "enabled"
	FrontendBaseSocketStatsEnabled string = "enabled"

	// FrontendBaseSocketStatsDisabled captures enum value "disabled"
	FrontendBaseSocketStatsDisabled string = "disabled"
)

// prop value enum
func (m *FrontendBase) validateSocketStatsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, frontendBaseTypeSocketStatsPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FrontendBase) validateSocketStats(formats strfmt.Registry) error {
	if swag.IsZero(m.SocketStats) { // not required
		return nil
	}

	// value enum
	if err := m.validateSocketStatsEnum("socket_stats", "body", m.SocketStats); err != nil {
		return err
	}

	return nil
}

var frontendBaseTypeSpliceAutoPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		frontendBaseTypeSpliceAutoPropEnum = append(frontendBaseTypeSpliceAutoPropEnum, v)
	}
}

const (

	// FrontendBaseSpliceAutoEnabled captures enum value "enabled"
	FrontendBaseSpliceAutoEnabled string = "enabled"

	// FrontendBaseSpliceAutoDisabled captures enum value "disabled"
	FrontendBaseSpliceAutoDisabled string = "disabled"
)

// prop value enum
func (m *FrontendBase) validateSpliceAutoEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, frontendBaseTypeSpliceAutoPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FrontendBase) validateSpliceAuto(formats strfmt.Registry) error {
	if swag.IsZero(m.SpliceAuto) { // not required
		return nil
	}

	// value enum
	if err := m.validateSpliceAutoEnum("splice_auto", "body", m.SpliceAuto); err != nil {
		return err
	}

	return nil
}

var frontendBaseTypeSpliceRequestPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		frontendBaseTypeSpliceRequestPropEnum = append(frontendBaseTypeSpliceRequestPropEnum, v)
	}
}

const (

	// FrontendBaseSpliceRequestEnabled captures enum value "enabled"
	FrontendBaseSpliceRequestEnabled string = "enabled"

	// FrontendBaseSpliceRequestDisabled captures enum value "disabled"
	FrontendBaseSpliceRequestDisabled string = "disabled"
)

// prop value enum
func (m *FrontendBase) validateSpliceRequestEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, frontendBaseTypeSpliceRequestPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FrontendBase) validateSpliceRequest(formats strfmt.Registry) error {
	if swag.IsZero(m.SpliceRequest) { // not required
		return nil
	}

	// value enum
	if err := m.validateSpliceRequestEnum("splice_request", "body", m.SpliceRequest); err != nil {
		return err
	}

	return nil
}

var frontendBaseTypeSpliceResponsePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		frontendBaseTypeSpliceResponsePropEnum = append(frontendBaseTypeSpliceResponsePropEnum, v)
	}
}

const (

	// FrontendBaseSpliceResponseEnabled captures enum value "enabled"
	FrontendBaseSpliceResponseEnabled string = "enabled"

	// FrontendBaseSpliceResponseDisabled captures enum value "disabled"
	FrontendBaseSpliceResponseDisabled string = "disabled"
)

// prop value enum
func (m *FrontendBase) validateSpliceResponseEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, frontendBaseTypeSpliceResponsePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FrontendBase) validateSpliceResponse(formats strfmt.Registry) error {
	if swag.IsZero(m.SpliceResponse) { // not required
		return nil
	}

	// value enum
	if err := m.validateSpliceResponseEnum("splice_response", "body", m.SpliceResponse); err != nil {
		return err
	}

	return nil
}

func (m *FrontendBase) validateStatsOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.StatsOptions) { // not required
		return nil
	}

	if m.StatsOptions != nil {
		if err := m.StatsOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("stats_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("stats_options")
			}
			return err
		}
	}

	return nil
}

func (m *FrontendBase) validateStickTable(formats strfmt.Registry) error {
	if swag.IsZero(m.StickTable) { // not required
		return nil
	}

	if m.StickTable != nil {
		if err := m.StickTable.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("stick_table")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("stick_table")
			}
			return err
		}
	}

	return nil
}

func (m *FrontendBase) validateTarpitTimeout(formats strfmt.Registry) error {
	if swag.IsZero(m.TarpitTimeout) { // not required
		return nil
	}

	if err := validate.MinimumInt("tarpit_timeout", "body", *m.TarpitTimeout, 0, false); err != nil {
		return err
	}

	return nil
}

var frontendBaseTypeTCPSmartAcceptPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		frontendBaseTypeTCPSmartAcceptPropEnum = append(frontendBaseTypeTCPSmartAcceptPropEnum, v)
	}
}

const (

	// FrontendBaseTCPSmartAcceptEnabled captures enum value "enabled"
	FrontendBaseTCPSmartAcceptEnabled string = "enabled"

	// FrontendBaseTCPSmartAcceptDisabled captures enum value "disabled"
	FrontendBaseTCPSmartAcceptDisabled string = "disabled"
)

// prop value enum
func (m *FrontendBase) validateTCPSmartAcceptEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, frontendBaseTypeTCPSmartAcceptPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FrontendBase) validateTCPSmartAccept(formats strfmt.Registry) error {
	if swag.IsZero(m.TCPSmartAccept) { // not required
		return nil
	}

	// value enum
	if err := m.validateTCPSmartAcceptEnum("tcp_smart_accept", "body", m.TCPSmartAccept); err != nil {
		return err
	}

	return nil
}

var frontendBaseTypeTcpkaPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		frontendBaseTypeTcpkaPropEnum = append(frontendBaseTypeTcpkaPropEnum, v)
	}
}

const (

	// FrontendBaseTcpkaEnabled captures enum value "enabled"
	FrontendBaseTcpkaEnabled string = "enabled"

	// FrontendBaseTcpkaDisabled captures enum value "disabled"
	FrontendBaseTcpkaDisabled string = "disabled"
)

// prop value enum
func (m *FrontendBase) validateTcpkaEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, frontendBaseTypeTcpkaPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FrontendBase) validateTcpka(formats strfmt.Registry) error {
	if swag.IsZero(m.Tcpka) { // not required
		return nil
	}

	// value enum
	if err := m.validateTcpkaEnum("tcpka", "body", m.Tcpka); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this frontend base based on the context it is used
func (m *FrontendBase) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateErrorFiles(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateErrorFilesFromHTTPErrors(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCompression(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEmailAlert(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateErrorloc302(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateErrorloc303(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateForwardfor(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMonitorFail(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMonitorURI(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOriginalto(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatsOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStickTable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FrontendBase) contextValidateErrorFiles(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ErrorFiles); i++ {

		if m.ErrorFiles[i] != nil {

			if swag.IsZero(m.ErrorFiles[i]) { // not required
				return nil
			}

			if err := m.ErrorFiles[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("error_files" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("error_files" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *FrontendBase) contextValidateErrorFilesFromHTTPErrors(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ErrorFilesFromHTTPErrors); i++ {

		if m.ErrorFilesFromHTTPErrors[i] != nil {

			if swag.IsZero(m.ErrorFilesFromHTTPErrors[i]) { // not required
				return nil
			}

			if err := m.ErrorFilesFromHTTPErrors[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("errorfiles_from_http_errors" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("errorfiles_from_http_errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *FrontendBase) contextValidateCompression(ctx context.Context, formats strfmt.Registry) error {

	if m.Compression != nil {

		if swag.IsZero(m.Compression) { // not required
			return nil
		}

		if err := m.Compression.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("compression")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("compression")
			}
			return err
		}
	}

	return nil
}

func (m *FrontendBase) contextValidateEmailAlert(ctx context.Context, formats strfmt.Registry) error {

	if m.EmailAlert != nil {

		if swag.IsZero(m.EmailAlert) { // not required
			return nil
		}

		if err := m.EmailAlert.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("email_alert")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("email_alert")
			}
			return err
		}
	}

	return nil
}

func (m *FrontendBase) contextValidateErrorloc302(ctx context.Context, formats strfmt.Registry) error {

	if m.Errorloc302 != nil {

		if swag.IsZero(m.Errorloc302) { // not required
			return nil
		}

		if err := m.Errorloc302.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("errorloc302")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("errorloc302")
			}
			return err
		}
	}

	return nil
}

func (m *FrontendBase) contextValidateErrorloc303(ctx context.Context, formats strfmt.Registry) error {

	if m.Errorloc303 != nil {

		if swag.IsZero(m.Errorloc303) { // not required
			return nil
		}

		if err := m.Errorloc303.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("errorloc303")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("errorloc303")
			}
			return err
		}
	}

	return nil
}

func (m *FrontendBase) contextValidateForwardfor(ctx context.Context, formats strfmt.Registry) error {

	if m.Forwardfor != nil {

		if swag.IsZero(m.Forwardfor) { // not required
			return nil
		}

		if err := m.Forwardfor.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("forwardfor")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("forwardfor")
			}
			return err
		}
	}

	return nil
}

func (m *FrontendBase) contextValidateMonitorFail(ctx context.Context, formats strfmt.Registry) error {

	if m.MonitorFail != nil {

		if swag.IsZero(m.MonitorFail) { // not required
			return nil
		}

		if err := m.MonitorFail.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("monitor_fail")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("monitor_fail")
			}
			return err
		}
	}

	return nil
}

func (m *FrontendBase) contextValidateMonitorURI(ctx context.Context, formats strfmt.Registry) error {

	if swag.IsZero(m.MonitorURI) { // not required
		return nil
	}

	if err := m.MonitorURI.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("monitor_uri")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("monitor_uri")
		}
		return err
	}

	return nil
}

func (m *FrontendBase) contextValidateOriginalto(ctx context.Context, formats strfmt.Registry) error {

	if m.Originalto != nil {

		if swag.IsZero(m.Originalto) { // not required
			return nil
		}

		if err := m.Originalto.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("originalto")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("originalto")
			}
			return err
		}
	}

	return nil
}

func (m *FrontendBase) contextValidateStatsOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.StatsOptions != nil {

		if swag.IsZero(m.StatsOptions) { // not required
			return nil
		}

		if err := m.StatsOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("stats_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("stats_options")
			}
			return err
		}
	}

	return nil
}

func (m *FrontendBase) contextValidateStickTable(ctx context.Context, formats strfmt.Registry) error {

	if m.StickTable != nil {

		if swag.IsZero(m.StickTable) { // not required
			return nil
		}

		if err := m.StickTable.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("stick_table")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("stick_table")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FrontendBase) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FrontendBase) UnmarshalBinary(b []byte) error {
	var res FrontendBase
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
