/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

public class DetailsViewDialog
extends BaseDialog {
    protected Button detailsButton;
    private Control detailsContents = null;

    public DetailsViewDialog(Shell parentShell, String title, @Nullable DBPImage icon) {
        super(parentShell, title, icon);
    }

    protected void buttonPressed(int id) {
        if (id == 13) {
            this.toggleDetailsArea();
        } else {
            super.buttonPressed(id);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createDetailsButton(parent);
    }

    protected void createDetailsButton(Composite parent) {
        this.detailsButton = this.createButton(parent, 13, this.getDetailsLabel(true), false);
    }

    protected String getDetailsLabel(boolean show) {
        return show ? IDialogConstants.SHOW_DETAILS_LABEL : IDialogConstants.HIDE_DETAILS_LABEL;
    }

    @Override
    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        this.createMessageArea(composite);
        GridData childData = new GridData(1808);
        childData.horizontalSpan = 2;
        childData.grabExcessVerticalSpace = false;
        composite.setLayoutData((Object)childData);
        composite.setFont(parent.getFont());
        return composite;
    }

    private void toggleDetailsArea() {
        boolean opened = false;
        Point windowSize = this.getShell().getSize();
        if (this.detailsContents != null) {
            this.detailsContents.dispose();
            this.detailsContents = null;
            this.detailsButton.setText(this.getDetailsLabel(true));
            opened = false;
        } else {
            this.detailsContents = this.createDetailsContents((Composite)this.getContents());
            this.detailsButton.setText(this.getDetailsLabel(false));
            this.getContents().getShell().layout();
            opened = true;
        }
        Point newSize = this.getShell().computeSize(-1, -1);
        int diffY = newSize.y - windowSize.y;
        if (opened && diffY > 0 || !opened && diffY < 0) {
            this.getShell().setSize(new Point(windowSize.x, windowSize.y + diffY));
        }
    }

    protected final void showDetailsArea() {
        Control control;
        if (this.detailsContents == null && (control = this.getContents()) != null && !control.isDisposed()) {
            this.toggleDetailsArea();
        }
    }

    @Override
    protected boolean isResizable() {
        return true;
    }

    protected void createMessageArea(Composite composite) {
    }

    protected Control createDetailsContents(Composite composite) {
        return null;
    }
}

