/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.index;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.NullableFunction;
import com.intellij.util.indexing.AdditionalIndexedRootsScope;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import com.intellij.xml.index.ResourceRelevance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexedRelevantResource<K, V extends Comparable>
implements Comparable<IndexedRelevantResource<K, V>> {
    private final VirtualFile myFile;
    private final K myKey;
    private final V myValue;
    private final ResourceRelevance myRelevance;

    public static <K, V extends Comparable> List<IndexedRelevantResource<K, V>> getResources(ID<K, V> indexId, K key, @Nullable Module module, @NotNull Project project2, @Nullable GlobalSearchScope additionalScope) {
        if (project2 == null) {
            IndexedRelevantResource.$$$reportNull$$$0(0);
        }
        if (project2.isDefault()) {
            return Collections.emptyList();
        }
        ArrayList resources = new ArrayList();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        FileBasedIndex.getInstance().processValues(indexId, key, null, (file, value) -> {
            ResourceRelevance relevance = ResourceRelevance.getRelevance(file, module, fileIndex, additionalScope);
            resources.add(new IndexedRelevantResource<Object, Comparable>(file, key, (Comparable)value, relevance));
            return true;
        }, (GlobalSearchScope)new AdditionalIndexedRootsScope(GlobalSearchScope.allScope((Project)project2)));
        return resources;
    }

    public static <K, V extends Comparable> List<IndexedRelevantResource<K, V>> getAllResources(ID<K, V> indexId, @Nullable Module module, @NotNull Project project2, @Nullable NullableFunction<? super List<IndexedRelevantResource<K, V>>, ? extends IndexedRelevantResource<K, V>> chooser) {
        if (project2 == null) {
            IndexedRelevantResource.$$$reportNull$$$0(1);
        }
        ArrayList<IndexedRelevantResource<K, V>> all = new ArrayList<IndexedRelevantResource<K, V>>();
        Collection allKeys = FileBasedIndex.getInstance().getAllKeys(indexId, project2);
        for (Object key : allKeys) {
            List<IndexedRelevantResource<K, V>> resources = IndexedRelevantResource.getResources(indexId, key, module, project2, null);
            if (resources.isEmpty()) continue;
            if (chooser == null) {
                all.add(resources.get(0));
                continue;
            }
            IndexedRelevantResource resource = (IndexedRelevantResource)chooser.fun(resources);
            if (resource == null) continue;
            all.add(resource);
        }
        return all;
    }

    public IndexedRelevantResource(VirtualFile file, K key, V value, ResourceRelevance relevance) {
        this.myFile = file;
        this.myKey = key;
        this.myValue = value;
        this.myRelevance = relevance;
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    public V getValue() {
        return this.myValue;
    }

    public ResourceRelevance getRelevance() {
        return this.myRelevance;
    }

    @Override
    public int compareTo(IndexedRelevantResource<K, V> o) {
        int i = this.myRelevance.compareTo(o.getRelevance());
        return i == 0 ? this.myValue.compareTo(o.getValue()) : i;
    }

    public K getKey() {
        return this.myKey;
    }

    public String toString() {
        return "IndexedRelevantResource{myRelevance=" + String.valueOf((Object)this.myRelevance) + ", myKey=" + String.valueOf(this.myKey) + ", myValue=" + String.valueOf(this.myValue) + ", myFile=" + String.valueOf(this.myFile) + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/xml/index/IndexedRelevantResource";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getResources";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllResources";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

