/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.output;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.output.TextAttributesProvider;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\n\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/HighlightingInfo;", "", "startOffset", "", "endOffset", "textAttributesProvider", "Lorg/jetbrains/plugins/terminal/block/output/TextAttributesProvider;", "<init>", "(IILorg/jetbrains/plugins/terminal/block/output/TextAttributesProvider;)V", "getStartOffset", "()I", "getEndOffset", "getTextAttributesProvider", "()Lorg/jetbrains/plugins/terminal/block/output/TextAttributesProvider;", "length", "getLength", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.terminal"})
@ApiStatus.Internal
public final class HighlightingInfo {
    private final int startOffset;
    private final int endOffset;
    @NotNull
    private final TextAttributesProvider textAttributesProvider;

    public HighlightingInfo(int startOffset, int endOffset, @NotNull TextAttributesProvider textAttributesProvider) {
        Intrinsics.checkNotNullParameter((Object)textAttributesProvider, (String)"textAttributesProvider");
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.textAttributesProvider = textAttributesProvider;
        if (!(this.startOffset <= this.endOffset)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    public final int getStartOffset() {
        return this.startOffset;
    }

    public final int getEndOffset() {
        return this.endOffset;
    }

    @NotNull
    public final TextAttributesProvider getTextAttributesProvider() {
        return this.textAttributesProvider;
    }

    public final int getLength() {
        return this.endOffset - this.startOffset;
    }

    public final int component1() {
        return this.startOffset;
    }

    public final int component2() {
        return this.endOffset;
    }

    @NotNull
    public final TextAttributesProvider component3() {
        return this.textAttributesProvider;
    }

    @NotNull
    public final HighlightingInfo copy(int startOffset, int endOffset, @NotNull TextAttributesProvider textAttributesProvider) {
        Intrinsics.checkNotNullParameter((Object)textAttributesProvider, (String)"textAttributesProvider");
        return new HighlightingInfo(startOffset, endOffset, textAttributesProvider);
    }

    public static /* synthetic */ HighlightingInfo copy$default(HighlightingInfo highlightingInfo, int n, int n2, TextAttributesProvider textAttributesProvider, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = highlightingInfo.startOffset;
        }
        if ((n3 & 2) != 0) {
            n2 = highlightingInfo.endOffset;
        }
        if ((n3 & 4) != 0) {
            textAttributesProvider = highlightingInfo.textAttributesProvider;
        }
        return highlightingInfo.copy(n, n2, textAttributesProvider);
    }

    @NotNull
    public String toString() {
        return "HighlightingInfo(startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + ", textAttributesProvider=" + this.textAttributesProvider + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.startOffset);
        result = result * 31 + Integer.hashCode(this.endOffset);
        result = result * 31 + this.textAttributesProvider.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HighlightingInfo)) {
            return false;
        }
        HighlightingInfo highlightingInfo = (HighlightingInfo)other;
        if (this.startOffset != highlightingInfo.startOffset) {
            return false;
        }
        if (this.endOffset != highlightingInfo.endOffset) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.textAttributesProvider, (Object)highlightingInfo.textAttributesProvider);
    }
}

