/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.action;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.terminal.frontend.TerminalInput;
import com.intellij.terminal.frontend.action.TerminalFrontendDataContextUtils;
import com.jediterm.terminal.TerminalOutputStream;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.SimpleTerminalController;
import org.jetbrains.plugins.terminal.block.TerminalFocusModel;
import org.jetbrains.plugins.terminal.block.TerminalPromotedDumbAwareAction;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputController;
import org.jetbrains.plugins.terminal.block.output.TerminalSelectionController;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptController;
import org.jetbrains.plugins.terminal.block.session.BlockTerminalSession;
import org.jetbrains.plugins.terminal.block.session.TerminalModel;
import org.jetbrains.plugins.terminal.block.util.TerminalDataContextUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/terminal/frontend/action/TerminalPasteAction;", "Lorg/jetbrains/plugins/terminal/block/TerminalPromotedDumbAwareAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "pasteIntoPrompt", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "pasteIntoTerminalSession", "doPasteIntoTerminalSession", "output", "Lcom/jediterm/terminal/TerminalOutputStream;", "pasteIntoInput", "input", "Lcom/intellij/terminal/frontend/TerminalInput;", "getClipboardText", "", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.terminal.frontend"})
@SourceDebugExtension(value={"SMAP\nTerminalPasteAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalPasteAction.kt\ncom/intellij/terminal/frontend/action/TerminalPasteAction\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,112:1\n25#2:113\n*S KotlinDebug\n*F\n+ 1 TerminalPasteAction.kt\ncom/intellij/terminal/frontend/action/TerminalPasteAction\n*L\n105#1:113\n*E\n"})
public final class TerminalPasteAction
extends TerminalPromotedDumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor = TerminalDataContextUtils.INSTANCE.getEditor(e);
        EditorEx editorEx = editor instanceof EditorEx ? (EditorEx)editor : null;
        if (editorEx == null) {
            return;
        }
        EditorEx editor2 = editorEx;
        TerminalInput input = TerminalFrontendDataContextUtils.INSTANCE.getTerminalInput(e);
        if (TerminalDataContextUtils.INSTANCE.isPromptEditor((Editor)editor2)) {
            this.pasteIntoPrompt(e, e.getDataContext());
        } else if (TerminalDataContextUtils.INSTANCE.isAlternateBufferEditor((Editor)editor2)) {
            this.pasteIntoTerminalSession(e);
        } else if (TerminalDataContextUtils.INSTANCE.isOutputEditor((Editor)editor2)) {
            Object object = TerminalDataContextUtils.INSTANCE.getTerminalSession(e);
            boolean bl = object != null && (object = ((BlockTerminalSession)object).getModel()) != null ? ((TerminalModel)object).isCommandRunning() : false;
            if (bl) {
                this.pasteIntoTerminalSession(e);
            } else {
                this.pasteIntoPrompt(e, null);
            }
        } else if (input != null) {
            this.pasteIntoInput(input);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor = TerminalDataContextUtils.INSTANCE.getEditor(e);
        e.getPresentation().setEnabledAndVisible(editor != null && (TerminalDataContextUtils.INSTANCE.isPromptEditor(editor) || TerminalDataContextUtils.INSTANCE.isOutputEditor(editor) || TerminalDataContextUtils.INSTANCE.isAlternateBufferEditor(editor) || TerminalDataContextUtils.INSTANCE.isOutputModelEditor(editor) || TerminalDataContextUtils.INSTANCE.isAlternateBufferModelEditor(editor)));
    }

    private final void pasteIntoPrompt(AnActionEvent e, DataContext dataContext) {
        TerminalPromptController terminalPromptController = TerminalDataContextUtils.INSTANCE.getPromptController(e);
        if (terminalPromptController == null) {
            return;
        }
        TerminalPromptController promptController = terminalPromptController;
        TerminalFocusModel terminalFocusModel = TerminalDataContextUtils.INSTANCE.getTerminalFocusModel(e);
        if (terminalFocusModel != null) {
            terminalFocusModel.focusPrompt();
        }
        promptController.performPaste(dataContext);
    }

    private final void pasteIntoTerminalSession(AnActionEvent e) {
        BlockTerminalSession blockTerminalSession = TerminalDataContextUtils.INSTANCE.getTerminalSession(e);
        if (blockTerminalSession == null) {
            throw new IllegalStateException("No TerminalSession in the data context".toString());
        }
        BlockTerminalSession session2 = blockTerminalSession;
        TerminalSelectionController terminalSelectionController = TerminalDataContextUtils.INSTANCE.getSelectionController(e);
        if (terminalSelectionController != null) {
            terminalSelectionController.clearSelection();
        }
        SimpleTerminalController simpleTerminalController = TerminalDataContextUtils.INSTANCE.getSimpleTerminalController(e);
        if (simpleTerminalController != null) {
            simpleTerminalController.clearTextSelection();
        }
        TerminalOutputController terminalOutputController = TerminalDataContextUtils.INSTANCE.getOutputController(e);
        if (terminalOutputController != null) {
            terminalOutputController.scrollToBottom();
        }
        this.doPasteIntoTerminalSession(session2.getTerminalOutputStream());
    }

    private final void doPasteIntoTerminalSession(TerminalOutputStream output) {
        String string = this.getClipboardText();
        if (string == null) {
            return;
        }
        String text = string;
        if (((CharSequence)text).length() > 0) {
            output.sendString(text, false);
        }
    }

    private final void pasteIntoInput(TerminalInput input) {
        String string = this.getClipboardText();
        if (string == null) {
            return;
        }
        String text = string;
        if (((CharSequence)text).length() > 0) {
            if (!SystemInfoRt.isWindows) {
                text = StringsKt.replace$default((String)text, (String)"\r\n", (String)"\n", (boolean)false, (int)4, null);
            }
            text = StringsKt.replace$default((String)text, (String)"\n", (String)"\r", (boolean)false, (int)4, null);
            input.sendBracketedString(text);
        }
    }

    private final String getClipboardText() {
        String string;
        Transferable transferable = CopyPasteManager.getInstance().getContents();
        if (transferable == null) {
            return null;
        }
        Transferable content = transferable;
        try {
            Object object = content.getTransferData(DataFlavor.stringFlavor);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            string = (String)object;
        }
        catch (Throwable t) {
            TerminalPasteAction $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(TerminalPasteAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Failed to get text from clipboard", t);
            return null;
        }
        String text = string;
        return text;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }
}

