/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.jvm.java;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.ui.configuration.SdkLookup;
import com.intellij.openapi.roots.ui.configuration.SdkLookupBuilder;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.PlatformUtils;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.jvm.java.QodanaConfigJdkServiceKt;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaConfig;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaException;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0086@\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0019\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/qodana/jvm/java/QodanaConfigJdkService;", "", "<init>", "()V", "deferredSdk", "Lkotlinx/coroutines/CompletableDeferred;", "Lcom/intellij/openapi/projectRoots/Sdk;", "getDeferredSdk", "()Lkotlinx/coroutines/CompletableDeferred;", "configureJdk", "", "config", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;", "getJdk", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setupSdk", "jdkName", "", "intellij.qodana.jvm.java"})
public final class QodanaConfigJdkService {
    @NotNull
    private final CompletableDeferred<Sdk> deferredSdk = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);

    public QodanaConfigJdkService() {
        if (!PlatformUtils.isQodana()) {
            this.deferredSdk.complete(null);
        }
    }

    @NotNull
    public final CompletableDeferred<Sdk> getDeferredSdk() {
        return this.deferredSdk;
    }

    public final void configureJdk(@NotNull QodanaConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (this.deferredSdk.isCompleted()) {
            return;
        }
        String jdkName = config.getJvm().getProjectJDK();
        CharSequence charSequence = jdkName;
        if (charSequence == null || charSequence.length() == 0) {
            this.deferredSdk.complete(null);
            return;
        }
        this.setupSdk(jdkName);
    }

    @Nullable
    public final Object getJdk(@NotNull Continuation<? super Sdk> $completion) {
        return TimeoutKt.withTimeout-KLykuaI((long)QodanaConfigJdkServiceKt.access$getQODANA_JDK_TIMEOUT$p(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Sdk>, Object>(this, null){
            int label;
            final /* synthetic */ QodanaConfigJdkService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.getDeferredSdk().await((Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Sdk> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private final void setupSdk(String jdkName) {
        QodanaConfigJdkServiceKt.access$getLOG$p().info("Setting up JDK '" + jdkName + "' from Qodana config");
        SdkLookupBuilder sdkLookupBuilder = SdkLookup.Companion.newLookupBuilder().withSdkName(jdkName);
        JavaSdk javaSdk = JavaSdk.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)javaSdk, (String)"getInstance(...)");
        sdkLookupBuilder.withSdkType((SdkType)javaSdk).onSdkResolved(arg_0 -> QodanaConfigJdkService.setupSdk$lambda$0(this, jdkName, arg_0)).executeLookup();
    }

    private static final Unit setupSdk$lambda$0(QodanaConfigJdkService this$0, String $jdkName, Sdk sdk) {
        if (sdk == null) {
            this$0.deferredSdk.completeExceptionally((Throwable)new QodanaException("Can't find locally or download required in config JDK '" + $jdkName + "'. Check that you specified supported version or mounted JDK compatible with " + SystemInfo.OS_NAME + "/" + SystemInfo.OS_ARCH));
            QodanaConfigJdkServiceKt.access$getLOG$p().info("Setting up JDK '" + $jdkName + "' from Qodana config completed with exception");
        } else {
            this$0.deferredSdk.complete((Object)sdk);
            QodanaConfigJdkServiceKt.access$getLOG$p().info("Setting up JDK '" + $jdkName + "' from Qodana config completed");
        }
        return Unit.INSTANCE;
    }
}

