/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.gfm.users.internal;

import com.vladsch.flexmark.ext.gfm.users.GfmUser;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.InlineParserExtension;
import com.vladsch.flexmark.parser.InlineParserExtensionFactory;
import com.vladsch.flexmark.parser.LightInlineParser;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GfmUsersInlineParserExtension
implements InlineParserExtension {
    public static final Pattern GITHUB_USER = Pattern.compile("^(@)([a-z\\d](?:[a-z\\d]|-(?=[a-z\\d])){0,38})\\b", 2);

    public GfmUsersInlineParserExtension(LightInlineParser inlineParser) {
    }

    @Override
    public void finalizeDocument(@NotNull InlineParser inlineParser) {
    }

    @Override
    public void finalizeBlock(@NotNull InlineParser inlineParser) {
    }

    @Override
    public boolean parse(@NotNull LightInlineParser inlineParser) {
        BasedSequence[] matches;
        char c;
        boolean isPossible;
        int index = inlineParser.getIndex();
        boolean bl = isPossible = index == 0;
        if (!isPossible && !Character.isUnicodeIdentifierPart(c = inlineParser.getInput().charAt(index - 1)) && c != '-' && c != '.') {
            isPossible = true;
        }
        if (isPossible && (matches = inlineParser.matchWithGroups(GITHUB_USER)) != null) {
            inlineParser.flushTextNode();
            BasedSequence openMarker = matches[1];
            BasedSequence text2 = matches[2];
            GfmUser gitHubIssue = new GfmUser(openMarker, text2);
            inlineParser.getBlock().appendChild(gitHubIssue);
            return true;
        }
        return false;
    }

    public static class Factory
    implements InlineParserExtensionFactory {
        @Override
        @Nullable
        public Set<Class<?>> getAfterDependents() {
            return null;
        }

        @Override
        @NotNull
        public CharSequence getCharacters() {
            return "@";
        }

        @Override
        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            return null;
        }

        @Override
        @NotNull
        public InlineParserExtension apply(@NotNull LightInlineParser lightInlineParser) {
            return new GfmUsersInlineParserExtension(lightInlineParser);
        }

        @Override
        public boolean affectsGlobalScope() {
            return false;
        }
    }
}

