/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.ide.model.highlighterRegistration.IdeaTextAttributesKey;
import com.jetbrains.ide.model.highlighterRegistration.TextAttributesKeyModel;
import com.jetbrains.rd.ide.editor.markup.UtilKt;
import com.jetbrains.rd.ide.model.HighlighterElement;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdclient.daemon.FrontendHighlighterSuppressionHandler;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapter;
import com.jetbrains.rdclient.daemon.FrontendMarkupSuppressor;
import com.jetbrains.rdclient.daemon.HighlighterRangeRepairer;
import com.jetbrains.rdclient.daemon.MarkupSuppressionKind;
import com.jetbrains.rdclient.daemon.RecyclingHighlighterStorage;
import com.jetbrains.rdclient.daemon.suppressors.ProtocolSuppressableMarkupModel;
import com.jetbrains.rdclient.daemon.util.HighlightersUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 <2\u00020\u0001:\u0002;<B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\u0016\u0010\u001d\u001a\u00020\u001b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002J\u0010\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H\u0002J\u0016\u0010$\u001a\u00020\u001b2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002J\u001a\u0010&\u001a\u0004\u0018\u00010#2\u0006\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020\u0015H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020 H\u0002J\u0016\u0010,\u001a\u00020\u001b2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u001fH\u0002J\b\u0010/\u001a\u00020\u001bH\u0002J\u0016\u00100\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00101\u001a\u000202J\u0016\u00103\u001a\u00020\u001b2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u001b05H\u0002J\u001d\u00106\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00107\u001a\u000208H\u0000\u00a2\u0006\u0002\b9J\b\u0010:\u001a\u000202H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/jetbrains/rdclient/daemon/FrontendMarkupContributor;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "markupAdapter", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapter;", "highlighterRepairer", "Lcom/jetbrains/rdclient/daemon/HighlighterRangeRepairer;", "storage", "Lcom/jetbrains/rdclient/daemon/RecyclingHighlighterStorage;", "suppressor", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupSuppressor;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapter;Lcom/jetbrains/rdclient/daemon/HighlighterRangeRepairer;Lcom/jetbrains/rdclient/daemon/RecyclingHighlighterStorage;Lcom/jetbrains/rdclient/daemon/FrontendMarkupSuppressor;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getMarkupAdapter", "()Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapter;", "getStorage", "()Lcom/jetbrains/rdclient/daemon/RecyclingHighlighterStorage;", "value", "", "isUpdating", "()Z", "mergingUpdateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "queueUpdateIfNeed", "", "flushHighlighters", "highlightersAdded", "added", "", "Lcom/jetbrains/rd/ide/model/HighlighterElement;", "isReplaced", "highlighterModel", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "highlightersUpdated", "updated", "repair", "model", "trackInvalid", "recycle", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "element", "highlightersRemoved", "removed", "", "removeAllHighlighters", "suppress", "suppressionKind", "Lcom/jetbrains/rdclient/daemon/MarkupSuppressionKind;", "update", "block", "Lkotlin/Function0;", "bind", "protocolMarkup", "Lcom/jetbrains/rdclient/daemon/suppressors/ProtocolSuppressableMarkupModel;", "bind$intellij_rd_client", "isSuppressed", "MergingUpdateTask", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendMarkupContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendMarkupContributor.kt\ncom/jetbrains/rdclient/daemon/FrontendMarkupContributor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,315:1\n1755#2,3:316\n1557#2:352\n1628#2,3:353\n1#3:319\n69#4,4:320\n69#4,4:324\n69#4,4:328\n69#4,4:332\n69#4,4:336\n69#4,4:340\n69#4,4:346\n69#4,2:350\n72#4:356\n69#4,4:357\n69#4,4:361\n69#4,4:365\n69#4,4:369\n15#4:373\n12567#5,2:344\n*S KotlinDebug\n*F\n+ 1 FrontendMarkupContributor.kt\ncom/jetbrains/rdclient/daemon/FrontendMarkupContributor\n*L\n147#1:316,3\n256#1:352\n256#1:353,3\n64#1:320,4\n81#1:324,4\n93#1:328,4\n98#1:332,4\n103#1:336,4\n221#1:340,4\n248#1:346,4\n252#1:350,2\n252#1:356\n266#1:357,4\n270#1:361,4\n274#1:365,4\n278#1:369,4\n288#1:373\n222#1:344,2\n*E\n"})
public final class FrontendMarkupContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final FrontendMarkupAdapter markupAdapter;
    @NotNull
    private final HighlighterRangeRepairer highlighterRepairer;
    @NotNull
    private final RecyclingHighlighterStorage storage;
    @NotNull
    private final FrontendMarkupSuppressor suppressor;
    private boolean isUpdating;
    @NotNull
    private final MergingUpdateQueue mergingUpdateQueue;
    @NotNull
    private static final Logger logger;

    public FrontendMarkupContributor(@NotNull Lifetime lifetime, @NotNull FrontendMarkupAdapter markupAdapter, @NotNull HighlighterRangeRepairer highlighterRepairer, @NotNull RecyclingHighlighterStorage storage, @NotNull FrontendMarkupSuppressor suppressor) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)markupAdapter, (String)"markupAdapter");
        Intrinsics.checkNotNullParameter((Object)highlighterRepairer, (String)"highlighterRepairer");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)suppressor, (String)"suppressor");
        this.lifetime = lifetime;
        this.markupAdapter = markupAdapter;
        this.highlighterRepairer = highlighterRepairer;
        this.storage = storage;
        this.suppressor = suppressor;
        this.mergingUpdateQueue = new MergingUpdateQueue("FrontendMarkupContributor.mergingUpdateQueue", 50, true, null, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)this.lifetime, null, (int)1, null), null, false, 96, null);
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final FrontendMarkupAdapter getMarkupAdapter() {
        return this.markupAdapter;
    }

    @NotNull
    public final RecyclingHighlighterStorage getStorage() {
        return this.storage;
    }

    public final boolean isUpdating() {
        return this.isUpdating;
    }

    private final void queueUpdateIfNeed() {
        if (this.suppressor.isSuppressed$intellij_rd_client() == MarkupSuppressionKind.NONE) {
            ModalityState modalityState = ModalityState.current();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"current(...)");
            this.mergingUpdateQueue.queue((Update)new MergingUpdateTask(modalityState));
        }
    }

    private final void flushHighlighters() {
        this.update((Function0<Unit>)((Function0)() -> FrontendMarkupContributor.flushHighlighters$lambda$5(this)));
    }

    private final void highlightersAdded(List<HighlighterElement> added) {
        this.update((Function0<Unit>)((Function0)() -> FrontendMarkupContributor.highlightersAdded$lambda$8(added, this)));
    }

    private final boolean isReplaced(HighlighterModel highlighterModel) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = FrontendHighlighterSuppressionHandler.Companion.getEP_NAME().getExtensionList();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FrontendHighlighterSuppressionHandler it = (FrontendHighlighterSuppressionHandler)element$iv;
                    boolean bl2 = false;
                    if (!it.shouldSuppress(highlighterModel, this.markupAdapter.getDocument())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final void highlightersUpdated(List<HighlighterElement> updated) {
        this.update((Function0<Unit>)((Function0)() -> FrontendMarkupContributor.highlightersUpdated$lambda$10(updated, this)));
    }

    private final HighlighterModel repair(HighlighterModel model, boolean trackInvalid) {
        HighlighterModel highlighterModel = this.highlighterRepairer.repair(model);
        if (highlighterModel != null) {
            HighlighterModel it = highlighterModel;
            boolean bl = false;
            return it;
        }
        if (trackInvalid) {
            this.storage.addInvalidHighlighter(model);
        }
        return null;
    }

    private final RangeHighlighterEx recycle(HighlighterElement element) {
        RangeHighlighterEx recycledHighlighter = this.storage.recycle(element.getHighlighter());
        if (recycledHighlighter != null) {
            this.markupAdapter.updateHighlighter(recycledHighlighter, element);
        }
        return recycledHighlighter;
    }

    private final void highlightersRemoved(List<Long> removed) {
        this.update((Function0<Unit>)((Function0)() -> FrontendMarkupContributor.highlightersRemoved$lambda$12(removed, this)));
    }

    private final void removeAllHighlighters() {
        this.update((Function0<Unit>)((Function0)() -> FrontendMarkupContributor.removeAllHighlighters$lambda$15(this)));
    }

    public final void suppress(@NotNull Lifetime lifetime, @NotNull MarkupSuppressionKind suppressionKind) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)suppressionKind), (String)"suppressionKind");
        this.suppressor.suppress(lifetime, suppressionKind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void update(Function0<Unit> block) {
        try {
            this.isUpdating = true;
            block.invoke();
        }
        finally {
            this.isUpdating = false;
        }
    }

    public final void bind$intellij_rd_client(@NotNull Lifetime lifetime, @NotNull ProtocolSuppressableMarkupModel protocolMarkup) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)protocolMarkup, (String)"protocolMarkup");
        protocolMarkup.getHighlightersRemoved().advise(lifetime, arg_0 -> FrontendMarkupContributor.bind$lambda$17(this, arg_0));
        protocolMarkup.getHighlightersAdded().advise(lifetime, arg_0 -> FrontendMarkupContributor.bind$lambda$20(this, arg_0));
        protocolMarkup.getHighlightersUpdated().advise(lifetime, arg_0 -> FrontendMarkupContributor.bind$lambda$22(this, arg_0));
        protocolMarkup.getHighlightersCleared().advise(lifetime, arg_0 -> FrontendMarkupContributor.bind$lambda$24(this, arg_0));
        this.suppressor.released(lifetime, (Function1<? super Lifetime, Unit>)((Function1)arg_0 -> FrontendMarkupContributor.bind$lambda$26(this, arg_0)));
        lifetime.onTermination(() -> FrontendMarkupContributor.bind$lambda$28(this));
        protocolMarkup.bind(lifetime);
    }

    @TestOnly
    @NotNull
    public final MarkupSuppressionKind isSuppressed() {
        return this.suppressor.isSuppressed$intellij_rd_client();
    }

    private static final Unit flushHighlighters$lambda$5(FrontendMarkupContributor this$0) {
        List<RangeHighlighterEx> notDeleted;
        Logger $this$trace$iv;
        HighlighterModel repairedModel;
        List extensions;
        Logger logger;
        FrontendMarkupContributor.logger.debug("highlighter flush triggered!");
        Logger $this$trace$iv2 = FrontendMarkupContributor.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv2.isTraceEnabled()) {
            logger = $this$trace$iv2;
            boolean bl = false;
            logger.trace("highlighters in document:" + this$0.markupAdapter.getAllHighlighters().length);
        }
        List<Map.Entry<RangeHighlighterEx, HighlighterElement>> notUpdated = this$0.storage.flushNotUpdated();
        if (!((Collection)notUpdated).isEmpty()) {
            for (Map.Entry<RangeHighlighterEx, HighlighterElement> bl : notUpdated) {
                RangeHighlighterEx highlighter = bl.getKey();
                HighlighterElement element = bl.getValue();
                HighlighterModel model = element.component1();
                extensions = element.component2();
                repairedModel = this$0.repair(model, false);
                if (repairedModel == null) {
                    FrontendMarkupContributor.logger.warn("Received unrepairable update for highlighter during flush. Model: " + HighlightersUtilKt.prettyPrint(model));
                    continue;
                }
                this$0.markupAdapter.updateHighlighter(highlighter, new HighlighterElement(repairedModel, extensions));
            }
        }
        ArrayList<HighlighterElement> notReused = new ArrayList<HighlighterElement>();
        List<HighlighterElement> notRegistered = this$0.storage.flushNotRegistered();
        if (!((Collection)notRegistered).isEmpty()) {
            Logger $this$trace$iv3 = FrontendMarkupContributor.logger;
            boolean $i$f$trace22 = false;
            if ($this$trace$iv3.isTraceEnabled()) {
                logger = $this$trace$iv3;
                boolean bl = false;
                logger.trace("Flushing to markup " + notRegistered.size() + " not registered highlighters");
            }
            for (HighlighterElement $i$f$trace22 : notRegistered) {
                HighlighterModel highlighterModel = $i$f$trace22.component1();
                extensions = $i$f$trace22.component2();
                repairedModel = this$0.repair(highlighterModel, true);
                if (repairedModel == null) {
                    FrontendMarkupContributor.logger.warn("Invalid highlighters are presented in notRegistered highlighters during flush");
                    continue;
                }
                HighlighterElement repairedElement = new HighlighterElement(repairedModel, extensions);
                RangeHighlighterEx recycled = this$0.recycle(repairedElement);
                if (recycled != null) continue;
                notReused.add(repairedElement);
            }
            int reused = notRegistered.size() - notReused.size();
            $this$trace$iv = FrontendMarkupContributor.logger;
            boolean $i$f$trace3 = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Reused " + reused + " highlighters during flush");
            }
        }
        if (!((Collection)(notDeleted = this$0.storage.flushNotDeleted())).isEmpty()) {
            $this$trace$iv = FrontendMarkupContributor.logger;
            boolean $i$f$trace4 = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Deleting " + notDeleted.size() + " highlighters from markup");
            }
            this$0.markupAdapter.bulkRemoveHighlighters(notDeleted);
        }
        if (notReused.size() != 0) {
            $this$trace$iv = FrontendMarkupContributor.logger;
            boolean $i$f$trace5 = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Registering last portion of " + notReused.size() + " highlighters which have failed at reusing");
            }
            List<RangeHighlighterEx> added = this$0.markupAdapter.bulkAddHighlighters((List<HighlighterElement>)notReused);
            int n = ((Collection)added).size();
            for (int i = 0; i < n; ++i) {
                this$0.storage.addHighlighter(((HighlighterElement)notReused.get(i)).getHighlighter().getId(), added.get(i));
            }
        }
        this$0.highlighterRepairer.shrinkHistory();
        return Unit.INSTANCE;
    }

    private static final Unit highlightersAdded$lambda$8(List $added, FrontendMarkupContributor this$0) {
        List repairedModels = new ArrayList();
        for (HighlighterElement element : $added) {
            Object object;
            HighlighterModel repairedModel;
            boolean bl;
            HighlighterModel highlighterModel = element.getHighlighter();
            List extensions = element.getExtensions();
            boolean bl2 = bl = this$0.storage.get(highlighterModel.getId()) == null;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-FrontendMarkupContributor$highlightersAdded$1$22 = false;
                String $i$a$-assert-FrontendMarkupContributor$highlightersAdded$1$22 = "Multiple highlighter registration on IDEA-side! id: " + highlighterModel.getId() + " model: " + HighlightersUtilKt.prettyPrint(highlighterModel);
                throw new AssertionError((Object)$i$a$-assert-FrontendMarkupContributor$highlightersAdded$1$22);
            }
            if (this$0.repair(highlighterModel, true) == null || this$0.isReplaced(highlighterModel)) continue;
            HighlighterElement repairedElement = new HighlighterElement(repairedModel, extensions);
            if (this$0.suppressor.shouldSuppressAddition(highlighterModel.getProperties())) {
                object = this$0.recycle(repairedElement);
                if (object == null) {
                    FrontendMarkupContributor $this$highlightersAdded_u24lambda_u248_u24lambda_u247 = this$0;
                    boolean bl3 = false;
                    $this$highlightersAdded_u24lambda_u248_u24lambda_u247.storage.queueRegistration(element);
                    $this$highlightersAdded_u24lambda_u248_u24lambda_u247.queueUpdateIfNeed();
                    object = Unit.INSTANCE;
                }
                continue;
            }
            object = repairedModels.add(repairedElement);
        }
        if (repairedModels.isEmpty()) {
            return Unit.INSTANCE;
        }
        List<RangeHighlighterEx> bulkAdded = this$0.markupAdapter.bulkAddHighlighters(repairedModels);
        int n = ((Collection)bulkAdded).size();
        for (int i = 0; i < n; ++i) {
            this$0.storage.addHighlighter(((HighlighterElement)repairedModels.get(i)).getHighlighter().getId(), bulkAdded.get(i));
        }
        return Unit.INSTANCE;
    }

    private static final Unit highlightersUpdated$lambda$10(List $updated, FrontendMarkupContributor this$0) {
        for (HighlighterElement element : $updated) {
            if (this$0.storage.updateRegistration(element)) continue;
            RangeHighlighterEx highlighter = this$0.storage.get(element.getHighlighter().getId());
            if (highlighter == null) {
                logger.warn("Received update for not registered highlighter " + HighlightersUtilKt.prettyPrint(element.getHighlighter()));
                continue;
            }
            if (this$0.suppressor.shouldSuppressUpdate()) {
                this$0.storage.queueUpdate(highlighter, element);
                this$0.queueUpdateIfNeed();
                continue;
            }
            HighlighterModel repairedModel = this$0.repair(element.getHighlighter(), false);
            if (repairedModel == null) {
                if (element.getHighlighter().getProperties().isVerifiable()) {
                    logger.trace("Received unrepairable update for highlighter. Model: " + HighlightersUtilKt.prettyPrint(element.getHighlighter()));
                    continue;
                }
                logger.warn("Received unrepairable update for highlighter. Model: " + HighlightersUtilKt.prettyPrint(element.getHighlighter()));
                continue;
            }
            this$0.markupAdapter.updateHighlighter(highlighter, new HighlighterElement(repairedModel, element.getExtensions()));
        }
        return Unit.INSTANCE;
    }

    private static final Unit highlightersRemoved$lambda$12(List $removed, FrontendMarkupContributor this$0) {
        List toRemove = new ArrayList();
        Iterator iterator2 = $removed.iterator();
        while (iterator2.hasNext()) {
            RangeHighlighterEx highlighter;
            long id = ((Number)iterator2.next()).longValue();
            if (this$0.storage.remove(id) == null) continue;
            if (this$0.suppressor.shouldSuppressDeletion(UtilKt.getBackendProperties((RangeHighlighter)((RangeHighlighter)highlighter)))) {
                this$0.storage.queueDeletion(highlighter);
                this$0.queueUpdateIfNeed();
                continue;
            }
            toRemove.add(highlighter);
        }
        if (toRemove.isEmpty()) {
            return Unit.INSTANCE;
        }
        this$0.markupAdapter.bulkRemoveHighlighters(toRemove);
        return Unit.INSTANCE;
    }

    private static final Unit removeAllHighlighters$lambda$15(FrontendMarkupContributor this$0) {
        boolean any;
        block3: {
            boolean bl;
            List allHighlighters = CollectionsKt.plus(this$0.storage.getRegisteredHighlighters(), (Iterable)this$0.storage.flushNotDeleted());
            logger.debug("Cleaning highlighter storage. Total amount " + allHighlighters.size());
            this$0.markupAdapter.bulkRemoveHighlighters(allHighlighters);
            this$0.storage.clear();
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl2 = false;
                logger.trace("storage: " + this$0.storage);
            }
            RangeHighlighterEx[] $this$any$iv = this$0.markupAdapter.getAllHighlighters();
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                RangeHighlighterEx element$iv;
                RangeHighlighterEx it = element$iv = $this$any$iv[i];
                boolean bl3 = false;
                if (!HighlightersUtilKt.isBackendHighlighter((RangeHighlighter)it)) continue;
                bl = true;
                break block3;
            }
            bl = any = false;
        }
        if (any) {
            logger.error("backend highlighters present in Markup model after cleaning");
        }
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$17(FrontendMarkupContributor this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("RdMarkupModel.highlightersRemoved fired: count=" + it.size());
        }
        this$0.highlightersRemoved(it);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit bind$lambda$20(FrontendMarkupContributor this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            void $this$mapTo$iv$iv;
            Logger logger = $this$trace$iv;
            boolean bl = false;
            StringBuilder result2 = new StringBuilder().append("RdMarkupModel.highlightersAdded fired: count=" + it.size()).append('\n').append("Received highlighters from backend.  Highlighter breakdown:").append('\n');
            Iterable $this$map$iv = it;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void element;
                HighlighterElement highlighterElement = (HighlighterElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                HighlighterModel highlighter = element.getHighlighter();
                result2.append(highlighter.getProperties().getAttributeId()).append(":");
                com.jetbrains.rdclient.daemon.FrontendMarkupContributor$Companion.prettyPrint$default(Companion, highlighter.getTextAttributesKey(), result2, 0, 2, null);
                collection.add(Unit.INSTANCE);
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
            String string = result2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            logger.trace(string);
        }
        this$0.highlightersAdded(it);
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$22(FrontendMarkupContributor this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("RdMarkupModel.highlightersUpdated fired: count=" + it.size());
        }
        this$0.highlightersUpdated(it);
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$24(FrontendMarkupContributor this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("RdMarkupModel.highlightersCleared fired. call removeAllHighlighters()");
        }
        this$0.removeAllHighlighters();
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$26(FrontendMarkupContributor this$0, Lifetime it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("suppressor is released. call flushHighlighters()");
        }
        this$0.flushHighlighters();
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$28(FrontendMarkupContributor this$0) {
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("RdMarkupModel.highlightersCleared fired. call removeAllHighlighters()");
        }
        this$0.removeAllHighlighters();
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendMarkupContributor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendMarkupContributor.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0006\u001a\u00020\u0007*\u0004\u0018\u00010\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\b\b\u0002\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdclient/daemon/FrontendMarkupContributor$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "prettyPrint", "", "Lcom/jetbrains/ide/model/highlighterRegistration/TextAttributesKeyModel;", "result", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "depth", "", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public final void prettyPrint(@Nullable TextAttributesKeyModel $this$prettyPrint, @NotNull StringBuilder result2, int depth) {
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            if ($this$prettyPrint == null) {
                result2.append("[NULL KEY]").append('\n');
                return;
            }
            if (!($this$prettyPrint instanceof IdeaTextAttributesKey)) {
                result2.append("[NON-IDEA KEY]").append('\n');
                return;
            }
            String indent = "  ";
            StringBuilder stringBuilder = result2.append(((IdeaTextAttributesKey)$this$prettyPrint).getExternalName());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.append(" (").append('\n');
            com.jetbrains.rdclient.daemon.FrontendMarkupContributor$Companion.prettyPrint$indent(depth, result2, indent).append(indent).append("fallback: ");
            TextAttributesKeyModel fallback = ((IdeaTextAttributesKey)$this$prettyPrint).getFallback();
            if (fallback == null) {
                result2.append("NULL").append('\n');
            } else {
                this.prettyPrint(fallback, result2, depth + 1);
            }
            com.jetbrains.rdclient.daemon.FrontendMarkupContributor$Companion.prettyPrint$indent(depth, result2, indent).append(")").append('\n');
        }

        public static /* synthetic */ void prettyPrint$default(Companion companion, TextAttributesKeyModel textAttributesKeyModel, StringBuilder stringBuilder, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            companion.prettyPrint(textAttributesKeyModel, stringBuilder, n);
        }

        private static final StringBuilder prettyPrint$indent(int $depth, StringBuilder $result, String indent) {
            for (int i = 0; i < $depth; ++i) {
                $result.append(indent);
            }
            return $result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdclient/daemon/FrontendMarkupContributor$MergingUpdateTask;", "Lcom/intellij/util/ui/update/Update;", "modality", "Lcom/intellij/openapi/application/ModalityState;", "<init>", "(Lcom/jetbrains/rdclient/daemon/FrontendMarkupContributor;Lcom/intellij/openapi/application/ModalityState;)V", "run", "", "canEat", "", "update", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendMarkupContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendMarkupContributor.kt\ncom/jetbrains/rdclient/daemon/FrontendMarkupContributor$MergingUpdateTask\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,315:1\n69#2,4:316\n*S KotlinDebug\n*F\n+ 1 FrontendMarkupContributor.kt\ncom/jetbrains/rdclient/daemon/FrontendMarkupContributor$MergingUpdateTask\n*L\n41#1:316,4\n*E\n"})
    private final class MergingUpdateTask
    extends Update {
        @NotNull
        private final ModalityState modality;

        public MergingUpdateTask(ModalityState modality) {
            Intrinsics.checkNotNullParameter((Object)modality, (String)"modality");
            super((Object)modality, false, 0, 6, null);
            this.modality = modality;
        }

        public void run() {
            ApplicationKt.getApplication().invokeLater(() -> MergingUpdateTask.run$lambda$1(FrontendMarkupContributor.this, this), this.modality);
        }

        public boolean canEat(@NotNull Update update2) {
            Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
            if (!(update2 instanceof MergingUpdateTask)) {
                return false;
            }
            ModalityState otherModality = ((MergingUpdateTask)update2).modality;
            return Intrinsics.areEqual((Object)this.modality, (Object)otherModality) || this.modality.dominates(otherModality);
        }

        private static final void run$lambda$1(FrontendMarkupContributor this$0, MergingUpdateTask this$1) {
            if (this$0.suppressor.isSuppressed$intellij_rd_client() == MarkupSuppressionKind.NONE && RLifetimeKt.isAlive((Lifetime)this$0.getLifetime())) {
                Logger $this$trace$iv = logger;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("MergingUpdateTask.run&invokeLater: call flushHighlighters(). modality: " + this$1.modality);
                }
                this$0.flushHighlighters();
            }
        }
    }
}

