/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.jcef;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.SearchReplaceComponent;
import com.intellij.find.SearchSession;
import com.intellij.find.editorHeaderActions.NextOccurrenceAction;
import com.intellij.find.editorHeaderActions.PrevOccurrenceAction;
import com.intellij.find.editorHeaderActions.ToggleMatchCase;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.cef.browser.CefBrowser;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0002J\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0013H\u0002J\r\u0010\u001b\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u001cJ\b\u0010\u001d\u001a\u00020\u0015H\u0016J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u001f\u001a\u00020\u0015H\u0016J\b\u0010 \u001a\u00020\rH\u0002J\b\u0010!\u001a\u00020\u000fH\u0002J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/jcef/MarkdownPreviewSearchSession;", "Lcom/intellij/find/SearchSession;", "Lcom/intellij/find/SearchReplaceComponent$Listener;", "Lcom/intellij/find/FindModel$FindModelObserver;", "project", "Lcom/intellij/openapi/project/Project;", "browser", "Lorg/cef/browser/CefBrowser;", "targetComponent", "Ljavax/swing/JComponent;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/cef/browser/CefBrowser;Ljavax/swing/JComponent;)V", "findModel", "Lcom/intellij/find/FindModel;", "searchComponent", "Lcom/intellij/find/SearchReplaceComponent;", "getFindModel", "getComponent", "hasMatches", "", "searchForward", "", "searchBackward", "addTextToRecent", "search", "model", "forward", "showSearchBar", "showSearchBar$intellij_markdown", "close", "findModelChanged", "searchFieldDocumentChanged", "createFindModel", "createSearchComponent", "registerTextComponentActionShortcuts", "component", "Ljavax/swing/text/JTextComponent;", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nMarkdownPreviewSearchSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownPreviewSearchSession.kt\norg/intellij/plugins/markdown/ui/preview/jcef/MarkdownPreviewSearchSession\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n1611#2,9:126\n1863#2:135\n1864#2:137\n1620#2:138\n1863#2,2:139\n1#3:136\n*S KotlinDebug\n*F\n+ 1 MarkdownPreviewSearchSession.kt\norg/intellij/plugins/markdown/ui/preview/jcef/MarkdownPreviewSearchSession\n*L\n120#1:126,9\n120#1:135\n120#1:137\n120#1:138\n122#1:139,2\n120#1:136\n*E\n"})
public final class MarkdownPreviewSearchSession
implements SearchSession,
SearchReplaceComponent.Listener,
FindModel.FindModelObserver {
    @NotNull
    private final Project project;
    @NotNull
    private final CefBrowser browser;
    @NotNull
    private final JComponent targetComponent;
    @NotNull
    private final FindModel findModel;
    @NotNull
    private final SearchReplaceComponent searchComponent;

    public MarkdownPreviewSearchSession(@NotNull Project project, @NotNull CefBrowser browser, @NotNull JComponent targetComponent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        Intrinsics.checkNotNullParameter((Object)targetComponent, (String)"targetComponent");
        this.project = project;
        this.browser = browser;
        this.targetComponent = targetComponent;
        this.findModel = this.createFindModel();
        this.searchComponent = this.createSearchComponent();
    }

    @NotNull
    public FindModel getFindModel() {
        return this.findModel;
    }

    @NotNull
    public SearchReplaceComponent getComponent() {
        return this.searchComponent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasMatches() {
        if (!this.searchComponent.isVisible()) return false;
        String string = this.searchComponent.getSearchTextComponent().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (((CharSequence)string).length() <= 0) return false;
        return true;
    }

    public void searchForward() {
        this.addTextToRecent();
        this.search(this.findModel, true);
    }

    public void searchBackward() {
        this.addTextToRecent();
        this.search(this.findModel, false);
    }

    private final void addTextToRecent() {
        JTextComponent jTextComponent = this.searchComponent.getSearchTextComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jTextComponent, (String)"getSearchTextComponent(...)");
        JTextComponent textComponent = jTextComponent;
        String text2 = textComponent.getText();
        Intrinsics.checkNotNull((Object)text2);
        if (!StringsKt.isBlank((CharSequence)text2)) {
            this.searchComponent.addTextToRecent(textComponent);
        }
    }

    private final void search(FindModel model, boolean forward) {
        String string = model.getStringToFind();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringToFind(...)");
        String stringToFind = string;
        if (((CharSequence)stringToFind).length() > 0) {
            this.browser.find(stringToFind, forward, model.isCaseSensitive(), true);
        }
    }

    public final void showSearchBar$intellij_markdown() {
        this.searchComponent.setVisible(true);
        IdeFocusManager.getInstance((Project)this.project).requestFocus((Component)this.searchComponent.getSearchTextComponent(), false);
    }

    public void close() {
        this.searchComponent.setVisible(false);
        this.browser.stopFinding(true);
        IdeFocusManager.getInstance((Project)this.project).requestFocus((Component)this.targetComponent, false);
    }

    public void findModelChanged(@NotNull FindModel findModel) {
        Intrinsics.checkNotNullParameter((Object)findModel, (String)"findModel");
        String string = findModel.getStringToFind();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringToFind(...)");
        String stringToFind = string;
        this.searchComponent.update(stringToFind, "", false, findModel.isMultiline());
        if (((CharSequence)stringToFind).length() == 0) {
            this.browser.stopFinding(true);
        } else {
            this.search(findModel, true);
        }
    }

    public void searchFieldDocumentChanged() {
        this.findModel.setStringToFind(this.searchComponent.getSearchTextComponent().getText());
    }

    private final FindModel createFindModel() {
        FindModel model = new FindModel();
        model.copyFrom(FindManager.getInstance((Project)this.project).getFindInFileModel());
        model.addObserver((FindModel.FindModelObserver)this);
        return model;
    }

    private final SearchReplaceComponent createSearchComponent() {
        AnAction[] anActionArray = new AnAction[]{new ToggleMatchCase(), new PrevOccurrenceAction(), new NextOccurrenceAction()};
        SearchReplaceComponent searchReplaceComponent = SearchReplaceComponent.buildFor((Project)this.project, (JComponent)this.targetComponent, (SearchSession)this).addExtraSearchActions(anActionArray).withMaximizeLeftPanelOnResize().withCloseAction(() -> MarkdownPreviewSearchSession.createSearchComponent$lambda$0(this)).build();
        Intrinsics.checkNotNullExpressionValue((Object)searchReplaceComponent, (String)"build(...)");
        SearchReplaceComponent component = searchReplaceComponent;
        component.setVisible(false);
        component.addListener((SearchReplaceComponent.Listener)this);
        JTextComponent jTextComponent = component.getSearchTextComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jTextComponent, (String)"getSearchTextComponent(...)");
        this.registerTextComponentActionShortcuts(jTextComponent);
        return component;
    }

    /*
     * WARNING - void declaration
     */
    private final void registerTextComponentActionShortcuts(JTextComponent component) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        ActionManager actionManager = ActionManager.getInstance();
        Object object = new String[]{"EditorCopy", "EditorCut", "EditorPaste", "$SelectAll", "$Undo", "$Redo"};
        object = CollectionsKt.listOf((Object[])object);
        boolean $i$f$mapNotNull = false;
        Iterator iterator = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            AnAction it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String p0 = (String)element$iv$iv;
            boolean bl2 = false;
            if (actionManager.getAction(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List actions = (List)destination$iv$iv;
        Iterable $this$forEach$iv = actions;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            AnAction it = (AnAction)element$iv;
            boolean bl = false;
            it.registerCustomShortcutSet((JComponent)component, null);
        }
    }

    private static final void createSearchComponent$lambda$0(MarkdownPreviewSearchSession this$0) {
        this$0.close();
    }
}

