/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.settings.local;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.settings.local.ModernStringDataType;
import com.intellij.platform.settings.local.MvMapManager;
import com.intellij.util.io.mvstore.MvStoreHelperKt;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.type.ByteArrayDataType;
import org.h2.mvstore.type.DataType;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\r\u0010\u0000\u001a\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u0002\u001a\b\u0010\u0003\u001a\u00020\u0004H\u0002\u001a$\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"nowAsDuration", "Lkotlin/time/Duration;", "()J", "getDatabaseFile", "Ljava/nio/file/Path;", "openMap", "Lorg/h2/mvstore/MVMap;", "", "", "store", "Lorg/h2/mvstore/MVStore;", "name", "intellij.platform.settings.local"})
@SourceDebugExtension(value={"SMAP\nMvMapManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MvMapManager.kt\ncom/intellij/platform/settings/local/MvMapManagerKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,108:1\n15#2:109\n*S KotlinDebug\n*F\n+ 1 MvMapManager.kt\ncom/intellij/platform/settings/local/MvMapManagerKt\n*L\n107#1:109\n*E\n"})
public final class MvMapManagerKt {
    private static final long nowAsDuration() {
        return DurationKt.toDuration((long)System.currentTimeMillis(), (DurationUnit)DurationUnit.MILLISECONDS);
    }

    private static final Path getDatabaseFile() {
        Path path = PathManager.getConfigDir().resolve("app-internal-state.db");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private static final MVMap<String, byte[]> openMap(MVStore store, String name) {
        MVMap.Builder mapBuilder = new MVMap.Builder();
        mapBuilder.setKeyType((DataType)ModernStringDataType.INSTANCE);
        mapBuilder.setValueType((DataType)ByteArrayDataType.INSTANCE);
        return MvStoreHelperKt.openOrResetMap((MVStore)store, (String)name, (MVMap.Builder)mapBuilder, MvMapManagerKt::openMap$lambda$0);
    }

    private static final Logger openMap$lambda$0() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MvMapManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    public static final /* synthetic */ long access$nowAsDuration() {
        return MvMapManagerKt.nowAsDuration();
    }

    public static final /* synthetic */ Path access$getDatabaseFile() {
        return MvMapManagerKt.getDatabaseFile();
    }

    public static final /* synthetic */ MVMap access$openMap(MVStore store, String name) {
        return MvMapManagerKt.openMap(store, name);
    }
}

