/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.indexing.shared.metadata.SharedIndexMetadata;
import com.intellij.indexing.shared.platform.api.MutableSharedIndexStorage;
import com.intellij.indexing.shared.platform.api.SharedIndexInfrastructureVersion;
import com.intellij.indexing.shared.platform.api.SharedIndexStats;
import com.intellij.indexing.shared.platform.api.layout.SharedChunkLocation;
import com.intellij.indexing.shared.platform.impl.SharedIndexMainZipStorageKt;
import com.intellij.indexing.shared.platform.impl.layout.FileBasedSharedChunkLocation;
import com.intellij.indexing.shared.util.UtilKt;
import com.intellij.indexing.shared.util.zipFs.UncompressedZipFileSystem;
import com.intellij.indexing.shared.util.zipFs.Zip64Util;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.io.zip.JBZipEntry;
import com.intellij.util.io.zip.JBZipFile;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0015\u001a\u00020\u0011H\u0002J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0006H\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0006H\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001a\u001a\u00020\u0006H\u0016J\u0018\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0006H\u0016J\b\u0010\"\u001a\u00020\u0006H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/indexing/shared/platform/impl/SharedIndexMainZipStorage;", "Lcom/intellij/indexing/shared/platform/api/MutableSharedIndexStorage;", "oldStoragePath", "Ljava/nio/file/Path;", "storagePath", "storageId", "", "<init>", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/lang/String;)V", "getStorageId", "()Ljava/lang/String;", "readSystem", "Lcom/intellij/indexing/shared/util/zipFs/UncompressedZipFileSystem;", "fileSystemModificationLock", "Ljava/util/concurrent/locks/ReentrantLock;", "myStats", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/indexing/shared/platform/api/SharedIndexStats;", "myCompatibleChunksCache", "", "", "updateStats", "getSharedIndexStats", "close", "", "isCompatibleChunk", "chunkId", "listChunks", "", "getChunkRootPath", "getChunkRoot", "Lcom/intellij/indexing/shared/platform/api/layout/SharedChunkLocation;", "appendChunk", "chunkSourcePath", "toString", "intellij.indexing.shared"})
@SourceDebugExtension(value={"SMAP\nSharedIndexMainZipStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexMainZipStorage.kt\ncom/intellij/indexing/shared/platform/impl/SharedIndexMainZipStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,242:1\n1#2:243\n*E\n"})
public final class SharedIndexMainZipStorage
implements MutableSharedIndexStorage {
    @NotNull
    private final Path storagePath;
    @NotNull
    private final String storageId;
    @NotNull
    private final UncompressedZipFileSystem readSystem;
    @NotNull
    private final ReentrantLock fileSystemModificationLock;
    @NotNull
    private final AtomicReference<SharedIndexStats> myStats;
    @NotNull
    private final Map<String, Boolean> myCompatibleChunksCache;

    @VisibleForTesting
    public SharedIndexMainZipStorage(@NotNull Path oldStoragePath, @NotNull Path storagePath, @NotNull String storageId) throws IOException {
        Intrinsics.checkNotNullParameter((Object)oldStoragePath, (String)"oldStoragePath");
        Intrinsics.checkNotNullParameter((Object)storagePath, (String)"storagePath");
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        this.storagePath = storagePath;
        this.storageId = storageId;
        this.fileSystemModificationLock = new ReentrantLock();
        this.myStats = new AtomicReference<Object>(null);
        this.myCompatibleChunksCache = new LinkedHashMap();
        if (Files.exists(oldStoragePath, new LinkOption[0])) {
            if (Files.exists(this.storagePath, new LinkOption[0])) {
                throw new IOException();
            }
            FileUtil.rename((File)oldStoragePath.toFile(), (String)((Object)this.storagePath.getFileName()).toString());
        }
        if (!Files.exists(this.storagePath, new LinkOption[0])) {
            Zip64Util.openZip64File(this.storagePath, false).close();
        }
        this.readSystem = UncompressedZipFileSystem.create(this.storagePath);
        SharedIndexStats stats = this.updateStats();
        if (this.listChunks().isEmpty()) {
            SharedIndexMainZipStorageKt.access$getLOG$p().info("Shared Indexes Storage is opened and empty");
        } else {
            SharedIndexMainZipStorageKt.access$getLOG$p().info("Shared Indexes Storage is opened: " + stats.toLogMessage() + ", chunks: " + CollectionsKt.sorted((Iterable)this.listChunks()));
        }
    }

    @Override
    @NotNull
    public String getStorageId() {
        return this.storageId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized SharedIndexStats updateStats() {
        SharedIndexStats sharedIndexStats;
        try {
            int n;
            long size = UtilKt.getFileOrDirectorySize(this.storagePath);
            AutoCloseable autoCloseable = Files.list(this.readSystem.getRootDirectory());
            Throwable throwable = null;
            try {
                Stream stream = (Stream)autoCloseable;
                boolean bl = false;
                n = (int)stream.filter(arg_0 -> SharedIndexMainZipStorage.updateStats$lambda$2$lambda$1(SharedIndexMainZipStorage::updateStats$lambda$2$lambda$0, arg_0)).count();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            int chunks = n;
            sharedIndexStats = new SharedIndexStats(size, chunks);
        }
        catch (Throwable t) {
            SharedIndexMainZipStorageKt.access$getLOG$p().info("Failed to compute shared indexes stats. " + t.getMessage(), t);
            sharedIndexStats = new SharedIndexStats(0L, 0);
        }
        SharedIndexStats result = sharedIndexStats;
        this.myStats.set(result);
        return result;
    }

    @Override
    @NotNull
    public SharedIndexStats getSharedIndexStats() {
        SharedIndexStats sharedIndexStats = this.myStats.get();
        if (sharedIndexStats == null) {
            sharedIndexStats = this.updateStats();
        }
        return sharedIndexStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        Lock lock = this.fileSystemModificationLock;
        lock.lock();
        try {
            boolean bl = false;
            this.readSystem.close();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public synchronized boolean isCompatibleChunk(@NotNull String chunkId) {
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        Boolean bl = this.myCompatibleChunksCache.computeIfAbsent(chunkId, arg_0 -> SharedIndexMainZipStorage.isCompatibleChunk$lambda$5(arg_0 -> SharedIndexMainZipStorage.isCompatibleChunk$lambda$4(this, chunkId, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"computeIfAbsent(...)");
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Collection<String> listChunks() {
        SortedSet sortedSet;
        AutoCloseable autoCloseable = Files.list(this.readSystem.getRootDirectory());
        Throwable throwable = null;
        try {
            Stream list = (Stream)autoCloseable;
            boolean bl = false;
            List<String> list2 = list.filter(arg_0 -> SharedIndexMainZipStorage.listChunks$lambda$10$lambda$7(SharedIndexMainZipStorage::listChunks$lambda$10$lambda$6, arg_0)).map(arg_0 -> SharedIndexMainZipStorage.listChunks$lambda$10$lambda$9(SharedIndexMainZipStorage::listChunks$lambda$10$lambda$8, arg_0)).toList();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"toList(...)");
            sortedSet = CollectionsKt.toSortedSet((Iterable)list2);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return sortedSet;
    }

    private final synchronized Path getChunkRootPath(String chunkId) {
        Path path = this.readSystem.getPath(chunkId, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        return path;
    }

    @Override
    @Nullable
    public synchronized SharedChunkLocation getChunkRoot(@NotNull String chunkId) {
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        Path chunkRoot = this.getChunkRootPath(chunkId);
        return Files.isDirectory(chunkRoot, new LinkOption[0]) ? (SharedChunkLocation)new FileBasedSharedChunkLocation(chunkRoot) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void appendChunk(@NotNull Path chunkSourcePath, @NotNull String chunkId) throws IOException {
        Intrinsics.checkNotNullParameter((Object)chunkSourcePath, (String)"chunkSourcePath");
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        Lock lock = this.fileSystemModificationLock;
        lock.lock();
        try {
            Object stats;
            boolean bl = false;
            if (!this.readSystem.isOpen()) {
                return;
            }
            if (!Files.exists(chunkSourcePath, new LinkOption[0])) {
                throw new NoSuchFileException(((Object)chunkSourcePath).toString());
            }
            if (this.containsChunk(chunkId)) {
                return;
            }
            Map sourceSnapshot = SharedIndexMainZipStorageKt.access$takeSourceChunkSnapshot(chunkSourcePath);
            try {
                long timestamp = System.currentTimeMillis();
                Object object = FileUtilRt.doIOOperation(arg_0 -> SharedIndexMainZipStorage.appendChunk$lambda$14$lambda$11(this, arg_0));
                Intrinsics.checkNotNull((Object)object);
                JBZipFile storageZipFile = (JBZipFile)object;
                Closeable closeable = (Closeable)storageZipFile;
                Throwable throwable = null;
                try {
                    Path path;
                    JBZipFile it = (JBZipFile)closeable;
                    boolean bl2 = false;
                    Closeable closeable2 = UncompressedZipFileSystem.create(chunkSourcePath);
                    Throwable throwable2 = null;
                    try {
                        UncompressedZipFileSystem sourceFs = (UncompressedZipFileSystem)closeable2;
                        boolean bl3 = false;
                        path = Files.walkFileTree(sourceFs.getRootDirectory(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(it, chunkId, timestamp){
                            final /* synthetic */ JBZipFile $it;
                            final /* synthetic */ String $chunkId;
                            final /* synthetic */ long $timestamp;
                            {
                                this.$it = $it;
                                this.$chunkId = $chunkId;
                                this.$timestamp = $timestamp;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                                if (!Files.isDirectory(file, new LinkOption[0])) {
                                    JBZipEntry createdEntry = this.$it.getOrCreateEntry(this.$chunkId + "/" + file);
                                    createdEntry.setMethod(0);
                                    createdEntry.setTime(this.$timestamp);
                                    Closeable closeable = Files.newInputStream(file, new OpenOption[0]);
                                    Throwable throwable = null;
                                    try {
                                        InputStream it = (InputStream)closeable;
                                        boolean bl = false;
                                        createdEntry.setDataFromStream(it);
                                        Unit unit = Unit.INSTANCE;
                                    }
                                    catch (Throwable throwable2) {
                                        throwable = throwable2;
                                        throw throwable2;
                                    }
                                    finally {
                                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                                    }
                                }
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    Path path2 = path;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (ProcessCanceledException e) {
                stats = new Attachment[]{new Attachment("pce", (Throwable)e)};
                SharedIndexMainZipStorageKt.access$getLOG$p().error("ProcessCanceledException should not be thrown there", (Attachment[])stats);
            }
            catch (Throwable e) {
                SharedIndexMainZipStorageKt.access$getLOG$p().error("Failed to append chunk", e);
                throw e;
            }
            finally {
                try {
                    this.readSystem.sync();
                }
                catch (Exception e) {
                    SharedIndexMainZipStorageKt.access$getLOG$p().error("Failed to sync shared index storage", (Throwable)e);
                    throw e;
                }
                if (this.getChunkRoot(chunkId) == null) {
                    throw new IOException("Can't find root for added chunk " + chunkId + "; available roots: " + this.listChunks());
                }
                Map storedSnapshot = SharedIndexMainZipStorageKt.access$takeStoredChunkSnapshot(this.getChunkRootPath(chunkId));
                SharedIndexMainZipStorageKt.access$ensureSnapshotsEqual(sourceSnapshot, storedSnapshot);
                stats = this.updateStats();
                SharedIndexMainZipStorageKt.access$getLOG$p().info("Shared Indexes Storage is updated with " + chunkId + ". Total: " + ((SharedIndexStats)stats).toLogMessage());
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @NotNull
    public String toString() {
        return this.getStorageId();
    }

    private static final boolean updateStats$lambda$2$lambda$0(Path it) {
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isDirectory(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    private static final boolean updateStats$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Boolean isCompatibleChunk$lambda$4(SharedIndexMainZipStorage this$0, String $chunkId, String it) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        try {
            SharedChunkLocation sharedChunkLocation = this$0.getChunkRoot($chunkId);
            if (sharedChunkLocation == null) {
                return false;
            }
            SharedChunkLocation chunkRoot = sharedChunkLocation;
            SharedIndexMetadata sharedIndexMetadata = chunkRoot.readSharedIndexMetadata();
            if (sharedIndexMetadata == null) {
                return false;
            }
            SharedIndexMetadata chunkVersion = sharedIndexMetadata;
            bl = SharedIndexInfrastructureVersion.getIdeVersion().isSuitableMetadata(chunkVersion);
        }
        catch (Throwable t) {
            SharedIndexMainZipStorageKt.access$getLOG$p().info("Failed to check compatibility of " + $chunkId + " in " + this$0.storagePath);
            bl = false;
        }
        return bl;
    }

    private static final Boolean isCompatibleChunk$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean listChunks$lambda$10$lambda$6(Path it) {
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isDirectory(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    private static final boolean listChunks$lambda$10$lambda$7(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String listChunks$lambda$10$lambda$8(Path it) {
        return ((Object)it.getFileName()).toString();
    }

    private static final String listChunks$lambda$10$lambda$9(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final JBZipFile appendChunk$lambda$14$lambda$11(SharedIndexMainZipStorage this$0, boolean lastAttempt) {
        JBZipFile jBZipFile;
        try {
            jBZipFile = Zip64Util.openZip64File(this$0.storagePath, false);
        }
        catch (IOException e) {
            if (lastAttempt) {
                throw e;
            }
            return null;
        }
        return jBZipFile;
    }
}

