/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.fus;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Version;
import com.intellij.ssh.SshException;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.config.SshConnectionConfigService;
import com.intellij.ssh.fus.SshApplicationUsagesCollector;
import com.intellij.ssh.fus.SshApplicationUsagesCollectorImpl;
import com.intellij.ssh.fus.SshApplicationUsagesCollectorKt;
import com.intellij.ssh.ui.SshConnectionStateListener;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.Function;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0003\f\r\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ssh/fus/SshApplicationUsagesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ApplicationUsagesCollector;", "<init>", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "getOpenSshVersionStats", "sshExecutable", "", "SharedFields", "RemoteServerInfo", "SshConnectionListener", "intellij.platform.ssh"})
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nSshApplicationUsagesCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshApplicationUsagesCollector.kt\ncom/intellij/ssh/fus/SshApplicationUsagesCollector\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,490:1\n40#2,3:491\n40#2,3:494\n40#2,3:497\n25#3:500\n*S KotlinDebug\n*F\n+ 1 SshApplicationUsagesCollector.kt\ncom/intellij/ssh/fus/SshApplicationUsagesCollector\n*L\n61#1:491,3\n67#1:494,3\n83#1:497,3\n99#1:500\n*E\n"})
public final class SshApplicationUsagesCollector
extends ApplicationUsagesCollector {
    @NotNull
    public EventLogGroup getGroup() {
        boolean $i$f$service = false;
        Class<SharedFields> serviceClass$iv = SharedFields.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return ((SharedFields)object).getGroup();
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        HashSet result = new HashSet();
        SshConnectionConfigService service = SshConnectionConfigService.Companion.getInstance();
        boolean $i$f$service = false;
        Class<SharedFields> serviceClass$iv = SharedFields.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        SharedFields fields = (SharedFields)object;
        ((Collection)result).add(fields.getConfigParser().metric((Object)service.getKind()));
        if (!StringsKt.isBlank((CharSequence)service.getCustomOpenSshExecutable())) {
            ((Collection)result).add(fields.getCustomSshToolPath().metric((Object)true));
        }
        CollectionsKt.addAll((Collection)result, (Iterable)SetsKt.setOfNotNull((Object)SshApplicationUsagesCollector.getOpenSshVersionStats$default(this, null, 1, null)));
        return result;
    }

    @Nullable
    public final MetricEvent getOpenSshVersionStats(@NotNull String sshExecutable) {
        MetricEvent event;
        block11: {
            SshApplicationUsagesCollector output;
            block10: {
                Object object;
                Object $this$getOpenSshVersionStats_u24lambda_u240;
                Intrinsics.checkNotNullParameter((Object)sshExecutable, (String)"sshExecutable");
                SshApplicationUsagesCollector sshApplicationUsagesCollector = this;
                try {
                    $this$getOpenSshVersionStats_u24lambda_u240 = sshApplicationUsagesCollector;
                    boolean bl = false;
                    object = new String[]{sshExecutable, "-V"};
                    $this$getOpenSshVersionStats_u24lambda_u240 = Result.constructor-impl((Object)ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine((String[])object), (int)5000));
                }
                catch (Throwable bl) {
                    $this$getOpenSshVersionStats_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                output = $this$getOpenSshVersionStats_u24lambda_u240;
                boolean $i$f$service = false;
                MatchResult serviceClass$iv = SharedFields.class;
                Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object2 == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                SharedFields fields = (SharedFields)object2;
                if (Result.exceptionOrNull-impl((Object)((Object)output)) instanceof ProcessNotCreatedException) {
                    v1 = fields.getOpensshVersion().metric((Object)"0.0");
                } else {
                    ProcessOutput processOutput = (ProcessOutput)(Result.isFailure-impl((Object)((Object)output)) ? null : output);
                    boolean bl = processOutput != null ? processOutput.getExitCode() == 0 : false;
                    if (bl) {
                        EventId1<String> eventId1 = fields.getOpensshVersion();
                        Regex regex = new Regex("OpenSSH[^ ]*_(\\d+\\.\\d+)(?:\\.[\\d.]+)?p\\d+.*", RegexOption.DOT_MATCHES_ALL);
                        SshApplicationUsagesCollector sshApplicationUsagesCollector2 = output;
                        ResultKt.throwOnFailure((Object)((Object)sshApplicationUsagesCollector2));
                        String string = ((ProcessOutput)sshApplicationUsagesCollector2).getStderr();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStderr(...)");
                        serviceClass$iv = regex.matchEntire((CharSequence)string);
                        v1 = eventId1.metric(serviceClass$iv != null && (object = serviceClass$iv.getGroupValues()) != null ? (String)object.get(1) : null);
                    } else {
                        v1 = event = null;
                    }
                }
                if (event == null) break block10;
                Object v = event.getData().build().get("data");
                if (v == null ? true : v instanceof Version) break block11;
            }
            SshApplicationUsagesCollector $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SshApplicationUsagesCollector.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("Failed to parse OpenSSH version. Output is: " + Result.toString-impl((Object)((Object)output)));
        }
        return event;
    }

    public static /* synthetic */ MetricEvent getOpenSshVersionStats$default(SshApplicationUsagesCollector sshApplicationUsagesCollector, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "ssh";
        }
        return sshApplicationUsagesCollector.getOpenSshVersionStats(string);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0003\u0010\u0011\u0012R(\u0010\u0002\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0012\u0010\u000e\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000b\u0082\u0001\u0003\u0013\u0014\u0015\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0016\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ssh/fus/SshApplicationUsagesCollector$RemoteServerInfo;", "", "userHostPort", "Lkotlin/Triple;", "", "", "Lcom/intellij/ssh/fus/UserHostPort;", "getUserHostPort", "()Lkotlin/Triple;", "os", "getOs", "()Ljava/lang/String;", "arch", "getArch", "combinedOutput", "getCombinedOutput", "Known", "FailedToParse", "ForbiddenExec", "Lcom/intellij/ssh/fus/SshApplicationUsagesCollector$RemoteServerInfo$FailedToParse;", "Lcom/intellij/ssh/fus/SshApplicationUsagesCollector$RemoteServerInfo$ForbiddenExec;", "Lcom/intellij/ssh/fus/SshApplicationUsagesCollector$RemoteServerInfo$Known;", "intellij.platform.ssh"})
    public static interface RemoteServerInfo {
        @NotNull
        public Triple<String, String, Integer> getUserHostPort();

        @NotNull
        public String getOs();

        @NotNull
        public String getArch();

        @NotNull
        public String getCombinedOutput();

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u001c\u0010\u0002\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u0012\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0004H\u00c6\u0003J3\u0010\u0014\u001a\u00020\u00002\u001e\b\u0002\u0010\u0002\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0004H\u00d6\u0001R*\u0010\u0002\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0007\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ssh/fus/SshApplicationUsagesCollector$RemoteServerInfo$FailedToParse;", "Lcom/intellij/ssh/fus/SshApplicationUsagesCollector$RemoteServerInfo;", "userHostPort", "Lkotlin/Triple;", "", "", "Lcom/intellij/ssh/fus/UserHostPort;", "combinedOutput", "<init>", "(Lkotlin/Triple;Ljava/lang/String;)V", "getUserHostPort", "()Lkotlin/Triple;", "getCombinedOutput", "()Ljava/lang/String;", "os", "getOs", "arch", "getArch", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "intellij.platform.ssh"})
        public static final class FailedToParse
        implements RemoteServerInfo {
            @NotNull
            private final Triple<String, String, Integer> userHostPort;
            @NotNull
            private final String combinedOutput;
            @NotNull
            private final String os;
            @NotNull
            private final String arch;

            public FailedToParse(@NotNull Triple<String, String, Integer> userHostPort, @NotNull String combinedOutput) {
                Intrinsics.checkNotNullParameter(userHostPort, (String)"userHostPort");
                Intrinsics.checkNotNullParameter((Object)combinedOutput, (String)"combinedOutput");
                this.userHostPort = userHostPort;
                this.combinedOutput = combinedOutput;
                this.os = "failed_to_parse";
                this.arch = "failed_to_parse";
            }

            @Override
            @NotNull
            public Triple<String, String, Integer> getUserHostPort() {
                return this.userHostPort;
            }

            @Override
            @NotNull
            public String getCombinedOutput() {
                return this.combinedOutput;
            }

            @Override
            @NotNull
            public String getOs() {
                return this.os;
            }

            @Override
            @NotNull
            public String getArch() {
                return this.arch;
            }

            @NotNull
            public final Triple<String, String, Integer> component1() {
                return this.userHostPort;
            }

            @NotNull
            public final String component2() {
                return this.combinedOutput;
            }

            @NotNull
            public final FailedToParse copy(@NotNull Triple<String, String, Integer> userHostPort, @NotNull String combinedOutput) {
                Intrinsics.checkNotNullParameter(userHostPort, (String)"userHostPort");
                Intrinsics.checkNotNullParameter((Object)combinedOutput, (String)"combinedOutput");
                return new FailedToParse(userHostPort, combinedOutput);
            }

            public static /* synthetic */ FailedToParse copy$default(FailedToParse failedToParse, Triple triple, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    triple = failedToParse.userHostPort;
                }
                if ((n & 2) != 0) {
                    string = failedToParse.combinedOutput;
                }
                return failedToParse.copy(triple, string);
            }

            @NotNull
            public String toString() {
                return "FailedToParse(userHostPort=" + this.userHostPort + ", combinedOutput=" + this.combinedOutput + ")";
            }

            public int hashCode() {
                int result = this.userHostPort.hashCode();
                result = result * 31 + this.combinedOutput.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FailedToParse)) {
                    return false;
                }
                FailedToParse failedToParse = (FailedToParse)other;
                if (!Intrinsics.areEqual(this.userHostPort, failedToParse.userHostPort)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.combinedOutput, (Object)failedToParse.combinedOutput);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u001c\u0010\u0002\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u0012\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0004H\u00c6\u0003J3\u0010\u0014\u001a\u00020\u00002\u001e\b\u0002\u0010\u0002\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0004H\u00d6\u0001R*\u0010\u0002\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0007\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ssh/fus/SshApplicationUsagesCollector$RemoteServerInfo$ForbiddenExec;", "Lcom/intellij/ssh/fus/SshApplicationUsagesCollector$RemoteServerInfo;", "userHostPort", "Lkotlin/Triple;", "", "", "Lcom/intellij/ssh/fus/UserHostPort;", "combinedOutput", "<init>", "(Lkotlin/Triple;Ljava/lang/String;)V", "getUserHostPort", "()Lkotlin/Triple;", "getCombinedOutput", "()Ljava/lang/String;", "os", "getOs", "arch", "getArch", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "intellij.platform.ssh"})
        public static final class ForbiddenExec
        implements RemoteServerInfo {
            @NotNull
            private final Triple<String, String, Integer> userHostPort;
            @NotNull
            private final String combinedOutput;
            @NotNull
            private final String os;
            @NotNull
            private final String arch;

            public ForbiddenExec(@NotNull Triple<String, String, Integer> userHostPort, @NotNull String combinedOutput) {
                Intrinsics.checkNotNullParameter(userHostPort, (String)"userHostPort");
                Intrinsics.checkNotNullParameter((Object)combinedOutput, (String)"combinedOutput");
                this.userHostPort = userHostPort;
                this.combinedOutput = combinedOutput;
                this.os = "forbidden_exec";
                this.arch = "forbidden_exec";
            }

            @Override
            @NotNull
            public Triple<String, String, Integer> getUserHostPort() {
                return this.userHostPort;
            }

            @Override
            @NotNull
            public String getCombinedOutput() {
                return this.combinedOutput;
            }

            @Override
            @NotNull
            public String getOs() {
                return this.os;
            }

            @Override
            @NotNull
            public String getArch() {
                return this.arch;
            }

            @NotNull
            public final Triple<String, String, Integer> component1() {
                return this.userHostPort;
            }

            @NotNull
            public final String component2() {
                return this.combinedOutput;
            }

            @NotNull
            public final ForbiddenExec copy(@NotNull Triple<String, String, Integer> userHostPort, @NotNull String combinedOutput) {
                Intrinsics.checkNotNullParameter(userHostPort, (String)"userHostPort");
                Intrinsics.checkNotNullParameter((Object)combinedOutput, (String)"combinedOutput");
                return new ForbiddenExec(userHostPort, combinedOutput);
            }

            public static /* synthetic */ ForbiddenExec copy$default(ForbiddenExec forbiddenExec, Triple triple, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    triple = forbiddenExec.userHostPort;
                }
                if ((n & 2) != 0) {
                    string = forbiddenExec.combinedOutput;
                }
                return forbiddenExec.copy(triple, string);
            }

            @NotNull
            public String toString() {
                return "ForbiddenExec(userHostPort=" + this.userHostPort + ", combinedOutput=" + this.combinedOutput + ")";
            }

            public int hashCode() {
                int result = this.userHostPort.hashCode();
                result = result * 31 + this.combinedOutput.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ForbiddenExec)) {
                    return false;
                }
                ForbiddenExec forbiddenExec = (ForbiddenExec)other;
                if (!Intrinsics.areEqual(this.userHostPort, forbiddenExec.userHostPort)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.combinedOutput, (Object)forbiddenExec.combinedOutput);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B=\u0012\u001c\u0010\u0002\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\u0012\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0004H\u00c6\u0003JG\u0010\u0016\u001a\u00020\u00002\u001e\b\u0002\u0010\u0002\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0004H\u00d6\u0001R*\u0010\u0002\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0007\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\b\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0014\u0010\t\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ssh/fus/SshApplicationUsagesCollector$RemoteServerInfo$Known;", "Lcom/intellij/ssh/fus/SshApplicationUsagesCollector$RemoteServerInfo;", "userHostPort", "Lkotlin/Triple;", "", "", "Lcom/intellij/ssh/fus/UserHostPort;", "os", "arch", "combinedOutput", "<init>", "(Lkotlin/Triple;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getUserHostPort", "()Lkotlin/Triple;", "getOs", "()Ljava/lang/String;", "getArch", "getCombinedOutput", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "toString", "intellij.platform.ssh"})
        public static final class Known
        implements RemoteServerInfo {
            @NotNull
            private final Triple<String, String, Integer> userHostPort;
            @NotNull
            private final String os;
            @NotNull
            private final String arch;
            @NotNull
            private final String combinedOutput;

            public Known(@NotNull Triple<String, String, Integer> userHostPort, @NotNull String os, @NotNull String arch, @NotNull String combinedOutput) {
                Intrinsics.checkNotNullParameter(userHostPort, (String)"userHostPort");
                Intrinsics.checkNotNullParameter((Object)os, (String)"os");
                Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
                Intrinsics.checkNotNullParameter((Object)combinedOutput, (String)"combinedOutput");
                this.userHostPort = userHostPort;
                this.os = os;
                this.arch = arch;
                this.combinedOutput = combinedOutput;
            }

            @Override
            @NotNull
            public Triple<String, String, Integer> getUserHostPort() {
                return this.userHostPort;
            }

            @Override
            @NotNull
            public String getOs() {
                return this.os;
            }

            @Override
            @NotNull
            public String getArch() {
                return this.arch;
            }

            @Override
            @NotNull
            public String getCombinedOutput() {
                return this.combinedOutput;
            }

            @NotNull
            public final Triple<String, String, Integer> component1() {
                return this.userHostPort;
            }

            @NotNull
            public final String component2() {
                return this.os;
            }

            @NotNull
            public final String component3() {
                return this.arch;
            }

            @NotNull
            public final String component4() {
                return this.combinedOutput;
            }

            @NotNull
            public final Known copy(@NotNull Triple<String, String, Integer> userHostPort, @NotNull String os, @NotNull String arch, @NotNull String combinedOutput) {
                Intrinsics.checkNotNullParameter(userHostPort, (String)"userHostPort");
                Intrinsics.checkNotNullParameter((Object)os, (String)"os");
                Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
                Intrinsics.checkNotNullParameter((Object)combinedOutput, (String)"combinedOutput");
                return new Known(userHostPort, os, arch, combinedOutput);
            }

            public static /* synthetic */ Known copy$default(Known known, Triple triple, String string, String string2, String string3, int n, Object object) {
                if ((n & 1) != 0) {
                    triple = known.userHostPort;
                }
                if ((n & 2) != 0) {
                    string = known.os;
                }
                if ((n & 4) != 0) {
                    string2 = known.arch;
                }
                if ((n & 8) != 0) {
                    string3 = known.combinedOutput;
                }
                return known.copy(triple, string, string2, string3);
            }

            @NotNull
            public String toString() {
                return "Known(userHostPort=" + this.userHostPort + ", os=" + this.os + ", arch=" + this.arch + ", combinedOutput=" + this.combinedOutput + ")";
            }

            public int hashCode() {
                int result = this.userHostPort.hashCode();
                result = result * 31 + this.os.hashCode();
                result = result * 31 + this.arch.hashCode();
                result = result * 31 + this.combinedOutput.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Known)) {
                    return false;
                }
                Known known = (Known)other;
                if (!Intrinsics.areEqual(this.userHostPort, known.userHostPort)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.os, (Object)known.os)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.arch, (Object)known.arch)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.combinedOutput, (Object)known.combinedOutput);
            }
        }
    }

    @Service
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0019\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR!\u0010\u0013\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ssh/fus/SshApplicationUsagesCollector$SharedFields;", "", "<init>", "()V", "group", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getGroup", "()Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "configParser", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "Lcom/intellij/ssh/config/SshConnectionConfigService$Kind;", "getConfigParser", "()Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "customSshToolPath", "", "getCustomSshToolPath", "opensshVersion", "", "getOpensshVersion", "remoteServerInfo", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "getRemoteServerInfo", "()Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "remoteServerInfoFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lcom/intellij/ssh/fus/SshApplicationUsagesCollector$RemoteServerInfo;", "getRemoteServerInfoFlow", "()Lkotlinx/coroutines/flow/MutableSharedFlow;", "intellij.platform.ssh"})
    @SourceDebugExtension(value={"SMAP\nSshApplicationUsagesCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshApplicationUsagesCollector.kt\ncom/intellij/ssh/fus/SshApplicationUsagesCollector$SharedFields\n+ 2 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n*L\n1#1,490:1\n251#2:491\n*S KotlinDebug\n*F\n+ 1 SshApplicationUsagesCollector.kt\ncom/intellij/ssh/fus/SshApplicationUsagesCollector$SharedFields\n*L\n46#1:491\n*E\n"})
    public static final class SharedFields {
        @NotNull
        private final EventLogGroup group = new EventLogGroup("ssh", 6, null, 4, null);
        @NotNull
        private final EventId1<SshConnectionConfigService.Kind> configParser;
        @NotNull
        private final EventId1<Boolean> customSshToolPath;
        @NotNull
        private final EventId1<String> opensshVersion;
        @NotNull
        private final EventId2<String, String> remoteServerInfo;
        @NotNull
        private final MutableSharedFlow<RemoteServerInfo> remoteServerInfoFlow;

        /*
         * WARNING - void declaration
         */
        public SharedFields() {
            void name$iv;
            EventFields eventFields = EventFields.INSTANCE;
            String string = "kind";
            Function1 transform$iv = (Function1)configParser.1.INSTANCE;
            boolean $i$f$Enum = false;
            this.configParser = EventLogGroup.registerEvent$default((EventLogGroup)this.group, (String)"config.parser", (EventField)((EventField)new EnumEventField((String)name$iv, SshConnectionConfigService.Kind.class, null, transform$iv)), null, (int)4, null);
            this.customSshToolPath = EventLogGroup.registerEvent$default((EventLogGroup)this.group, (String)"custom.ssh.tool.path", (EventField)((EventField)EventFields.Enabled), null, (int)4, null);
            this.opensshVersion = EventLogGroup.registerEvent$default((EventLogGroup)this.group, (String)"openssh.version", (EventField)((EventField)EventFields.Version), null, (int)4, null);
            this.remoteServerInfo = EventLogGroup.registerEvent$default((EventLogGroup)this.group, (String)"ssh.remote.server.info", (EventField)((EventField)EventFields.String((String)"remote_os", (List)SshApplicationUsagesCollectorKt.access$getRemoteOsList$p())), (EventField)((EventField)EventFields.String((String)"remote_arch", (List)SshApplicationUsagesCollectorKt.access$getRemoteArchList$p())), null, (int)8, null);
            this.remoteServerInfoFlow = SharedFlowKt.MutableSharedFlow$default((int)0, (int)0, null, (int)7, null);
        }

        @NotNull
        public final EventLogGroup getGroup() {
            return this.group;
        }

        @NotNull
        public final EventId1<SshConnectionConfigService.Kind> getConfigParser() {
            return this.configParser;
        }

        @NotNull
        public final EventId1<Boolean> getCustomSshToolPath() {
            return this.customSshToolPath;
        }

        @NotNull
        public final EventId1<String> getOpensshVersion() {
            return this.opensshVersion;
        }

        @NotNull
        public final EventId2<String, String> getRemoteServerInfo() {
            return this.remoteServerInfo;
        }

        @NotNull
        public final MutableSharedFlow<RemoteServerInfo> getRemoteServerInfoFlow() {
            return this.remoteServerInfoFlow;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ssh/fus/SshApplicationUsagesCollector$SshConnectionListener;", "Lcom/intellij/ssh/ui/SshConnectionStateListener;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "authenticationFinished", "", "user", "", "host", "port", "", "connectionCreated", "session", "Lcom/intellij/ssh/SshSession;", "intellij.platform.ssh"})
    public static final class SshConnectionListener
    implements SshConnectionStateListener {
        @NotNull
        private final CoroutineScope coroutineScope;

        public SshConnectionListener(@NotNull CoroutineScope coroutineScope) {
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            this.coroutineScope = coroutineScope;
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, (CoroutineStart)CoroutineStart.UNDISPATCHED, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                int label;

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $i$f$serviceAsync = false;
                            v0 = ApplicationManager.getApplication();
                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getApplication(...)");
                            $this$serviceAsync$iv$iv = (ComponentManager)v0;
                            $i$f$serviceAsync = false;
                            this.label = 1;
                            v1 = ServicesKt.serviceAsync((ComponentManager)$this$serviceAsync$iv$iv, SharedFields.class, (Continuation)((Continuation)this));
                            if (v1 == var6_2) {
                                return var6_2;
                            }
                            ** GOTO lbl22
                        }
                        case 1: {
                            $i$f$serviceAsync = false;
                            $i$f$serviceAsync = false;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl22:
                            // 2 sources

                            fields = (SharedFields)v1;
                            cache = Caffeine.newBuilder().maximumSize(100L).build();
                            this.label = 2;
                            v2 = fields.getRemoteServerInfoFlow().collect(new FlowCollector((Cache<Triple<String, String, Integer>, Unit>)cache, fields){
                                final /* synthetic */ Cache<Triple<String, String, Integer>, Unit> $cache;
                                final /* synthetic */ SharedFields $fields;
                                {
                                    this.$cache = $cache;
                                    this.$fields = $fields;
                                }

                                public final Object emit(RemoteServerInfo info, Continuation<? super Unit> $completion) {
                                    if (this.$cache.asMap().put(info.getUserHostPort(), Unit.INSTANCE) == null) {
                                        EventId2<String, String> eventId2 = this.$fields.getRemoteServerInfo();
                                        String string = info.getOs().toLowerCase(Locale.ROOT);
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                                        String string2 = info.getArch().toLowerCase(Locale.ROOT);
                                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                                        eventId2.log((Object)string, (Object)string2);
                                    }
                                    return Unit.INSTANCE;
                                }
                            }, (Continuation)this);
                            if (v2 == var6_2) {
                                return var6_2;
                            }
                            ** GOTO lbl32
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl32:
                            // 2 sources

                            throw new KotlinNothingValueException();
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }

        @Override
        public void authenticationFinished(@NotNull String user, @NotNull String host, int port) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        }

        @Override
        public void connectionCreated(@NotNull SshSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(session, null){
                Object L$1;
                Object L$2;
                Object L$3;
                int I$0;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ SshSession $session;
                {
                    this.$session = $session;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$launch = (CoroutineScope)this.L$0;
                            $this$invokeSuspend_u24lambda_u240 = this.$session;
                            $i$a$-run-SshApplicationUsagesCollector$SshConnectionListener$connectionCreated$1$uhpTriple$1 = false;
                            uhpTriple = new Triple((Object)$this$invokeSuspend_u24lambda_u240.getUserName(), (Object)$this$invokeSuspend_u24lambda_u240.getHost(), (Object)Boxing.boxInt((int)$this$invokeSuspend_u24lambda_u240.getPort()));
                            user = (String)uhpTriple.component1();
                            host = (String)uhpTriple.component2();
                            port = ((Number)uhpTriple.component3()).intValue();
                            this.L$0 = $this$launch;
                            this.L$1 = uhpTriple;
                            this.L$2 = user;
                            this.L$3 = host;
                            this.I$0 = port;
                            this.label = 1;
                            v0 = DelayKt.delay-VtjQ1oo((long)(ApplicationManager.getApplication().isUnitTestMode() ? DurationKt.toDuration((int)500, (DurationUnit)DurationUnit.MILLISECONDS) : DurationKt.toDuration((int)3, (DurationUnit)DurationUnit.SECONDS)), (Continuation)((Continuation)this));
                            ** if (v0 != var11_2) goto lbl24
lbl23:
                            // 1 sources

                            return var11_2;
lbl24:
                            // 1 sources

                            ** GOTO lbl35
                        }
                        case 1: {
                            port = this.I$0;
                            host = (String)this.L$3;
                            user = (String)this.L$2;
                            uhpTriple = (Triple)this.L$1;
                            $this$launch = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl35:
                            // 2 sources

                            if (this.$session.isConnected()) ** GOTO lbl41
                            SshApplicationUsagesCollectorKt.access$getLOG$p().info(this.$session + " got disconnected quickly after connection. Won't collect any statistic from it.");
                            var7_8 = Unit.INSTANCE;
                            JobKt.cancelChildren$default((CoroutineContext)$this$launch.getCoroutineContext(), null, (int)1, null);
                            return var7_8;
lbl41:
                            // 2 sources

                            var8_12 = SshApplicationUsagesCollectorImpl.INSTANCE;
                            this.L$0 = $this$launch;
                            this.L$1 = user;
                            this.L$2 = host;
                            this.L$3 = null;
                            this.I$0 = port;
                            this.label = 2;
                            v1 = SshApplicationUsagesCollectorImpl.INSTANCE.fetchRemoteServerInfo((Triple<String, String, Integer>)uhpTriple, new SshApplicationUsagesCollectorImpl.ExecAndGetStdio((SshApplicationUsagesCollectorImpl)var8_12){
                                final /* synthetic */ SshApplicationUsagesCollectorImpl $tmp0;
                                {
                                    this.$tmp0 = $tmp0;
                                }

                                public final Object invoke(String p0, int p1, String p2, String p3, Continuation<? super SshApplicationUsagesCollectorImpl.ExecAndGetOutputResult> $completion) {
                                    return this.$tmp0.productionExecAndGetStdio$intellij_platform_ssh(p0, p1, p2, p3, $completion);
                                }

                                public final Function<?> getFunctionDelegate() {
                                    return (Function)new FunctionReferenceImpl(5, (Object)this.$tmp0, SshApplicationUsagesCollectorImpl.class, "productionExecAndGetStdio", "productionExecAndGetStdio$intellij_platform_ssh(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", 0);
                                }

                                public final boolean equals(Object other) {
                                    return other instanceof SshApplicationUsagesCollectorImpl.ExecAndGetStdio ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                                }

                                public final int hashCode() {
                                    return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
                                }
                            }, (Continuation<? super RemoteServerInfo>)((Continuation)this));
                            ** if (v1 != var11_2) goto lbl51
lbl50:
                            // 1 sources

                            return var11_2;
lbl51:
                            // 1 sources

                            ** GOTO lbl61
                        }
                        case 2: {
                            port = this.I$0;
                            host = (String)this.L$2;
                            user = (String)this.L$1;
                            $this$launch = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl61:
                            // 2 sources

                            if ((var8_12 = (remoteServerInfo = (RemoteServerInfo)v1)) != null && !(var8_12 instanceof RemoteServerInfo.Known) && !(var8_12 instanceof RemoteServerInfo.ForbiddenExec)) {
                                if (var8_12 instanceof RemoteServerInfo.FailedToParse) {
                                    SshApplicationUsagesCollectorKt.access$getLOG$p().error("Failed to parse OS and arch of an SSH server.\n" + ((RemoteServerInfo.FailedToParse)remoteServerInfo).getCombinedOutput());
                                } else {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                            if (remoteServerInfo == null) ** GOTO lbl132
                            $i$f$serviceAsync = false;
                            v2 = ApplicationManager.getApplication();
                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getApplication(...)");
                            $this$serviceAsync$iv$iv = (ComponentManager)v2;
                            $i$f$serviceAsync = false;
                            this.L$0 = $this$launch;
                            this.L$1 = user;
                            this.L$2 = host;
                            this.L$3 = remoteServerInfo;
                            this.I$0 = port;
                            this.label = 3;
                            v3 = ServicesKt.serviceAsync((ComponentManager)$this$serviceAsync$iv$iv, SharedFields.class, (Continuation)((Continuation)this));
                            ** if (v3 != var11_2) goto lbl81
lbl80:
                            // 1 sources

                            return var11_2;
lbl81:
                            // 1 sources

                            ** GOTO lbl96
                        }
                        case 3: {
                            $i$f$serviceAsync = false;
                            $i$f$serviceAsync = false;
                            port = this.I$0;
                            remoteServerInfo = (RemoteServerInfo)this.L$3;
                            host = (String)this.L$2;
                            user = (String)this.L$1;
                            $this$launch = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl96:
                            // 2 sources

                            this.L$0 = $this$launch;
                            this.L$1 = user;
                            this.L$2 = host;
                            this.L$3 = null;
                            this.I$0 = port;
                            this.label = 4;
                            v4 = ((SharedFields)v3).getRemoteServerInfoFlow().emit((Object)remoteServerInfo, (Continuation)this);
                            ** if (v4 != var11_2) goto lbl105
lbl104:
                            // 1 sources

                            return var11_2;
lbl105:
                            // 1 sources

                            ** GOTO lbl132
                        }
                        case 4: {
                            port = this.I$0;
                            host = (String)this.L$2;
                            user = (String)this.L$1;
                            $this$launch = (CoroutineScope)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v4 = $result;
                                ** GOTO lbl132
                            }
                            catch (Throwable err) {
                                var8_15 = err;
                                if (var8_15 instanceof ControlFlowException || var8_15 instanceof CancellationException) {
                                    throw err;
                                }
                                if (!(var8_15 instanceof IOException) && !(var8_15 instanceof SshException)) ** GOTO lbl123
                                SshApplicationUsagesCollectorKt.access$getLOG$p().info("Failed to get stats about just connected SSH server " + user + "@" + host + ":" + port + " due to: " + err);
                                ** GOTO lbl132
lbl123:
                                // 1 sources

                                if (!(var8_15 instanceof Exception)) ** GOTO lbl126
                                SshApplicationUsagesCollectorKt.access$getLOG$p().error("Failed to get stats about just connected SSH server " + user + "@" + host + ":" + port + " due to: " + err);
                                ** GOTO lbl132
lbl126:
                                // 1 sources

                                throw err;
                            }
                        }
                        catch (Throwable var7_11) {
                            throw var7_11;
                        }
                        {
                            finally {
                                JobKt.cancelChildren$default((CoroutineContext)$this$launch.getCoroutineContext(), null, (int)1, null);
                            }
lbl132:
                            // 5 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }
}

