/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;

public class OrdinalSuffixFilter
extends RuleFilter {
    private static final Pattern PATTERN = Pattern.compile(".*(11|12|13)");
    private static final Pattern NON_DIGITS = Pattern.compile("[^0-9]");

    @Override
    @Nullable
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens, List<Integer> tokenPositions) throws IOException {
        String ordinal = NON_DIGITS.matcher(match.getSuggestedReplacements().get(0)).replaceAll("");
        if (PATTERN.matcher(ordinal).matches()) {
            match.setSuggestedReplacement(ordinal + "th");
        } else if (ordinal.endsWith("1")) {
            match.setSuggestedReplacement(ordinal + "st");
        } else if (ordinal.endsWith("2")) {
            match.setSuggestedReplacement(ordinal + "nd");
        } else if (ordinal.endsWith("3")) {
            match.setSuggestedReplacement(ordinal + "rd");
        } else {
            match.setSuggestedReplacement(ordinal + "th");
        }
        return match;
    }
}

