/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.jcodings.Encoding;
import org.jcodings.IntHolder;
import org.jcodings.specific.ASCIIEncoding;
import org.joni.Config;
import org.joni.Option;
import org.joni.Regex;
import org.joni.Region;
import org.joni.exception.TimeoutException;

public abstract class Matcher
extends IntHolder {
    static final InterruptedException INTERRUPTED_EXCEPTION = new InterruptedException();
    static final InterruptedException TIMEOUT_EXCEPTION = new TimeoutException();
    public static final int FAILED = -1;
    public static final int INTERRUPTED = -2;
    protected final Regex regex;
    protected final Encoding enc;
    protected final byte[] bytes;
    protected final int str;
    protected final int end;
    protected int msaStart;
    protected int msaOptions;
    protected final Region msaRegion;
    protected int msaBestLen;
    protected int msaBestS;
    protected int msaGpos;
    protected int msaBegin;
    protected int msaEnd;
    protected long timeout;
    protected long startTime;
    int low;
    int high;
    private byte[] icbuf;

    Matcher(Regex regex2, Region region, byte[] bytes, int p, int end) {
        this(regex2, region, bytes, p, end, -1L);
    }

    Matcher(Regex regex2, Region region, byte[] bytes, int p, int end, long timeout) {
        this.regex = regex2;
        this.enc = regex2.enc;
        this.bytes = bytes;
        this.str = p;
        this.end = end;
        this.msaRegion = region;
        this.timeout = timeout;
    }

    protected abstract int matchAt(int var1, int var2, int var3, boolean var4) throws InterruptedException;

    protected abstract void stateCheckBuffInit(int var1, int var2, int var3);

    protected abstract void stateCheckBuffClear();

    public abstract void interrupt();

    public final Region getRegion() {
        return this.msaRegion;
    }

    public final Region getEagerRegion() {
        return this.msaRegion != null ? this.msaRegion : Region.newRegion(this.msaBegin, this.msaEnd);
    }

    public final int getBegin() {
        return this.msaBegin;
    }

    public final int getEnd() {
        return this.msaEnd;
    }

    protected final void msaInit(int option, int start, int gpos) {
        this.msaOptions = option;
        this.msaStart = start;
        this.msaGpos = gpos;
        if (Config.USE_FIND_LONGEST_SEARCH_ALL_OF_RANGE) {
            this.msaBestLen = -1;
        }
    }

    public final int match(int at, int range, int option) {
        try {
            return this.matchCommon(at, range, option, false);
        }
        catch (InterruptedException ex) {
            return -2;
        }
    }

    public final int matchInterruptible(int at, int range, int option) throws InterruptedException {
        return this.matchCommon(at, range, option, true);
    }

    private final int matchCommon(int at, int range, int option, boolean interrupt) throws InterruptedException {
        this.msaInit(option, at, at);
        if (Config.USE_CEC) {
            int offset = at = this.str;
            this.stateCheckBuffInit(this.end - this.str, offset, this.regex.numCombExpCheck);
        }
        int prev = this.enc.prevCharHead(this.bytes, this.str, at, this.end);
        if (Config.USE_MATCH_RANGE_MUST_BE_INSIDE_OF_SPECIFIED_RANGE) {
            return this.matchAt(this.end, at, prev, interrupt);
        }
        return this.matchAt(range, at, prev, interrupt);
    }

    private final boolean forwardSearchRange(byte[] bytes, int str, int end, int s, int range, IntHolder lowPrev) {
        block22: {
            int pprev = -1;
            int p = s;
            if (Config.DEBUG_SEARCH) {
                this.debugForwardSearchRange(str, end, s, range);
            }
            if (this.regex.dMin > 0) {
                if (this.enc.isSingleByte()) {
                    p += this.regex.dMin;
                } else {
                    int q = p + this.regex.dMin;
                    while (p < q && p < end) {
                        p += this.enc.length(bytes, p, end);
                    }
                }
            }
            block5: while (true) {
                if (Config.DEBUG_SEARCH) {
                    Matcher.debugSearch(this.regex.forward.getName(), p, end, range);
                }
                if ((p = this.regex.forward.search(this, bytes, p, end, range)) == -1 || p >= range) break block22;
                if (p - this.regex.dMin < s) {
                    pprev = p;
                    p += this.enc.length(bytes, p, end);
                    continue;
                }
                if (this.regex.subAnchor == 0) break;
                switch (this.regex.subAnchor) {
                    case 2: {
                        int prev;
                        if (p == str || this.enc.isNewLine(bytes, prev = this.enc.prevCharHead(bytes, pprev != -1 ? pprev : str, p, end), end)) break block5;
                        pprev = p;
                        p += this.enc.length(bytes, p, end);
                        continue block5;
                    }
                    case 32: {
                        int prev;
                        if (p == end) {
                            if (Config.USE_NEWLINE_AT_END_OF_STRING_HAS_EMPTY_LINE || (prev = this.enc.prevCharHead(bytes, pprev != -1 ? pprev : str, p, end)) == -1 || !this.enc.isNewLine(bytes, prev, end)) break block5;
                            pprev = p;
                            p += this.enc.length(bytes, p, end);
                            continue block5;
                        }
                        if (this.enc.isNewLine(bytes, p, end)) break block5;
                        pprev = p;
                        p += this.enc.length(bytes, p, end);
                        continue block5;
                    }
                }
                break;
            }
            if (this.regex.dMax == 0) {
                this.low = p;
                if (lowPrev != null) {
                    lowPrev.value = this.low > s ? this.enc.prevCharHead(bytes, s, p, end) : this.enc.prevCharHead(bytes, pprev != -1 ? pprev : str, p, end);
                }
            } else if (this.regex.dMax != Integer.MAX_VALUE) {
                this.low = p - this.regex.dMax;
                if (this.low > s) {
                    this.low = this.enc.rightAdjustCharHeadWithPrev(bytes, s, this.low, end, lowPrev);
                    if (lowPrev != null && lowPrev.value == -1) {
                        lowPrev.value = this.enc.prevCharHead(bytes, pprev != -1 ? pprev : s, this.low, end);
                    }
                } else if (lowPrev != null) {
                    lowPrev.value = this.enc.prevCharHead(bytes, pprev != -1 ? pprev : str, this.low, end);
                }
            }
            this.high = p - this.regex.dMin;
            if (Config.DEBUG_SEARCH) {
                this.debugForwardSearchRangeSuccess(str, this.low, this.high);
            }
            return true;
        }
        return false;
    }

    private final boolean backwardSearchRange(byte[] bytes, int str, int end, int s, int range, int adjrange) {
        range += this.regex.dMin;
        int p = s;
        block4: while ((p = this.regex.backward.search(this, bytes, range, adjrange, end, p, s, range)) != -1) {
            if (this.regex.subAnchor != 0) {
                switch (this.regex.subAnchor) {
                    case 2: {
                        int prev;
                        if (p == str || this.enc.isNewLine(bytes, prev = this.enc.prevCharHead(bytes, str, p, end), end)) break;
                        p = prev;
                        continue block4;
                    }
                    case 32: {
                        int prev;
                        if (p == end) {
                            if (Config.USE_NEWLINE_AT_END_OF_STRING_HAS_EMPTY_LINE) break;
                            prev = this.enc.prevCharHead(bytes, adjrange, p, end);
                            if (prev == -1) {
                                return false;
                            }
                            if (!this.enc.isNewLine(bytes, prev, end)) break;
                            p = prev;
                            continue block4;
                        }
                        if (this.enc.isNewLine(bytes, p, end)) break;
                        if ((p = this.enc.prevCharHead(bytes, adjrange, p, end)) != -1) continue block4;
                        return false;
                    }
                }
            }
            if (this.regex.dMax != Integer.MAX_VALUE) {
                this.low = p - this.regex.dMax;
                this.high = p - this.regex.dMin;
                this.high = this.enc.rightAdjustCharHead(bytes, adjrange, this.high, end);
            }
            if (Config.DEBUG_SEARCH) {
                this.debugBackwardSearchRange(str, this.low, this.high);
            }
            return true;
        }
        if (Config.DEBUG_SEARCH) {
            Config.log.println("backward_search_range: fail.");
        }
        return false;
    }

    private boolean matchCheck(int upperRange, int s, int prev, boolean interrupt) throws InterruptedException {
        return Config.USE_MATCH_RANGE_MUST_BE_INSIDE_OF_SPECIFIED_RANGE ? (Config.USE_FIND_LONGEST_SEARCH_ALL_OF_RANGE ? this.matchAt(upperRange, s, prev, interrupt) != -1 && !Option.isFindLongest(this.regex.options) : this.matchAt(upperRange, s, prev, interrupt) != -1) : (Config.USE_FIND_LONGEST_SEARCH_ALL_OF_RANGE ? this.matchAt(this.end, s, prev, interrupt) != -1 && !Option.isFindLongest(this.regex.options) : this.matchAt(this.end, s, prev, interrupt) != -1);
    }

    public final int search(int start, int range, int option) {
        try {
            return this.searchCommon(start, start, range, option, false);
        }
        catch (InterruptedException ex) {
            return -2;
        }
    }

    public final int search(int gpos, int start, int range, int option) {
        try {
            return this.searchCommon(gpos, start, range, option, false);
        }
        catch (InterruptedException ex) {
            return -2;
        }
    }

    public final int searchInterruptible(int start, int range, int option) throws InterruptedException {
        return this.searchCommon(start, start, range, option, true);
    }

    public final int searchInterruptible(int gpos, int start, int range, int option) throws InterruptedException {
        return this.searchCommon(gpos, start, range, option, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int searchCommon(int gpos, int start, int range, int option, boolean interrupt) throws InterruptedException {
        int prev;
        if (this.timeout != -1L) {
            this.startTime = System.nanoTime();
        }
        int origStart = start;
        int origRange = range;
        if (Config.DEBUG_SEARCH) {
            this.debugSearch(this.str, this.end, start, range);
        }
        if (start > this.end || start < this.str) {
            return -1;
        }
        if (this.regex.anchor != 0 && this.str < this.end) {
            int minSemiEnd;
            int maxSemiEnd;
            if ((this.regex.anchor & 4) != 0) {
                if (range > start) {
                    if (gpos > start) {
                        if (gpos < range) {
                            range = gpos + 1;
                        }
                    } else {
                        range = start + 1;
                    }
                } else {
                    range = start;
                }
            } else if ((this.regex.anchor & 1) != 0) {
                if (range > start) {
                    if (start != this.str) {
                        return -1;
                    }
                    range = this.str + 1;
                } else {
                    if (range > this.str) return -1;
                    start = this.str;
                    range = this.str;
                }
            } else if ((this.regex.anchor & 8) != 0) {
                maxSemiEnd = this.end;
                minSemiEnd = maxSemiEnd;
                if (this.endBuf(start, range, minSemiEnd, maxSemiEnd)) {
                    return -1;
                }
            } else if ((this.regex.anchor & 0x10) != 0) {
                int preEnd = this.enc.stepBack(this.bytes, this.str, this.end, this.end, 1);
                maxSemiEnd = this.end;
                if (this.enc.isNewLine(this.bytes, preEnd, this.end) ? (minSemiEnd = preEnd) > this.str && start <= minSemiEnd && this.endBuf(start, range, minSemiEnd, maxSemiEnd) : this.endBuf(start, range, minSemiEnd = this.end, maxSemiEnd)) {
                    return -1;
                }
            } else if ((this.regex.anchor & 0x8000) != 0) {
                if (range > start) {
                    if (gpos > start) {
                        if (gpos < range) {
                            range = gpos + 1;
                        }
                    } else {
                        range = start + 1;
                    }
                } else {
                    range = start;
                }
            }
        } else if (this.str == this.end) {
            if (Config.DEBUG_SEARCH) {
                Config.log.println("onig_search: empty string.");
            }
            if (this.regex.thresholdLength != 0) return -1;
            int s = start = this.str;
            int prev2 = -1;
            this.msaInit(option, start, start);
            if (Config.USE_CEC) {
                this.stateCheckBuffClear();
            }
            if (!this.matchCheck(this.end, s, prev2, interrupt)) return this.mismatch();
            return this.match(s);
        }
        if (Config.DEBUG_SEARCH) {
            this.debugSearch(this.str, this.end, start, range);
        }
        this.msaInit(option, origStart, gpos);
        if (Config.USE_CEC) {
            int offset = Math.min(start, range) - this.str;
            this.stateCheckBuffInit(this.end - this.str, offset, this.regex.numCombExpCheck);
        }
        int s = start;
        if (range > start) {
            int prev3 = s > this.str ? this.enc.prevCharHead(this.bytes, this.str, s, this.end) : 0;
            if (this.regex.forward != null) {
                int schRange = range;
                if (this.regex.dMax != 0) {
                    if (this.regex.dMax == Integer.MAX_VALUE) {
                        schRange = this.end;
                    } else if ((schRange += this.regex.dMax) > this.end) {
                        schRange = this.end;
                    }
                }
                if (this.end - start < this.regex.thresholdLength) {
                    return this.mismatch();
                }
                if (this.regex.dMax != Integer.MAX_VALUE) {
                    do {
                        if (!this.forwardSearchRange(this.bytes, this.str, this.end, s, schRange, this)) {
                            return this.mismatch();
                        }
                        if (s < this.low) {
                            s = this.low;
                            prev3 = this.value;
                        }
                        while (s <= this.high) {
                            if (this.matchCheck(origRange, s, prev3, interrupt)) {
                                return this.match(s);
                            }
                            prev3 = s;
                            s += this.enc.length(this.bytes, s, this.end);
                        }
                    } while (s < range);
                    return this.mismatch();
                }
                if (!this.forwardSearchRange(this.bytes, this.str, this.end, s, schRange, null)) {
                    return this.mismatch();
                }
                if ((this.regex.anchor & 0x4000) != 0) {
                    do {
                        if (this.matchCheck(origRange, s, prev3, interrupt)) {
                            return this.match(s);
                        }
                        prev3 = s;
                        s += this.enc.length(this.bytes, s, this.end);
                        if ((this.regex.anchor & 0x1800) != 0) continue;
                        while (!this.enc.isNewLine(this.bytes, prev3, this.end) && s < range) {
                            prev3 = s;
                            s += this.enc.length(this.bytes, s, this.end);
                        }
                    } while (s < range);
                    return this.mismatch();
                }
            }
            do {
                if (this.matchCheck(origRange, s, prev3, interrupt)) {
                    return this.match(s);
                }
                prev3 = s;
            } while ((s += this.enc.length(this.bytes, s, this.end)) < range);
            if (s != range || !this.matchCheck(origRange, s, prev3, interrupt)) return this.mismatch();
            return this.match(s);
        }
        if (Config.USE_MATCH_RANGE_MUST_BE_INSIDE_OF_SPECIFIED_RANGE && origStart < this.end) {
            origStart += this.enc.length(this.bytes, origStart, this.end);
        }
        if (this.regex.backward != null) {
            int schStart;
            int adjrange = range < this.end ? this.enc.leftAdjustCharHead(this.bytes, this.str, range, this.end) : this.end;
            if (this.regex.dMax != Integer.MAX_VALUE && this.end - range >= this.regex.thresholdLength) {
                do {
                    if ((schStart = s + this.regex.dMax) > this.end) {
                        schStart = this.end;
                    }
                    if (!this.backwardSearchRange(this.bytes, this.str, this.end, schStart, range, adjrange)) {
                        return this.mismatch();
                    }
                    if (s > this.high) {
                        s = this.high;
                    }
                    while (s != -1 && s >= this.low) {
                        int prev4 = this.enc.prevCharHead(this.bytes, this.str, s, this.end);
                        if (this.matchCheck(origStart, s, prev4, interrupt)) {
                            return this.match(s);
                        }
                        s = prev4;
                    }
                } while (s >= range);
                return this.mismatch();
            }
            if (this.end - range < this.regex.thresholdLength) {
                return this.mismatch();
            }
            schStart = s;
            if (this.regex.dMax != 0) {
                schStart = this.regex.dMax == Integer.MAX_VALUE ? this.end : ((schStart += this.regex.dMax) > this.end ? this.end : this.enc.leftAdjustCharHead(this.bytes, start, schStart, this.end));
            }
            if (!this.backwardSearchRange(this.bytes, this.str, this.end, schStart, range, adjrange)) {
                return this.mismatch();
            }
        }
        do {
            if (!this.matchCheck(origStart, s, prev = this.enc.prevCharHead(this.bytes, this.str, s, this.end), interrupt)) continue;
            return this.match(s);
        } while ((s = prev) >= range);
        return this.mismatch();
    }

    private final boolean endBuf(int start, int range, int minSemiEnd, int maxSemiEnd) {
        if (maxSemiEnd - this.str < this.regex.anchorDmin) {
            return true;
        }
        if (range > start) {
            if (minSemiEnd - start > this.regex.anchorDmax) {
                start = minSemiEnd - this.regex.anchorDmax;
                start = start < this.end ? this.enc.rightAdjustCharHead(this.bytes, this.str, start, this.end) : this.enc.prevCharHead(this.bytes, this.str, this.end, this.end);
            }
            if (maxSemiEnd - (range - 1) < this.regex.anchorDmin) {
                range = maxSemiEnd - this.regex.anchorDmin + 1;
            }
            if (start >= range) {
                return true;
            }
        } else {
            if (minSemiEnd - range > this.regex.anchorDmax) {
                range = minSemiEnd - this.regex.anchorDmax;
            }
            if (maxSemiEnd - start < this.regex.anchorDmin) {
                start = maxSemiEnd - this.regex.anchorDmin;
                start = this.enc.leftAdjustCharHead(this.bytes, this.str, start, this.end);
            }
            if (range > start) {
                return true;
            }
        }
        return false;
    }

    private final int match(int s) {
        return s - this.str;
    }

    private final int mismatch() {
        if (Config.USE_FIND_LONGEST_SEARCH_ALL_OF_RANGE && this.msaBestLen >= 0) {
            int s = this.msaBestS;
            return this.match(s);
        }
        return -1;
    }

    protected final byte[] icbuf() {
        return this.icbuf == null ? (this.icbuf = new byte[18]) : this.icbuf;
    }

    static boolean isMbcAsciiWord(Encoding enc, byte[] bytes, int p, int end) {
        return ASCIIEncoding.INSTANCE.isCodeCType(enc.mbcToCode(bytes, p, end), 12);
    }

    private final void debugForwardSearchRange(int str, int end, int s, int range) {
        if (Config.DEBUG_SEARCH) {
            Config.log.println("forward_search_range: str: " + str + ", end: " + end + ", s: " + s + ", range: " + range);
        }
    }

    private final void debugForwardSearchRangeSuccess(int str, int low, int high) {
        if (Config.DEBUG_SEARCH) {
            Config.log.println("forward_search_range success: low: " + (low - str) + ", high: " + (high - str) + ", dmin: " + this.regex.dMin + ", dmax: " + this.regex.dMax);
        }
    }

    private final void debugSearch(int str, int end, int start, int range) {
        if (Config.DEBUG_SEARCH) {
            Config.log.println("onig_search (entry point): str: " + str + ", end: " + (end - str) + ", start: " + (start - str) + ", range " + (range - str));
        }
    }

    private final void debugBackwardSearchRange(int str, int low, int high) {
        if (Config.DEBUG_SEARCH) {
            Config.log.println("backward_search_range: low: " + (low - str) + ", high: " + (high - str));
        }
    }

    static void debugSearch(String name, int textP, int textEnd, int textRange) {
        Config.log.println(name + ": text: " + textP + ", text_end: " + textEnd + ", text_range: " + textRange);
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

