/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryKeyDescriptor;
import com.intellij.openapi.util.registry.RegistryValueKt;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.util.registry.RegistryValueSource;
import com.intellij.openapi.util.registry.ValueWithSource;
import com.intellij.ui.ColorHexUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.MissingResourceException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B(\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0007J\r\u0010\u001e\u001a\u00070\u0005\u00a2\u0006\u0002\b\u001fH\u0016J\b\u0010 \u001a\u00020\u0011H\u0016J\u0006\u0010!\u001a\u00020\u0016J\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050$J\u001a\u0010(\u001a\u00020*2\b\u0010%\u001a\u0004\u0018\u00010\u00052\u0006\u0010+\u001a\u00020\u001dH\u0007J\u000e\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\u0005J\u0006\u0010.\u001a\u00020\u0019J\b\u0010/\u001a\u00020\u0019H\u0002J\u0012\u00100\u001a\u0004\u0018\u0001012\b\u00102\u001a\u0004\u0018\u000101J\b\u00105\u001a\u00020\u0011H\u0016J\b\u00106\u001a\u00020\u0011H\u0016J\u0017\u00109\u001a\u0004\u0018\u00010\u00052\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0002J\u0017\u0010:\u001a\u0004\u0018\u00010\u00052\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0007J\u0015\u0010;\u001a\u00020\u00052\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0002J\u0015\u0010<\u001a\u00020*2\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0002J\u000e\u0010=\u001a\u00020*2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010=\u001a\u00020*2\u0006\u0010\u0010\u001a\u00020\u0016J\u0010\u0010=\u001a\u00020*2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0018\u0010=\u001a\u00020*2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u001dH\u0017J\u0016\u0010=\u001a\u00020*2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010>\u001a\u00020?J\u0016\u0010=\u001a\u00020*2\u0006\u0010\u0010\u001a\u00020\u00162\u0006\u0010>\u001a\u00020?J\u0018\u0010=\u001a\u00020*2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010>\u001a\u00020?H\u0007J\u0006\u0010@\u001a\u00020*J\u0016\u0010A\u001a\u00020*2\u0006\u0010B\u001a\u00020\u000f2\u0006\u0010C\u001a\u00020?J\u0016\u0010A\u001a\u00020*2\u0006\u0010B\u001a\u00020\u000f2\u0006\u0010D\u001a\u00020EJ\r\u0010F\u001a\u00020*H\u0000\u00a2\u0006\u0002\bGJ\b\u0010I\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0011\u0010\"\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0013R2\u0010&\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u001f2\r\u0010%\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u001f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010\f\"\u0004\b(\u0010)R\u0019\u00103\u001a\u00070\u0005\u00a2\u0006\u0002\b\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u0010\fR\u0013\u00107\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b8\u0010\fR\u0014\u0010H\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010\u0013\u00a8\u0006J"}, d2={"Lcom/intellij/openapi/util/registry/RegistryValue;", "", "registry", "Lcom/intellij/openapi/util/registry/Registry;", "key", "", "Lorg/jetbrains/annotations/NonNls;", "keyDescriptor", "Lcom/intellij/openapi/util/registry/RegistryKeyDescriptor;", "<init>", "(Lcom/intellij/openapi/util/registry/Registry;Ljava/lang/String;Lcom/intellij/openapi/util/registry/RegistryKeyDescriptor;)V", "getKey", "()Ljava/lang/String;", "listeners", "", "Lcom/intellij/openapi/util/registry/RegistryValueListener;", "value", "", "isChangedSinceAppStart", "()Z", "stringCachedValue", "intCachedValue", "", "Ljava/lang/Integer;", "doubleCachedValue", "", "booleanCachedValue", "Ljava/lang/Boolean;", "getSource", "Lcom/intellij/openapi/util/registry/RegistryValueSource;", "asString", "Lcom/intellij/openapi/util/NlsSafe;", "asBoolean", "asInteger", "isMultiValue", "asOptions", "", "selected", "selectedOption", "getSelectedOption", "setSelectedOption", "(Ljava/lang/String;)V", "", "source", "isOptionEnabled", "option", "asDouble", "computeDouble", "asColor", "Ljava/awt/Color;", "defaultValue", "description", "getDescription", "isRestartRequired", "isChangedFromDefault", "pluginId", "getPluginId", "getAsValue", "resolveNotRequiredValue", "resolveRequiredValue", "checkIsLoaded", "setValue", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "resetToDefault", "addListener", "listener", "parent", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "resetCache", "resetCache$intellij_platform_util", "isBoolean", "toString", "intellij.platform.util"})
@SourceDebugExtension(value={"SMAP\nRegistryValue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegistryValue.kt\ncom/intellij/openapi/util/registry/RegistryValue\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,319:1\n739#2,9:320\n739#2,9:329\n1#3:338\n*S KotlinDebug\n*F\n+ 1 RegistryValue.kt\ncom/intellij/openapi/util/registry/RegistryValue\n*L\n81#1:320,9\n147#1:329,9\n*E\n"})
public class RegistryValue {
    @NotNull
    private final Registry registry;
    @NotNull
    private final String key;
    @Nullable
    private final RegistryKeyDescriptor keyDescriptor;
    @NotNull
    private final List<RegistryValueListener> listeners;
    private boolean isChangedSinceAppStart;
    @Nullable
    private String stringCachedValue;
    @Nullable
    private Integer intCachedValue;
    private double doubleCachedValue;
    @Nullable
    private Boolean booleanCachedValue;

    @ApiStatus.Internal
    public RegistryValue(@NotNull Registry registry, @NotNull String key, @Nullable RegistryKeyDescriptor keyDescriptor) {
        Intrinsics.checkNotNullParameter(registry, "registry");
        Intrinsics.checkNotNullParameter(key, "key");
        this.registry = registry;
        this.key = key;
        this.keyDescriptor = keyDescriptor;
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue(list, "createLockFreeCopyOnWriteList(...)");
        this.listeners = list;
        this.doubleCachedValue = Double.NaN;
    }

    @NotNull
    public final String getKey() {
        return this.key;
    }

    public final boolean isChangedSinceAppStart() {
        return this.isChangedSinceAppStart;
    }

    @ApiStatus.Experimental
    @Nullable
    public final RegistryValueSource getSource() {
        ValueWithSource valueWithSource = this.registry.getStoredProperties().get(this.key);
        return valueWithSource != null ? valueWithSource.getSource() : null;
    }

    @NotNull
    public String asString() {
        String result2 = this.stringCachedValue;
        if (result2 == null) {
            this.stringCachedValue = result2 = this.resolveRequiredValue(this.key);
        }
        return result2;
    }

    public boolean asBoolean() {
        Boolean result2 = this.booleanCachedValue;
        if (result2 == null) {
            this.booleanCachedValue = result2 = Boolean.valueOf(Boolean.parseBoolean(this.resolveRequiredValue(this.key)));
        }
        return result2;
    }

    public final int asInteger() {
        Integer result2 = this.intCachedValue;
        if (result2 == null) {
            Integer n;
            try {
                n = Integer.parseInt(this.resolveRequiredValue(this.key));
            }
            catch (NumberFormatException e) {
                n = Integer.parseInt(this.registry.getBundleValue$intellij_platform_util(this.key, this.keyDescriptor));
            }
            this.intCachedValue = result2 = n;
        }
        return result2;
    }

    public final boolean isMultiValue() {
        return this.getSelectedOption() != null;
    }

    @NotNull
    public final List<String> asOptions() {
        String value = this.registry.getBundleValue$intellij_platform_util(this.key, this.keyDescriptor);
        if (StringsKt.startsWith$default((CharSequence)value, '[', false, 2, null) && StringsKt.endsWith$default((CharSequence)value, ']', false, 2, null)) {
            List<String> list;
            String string = value.substring(1, value.length() - 1);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            String[] stringArray = new String[]{"|"};
            List $this$dropLastWhile$iv = StringsKt.split$default((CharSequence)string, stringArray, false, 0, 6, null);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take($this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            return list;
        }
        return CollectionsKt.emptyList();
    }

    @Nullable
    public final String getSelectedOption() {
        String value = this.asString();
        int length = value.length();
        if (length < 3 || value.charAt(0) != '[' || value.charAt(length - 1) != ']') {
            return null;
        }
        int pos = 1;
        while (pos < length) {
            int end = StringsKt.indexOf$default((CharSequence)value, '|', pos, false, 4, null);
            if (end == -1) {
                end = length - 1;
            }
            if (value.charAt(end - 1) == '*') {
                String string = value.substring(pos, end - 1);
                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                return string;
            }
            pos = end + 1;
        }
        return null;
    }

    public final void setSelectedOption(@Nullable String selected) {
        this.setSelectedOption(selected, RegistryValueSource.SYSTEM);
    }

    @ApiStatus.Experimental
    public final void setSelectedOption(@Nullable String selected, @NotNull RegistryValueSource source) {
        Intrinsics.checkNotNullParameter((Object)source, "source");
        List options = CollectionsKt.toMutableList((Collection)this.asOptions());
        Iterator iterator2 = ((Iterable)options).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            String option = (String)iterator2.next();
            char[] cArray = new char[]{'*'};
            String v = StringsKt.trimEnd(option, cArray);
            options.set(i, v);
            if (!Intrinsics.areEqual(v, selected)) continue;
            options.set(i, v + '*');
        }
        this.setValue('[' + CollectionsKt.joinToString$default(options, "|", null, null, 0, null, null, 62, null) + ']', source);
    }

    public final boolean isOptionEnabled(@NotNull String option) {
        Intrinsics.checkNotNullParameter(option, "option");
        return Intrinsics.areEqual(this.getSelectedOption(), option);
    }

    public final double asDouble() {
        double result2 = this.doubleCachedValue;
        if (Double.isNaN(result2)) {
            this.doubleCachedValue = result2 = this.computeDouble();
        }
        return result2;
    }

    private final double computeDouble() {
        double d;
        Object object = this.resolveNotRequiredValue(this.key);
        if (object != null && (object = StringsKt.toDoubleOrNull((String)object)) != null) {
            d = (Double)object;
        } else {
            Object object2 = this.keyDescriptor;
            if (object2 != null && (object2 = ((RegistryKeyDescriptor)object2).getDefaultValue()) != null) {
                d = Double.parseDouble((String)object2);
            } else {
                String string = this.registry.getBundleValueOrNull(this.key);
                Double d2 = string != null ? Double.valueOf(Double.parseDouble(string)) : null;
                d = d2 != null ? d2 : 0.0;
            }
        }
        return d;
    }

    @Nullable
    public final Color asColor(@Nullable Color defaultValue) {
        List rgb;
        List list;
        String string = this.getAsValue(this.key);
        if (string == null) {
            return defaultValue;
        }
        String s = string;
        Color color = ColorHexUtil.fromHex(s, null);
        if (color != null && (StringsKt.endsWith$default(this.key, ".color", false, 2, null) || StringsKt.endsWith$default(this.key, ".color.dark", false, 2, null) || StringsKt.endsWith$default(this.key, ".color.light", false, 2, null))) {
            return color;
        }
        char[] cArray = new char[]{','};
        List $this$dropLastWhile$iv = StringsKt.split$default((CharSequence)s, cArray, false, 0, 6, null);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take($this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                break;
            }
        } else {
            list = rgb = CollectionsKt.emptyList();
        }
        if (rgb.size() == 3) {
            try {
                return new Color(Integer.parseInt((String)rgb.get(0)), Integer.parseInt((String)rgb.get(1)), Integer.parseInt((String)rgb.get(2)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @NotNull
    public String getDescription() {
        Object object = this.keyDescriptor;
        if ((object == null || (object = ((RegistryKeyDescriptor)object).getDescription()) == null) && (object = this.resolveNotRequiredValue(this.key + ".description")) == null) {
            object = "";
        }
        return object;
    }

    public boolean isRestartRequired() {
        if (this.keyDescriptor == null) {
            return Boolean.parseBoolean(this.resolveNotRequiredValue(this.key + ".restartRequired"));
        }
        return this.keyDescriptor.isRestartRequired();
    }

    public boolean isChangedFromDefault() {
        String string = this.stringCachedValue;
        if (string == null) {
            string = this.resolveNotRequiredValue(this.key);
        }
        return !Intrinsics.areEqual(string, this.registry.getBundleValueOrNull(this.key));
    }

    @Nullable
    public final String getPluginId() {
        RegistryKeyDescriptor registryKeyDescriptor = this.keyDescriptor;
        return registryKeyDescriptor != null ? registryKeyDescriptor.getPluginId() : null;
    }

    private final String getAsValue(String key) {
        String string;
        if (this.stringCachedValue == null) {
            this.stringCachedValue = this.resolveNotRequiredValue(key);
        }
        String string2 = this.stringCachedValue;
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            string = ((CharSequence)it).length() > 0 ? string3 : null;
        } else {
            string = null;
        }
        return string;
    }

    @ApiStatus.Internal
    @Nullable
    public final String resolveNotRequiredValue(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        ValueWithSource valueWithSource = this.registry.getStoredProperties().get(key);
        if (valueWithSource != null) {
            ValueWithSource it = valueWithSource;
            boolean bl = false;
            return it.getValue();
        }
        String string = System.getProperty(key);
        if (string != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        this.checkIsLoaded(key);
        return this.registry.getBundleValueOrNull(key);
    }

    private final String resolveRequiredValue(String key) throws MissingResourceException {
        ValueWithSource valueWithSource = this.registry.getStoredProperties().get(key);
        if (valueWithSource != null) {
            ValueWithSource it = valueWithSource;
            boolean bl = false;
            return it.getValue();
        }
        String string = System.getProperty(key);
        if (string != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        this.checkIsLoaded(key);
        return this.registry.getBundleValue$intellij_platform_util(key, this.keyDescriptor);
    }

    private final void checkIsLoaded(String key) {
        if (this.registry.isLoaded()) {
            return;
        }
        String message = "Attempt to load key '" + key + "' for not yet loaded registry";
        if (Disposer.isDebugMode()) {
            RegistryValueKt.access$getLOG$p().error(message + ". Use system properties instead of registry values to configure behaviour at early startup stages.");
        } else {
            RegistryValueKt.access$getLOG$p().warn(message);
        }
    }

    public final void setValue(boolean value) {
        this.setValue(String.valueOf(value));
    }

    public final void setValue(int value) {
        this.setValue(String.valueOf(value));
    }

    public void setValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.setValue(value, RegistryValueSource.SYSTEM);
    }

    @ApiStatus.Experimental
    public void setValue(@NotNull String value, @NotNull RegistryValueSource source) {
        Intrinsics.checkNotNullParameter(value, "value");
        Intrinsics.checkNotNullParameter((Object)source, "source");
        RegistryValueListener globalValueChangeListener = this.registry.getValueChangeListener();
        globalValueChangeListener.beforeValueChanged(this);
        for (RegistryValueListener each : this.listeners) {
            each.beforeValueChanged(this);
        }
        this.resetCache$intellij_platform_util();
        this.registry.getStoredProperties().put(this.key, new ValueWithSource(value, source));
        RegistryValueKt.access$getLOG$p().info("Registry value '" + this.key + "' has changed to '" + value + "' by " + source.name());
        globalValueChangeListener.afterValueChanged(this);
        for (RegistryValueListener listener : this.listeners) {
            listener.afterValueChanged(this);
        }
        if (!this.isRestartRequired() && Intrinsics.areEqual(this.resolveNotRequiredValue(this.key), this.registry.getBundleValueOrNull(this.key))) {
            this.registry.getStoredProperties().remove(this.key);
        }
        this.isChangedSinceAppStart = true;
    }

    public final void setValue(boolean value, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(parentDisposable, "parentDisposable");
        boolean prev = this.asBoolean();
        this.setValue(value);
        Disposer.register(parentDisposable, () -> RegistryValue.setValue$lambda$7(this, prev));
    }

    public final void setValue(int value, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(parentDisposable, "parentDisposable");
        int prev = this.asInteger();
        this.setValue(value);
        Disposer.register(parentDisposable, () -> RegistryValue.setValue$lambda$8(this, prev));
    }

    @TestOnly
    public final void setValue(@NotNull String value, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(value, "value");
        Intrinsics.checkNotNullParameter(parentDisposable, "parentDisposable");
        String string = this.stringCachedValue;
        if (string == null) {
            string = this.resolveRequiredValue(this.key);
        }
        String prev = string;
        this.setValue(value);
        Disposer.register(parentDisposable, () -> RegistryValue.setValue$lambda$9(this, prev));
    }

    public final void resetToDefault() {
        String value = this.registry.getBundleValueOrNull(this.key);
        if (value == null) {
            this.registry.getStoredProperties().remove(this.key);
        } else {
            this.setValue(value);
        }
    }

    public final void addListener(@NotNull RegistryValueListener listener, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        Intrinsics.checkNotNullParameter(parent, "parent");
        this.listeners.add(listener);
        Disposer.register(parent, () -> RegistryValue.addListener$lambda$10(this, listener));
    }

    public final void addListener(@NotNull RegistryValueListener listener, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        Intrinsics.checkNotNullParameter(coroutineScope, "coroutineScope");
        this.listeners.add(listener);
        Object e = coroutineScope.getCoroutineContext().get(Job.Key);
        Intrinsics.checkNotNull(e);
        ((Job)e).invokeOnCompletion(arg_0 -> RegistryValue.addListener$lambda$11(this, listener, arg_0));
    }

    public final void resetCache$intellij_platform_util() {
        this.stringCachedValue = null;
        this.intCachedValue = null;
        this.doubleCachedValue = Double.NaN;
        this.booleanCachedValue = null;
    }

    public boolean isBoolean() {
        return RegistryValueKt.access$isBoolean(this.asString());
    }

    @NotNull
    public String toString() {
        return this.key + '=' + this.asString();
    }

    private static final void setValue$lambda$7(RegistryValue this$0, boolean $prev) {
        this$0.setValue($prev);
    }

    private static final void setValue$lambda$8(RegistryValue this$0, int $prev) {
        this$0.setValue($prev);
    }

    private static final void setValue$lambda$9(RegistryValue this$0, String $prev) {
        this$0.setValue($prev);
    }

    private static final void addListener$lambda$10(RegistryValue this$0, RegistryValueListener $listener) {
        this$0.listeners.remove($listener);
    }

    private static final Unit addListener$lambda$11(RegistryValue this$0, RegistryValueListener $listener, Throwable it) {
        this$0.listeners.remove($listener);
        return Unit.INSTANCE;
    }
}

