//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/metal/mtldynamiclibrarydomain?language=objc)
    pub static MTLDynamicLibraryDomain: &'static NSErrorDomain;
}

/// [Apple's documentation](https://developer.apple.com/documentation/metal/mtldynamiclibraryerror?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLDynamicLibraryError(pub NSUInteger);
impl MTLDynamicLibraryError {
    #[doc(alias = "MTLDynamicLibraryErrorNone")]
    pub const None: Self = Self(0);
    #[doc(alias = "MTLDynamicLibraryErrorInvalidFile")]
    pub const InvalidFile: Self = Self(1);
    #[doc(alias = "MTLDynamicLibraryErrorCompilationFailure")]
    pub const CompilationFailure: Self = Self(2);
    #[doc(alias = "MTLDynamicLibraryErrorUnresolvedInstallName")]
    pub const UnresolvedInstallName: Self = Self(3);
    #[doc(alias = "MTLDynamicLibraryErrorDependencyLoadFailure")]
    pub const DependencyLoadFailure: Self = Self(4);
    #[doc(alias = "MTLDynamicLibraryErrorUnsupported")]
    pub const Unsupported: Self = Self(5);
}

unsafe impl Encode for MTLDynamicLibraryError {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLDynamicLibraryError {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_protocol!(
    /// A container for the binary representation of code compiled for a MTLDevice.
    ///
    /// MTLDynamicLibrary can be created in two ways:
    /// 1) MTLDevice newDynamicLibrary:error:
    /// This method takes an MTLLibrary (which has .type set to MTLLibraryTypeDynamic) and then compiles the code in the MTLLibrary for the current device.
    /// 2) MTLDevice newDynamicLibraryWithURL:error
    /// This method loads from a file a previously serialized MTLDynamicLibrary. If the dynamic library containg compiled code for the current device, that code is loaded.
    /// Otherwise, as a fallback, the MTLLibrary contents used to create the MTLDynamicLibrary are compiled for the current device similar to path #1 above.
    /// This path may also be taken if the driver for the current device has been updated or has otherwise become incompatible with the compiled code.
    /// Either way, if a MTLDynamicLibrary is successfully created, it contains compiled code for the current device.
    /// That code may be used via MTLComputePipelineDescriptor .preloadedLibraries to allow the code to be loaded into a MTLComputePipelineState
    /// It may also be used as an argument to MTLCompileOptions .libraries so that another MTLLibrary is linked against the code in this MTLDynamicLibrary.
    /// Such library dependencies are encoded into the resulting MTLLibrary by embedding the install name of the MTLDynamicLibrary.
    /// When creating a MTLComputePipelineState from a function in that MTLLibrary, the embedded install names are used to load MTLDynamicLibrary instances via path #2 (possibly falling back to #1 as well).
    /// If an embedded install name could not be used to load a MTLDynamicLibrary from the path indicated by the install name, the creation of the MTLComputePipelineState fails.
    /// The set of both the implictly loaded MTLDynamicLibrary and the MTLDynamicLibrary specified with .preloadedLibraries are used to resolve any unresolved symbols in the source MTLLibrary (or in other MTLDynamicLibrary).
    /// If any unresolved symbols remain after searching the set, the creation of the MTLComputePipelineState fails.
    /// Otherwise, the MTLComputePipelineState creation succeeds, and the set of MTLDynamicLibraries used are retained by the MTLComputePipelineState.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtldynamiclibrary?language=objc)
    pub unsafe trait MTLDynamicLibrary: NSObjectProtocol {
        /// A string to help identify this object.
        #[unsafe(method(label))]
        #[unsafe(method_family = none)]
        fn label(&self) -> Option<Retained<NSString>>;

        /// Setter for [`label`][Self::label].
        #[unsafe(method(setLabel:))]
        #[unsafe(method_family = none)]
        fn setLabel(&self, label: Option<&NSString>);

        #[cfg(feature = "MTLDevice")]
        /// The device this resource was created against.  This resource can only be used with this device.
        #[unsafe(method(device))]
        #[unsafe(method_family = none)]
        fn device(&self) -> Retained<ProtocolObject<dyn MTLDevice>>;

        /// The installName of this dynamic library. Can not be nil.
        #[unsafe(method(installName))]
        #[unsafe(method_family = none)]
        fn installName(&self) -> Retained<NSString>;

        /// Writes the contents of the MTLDynamicLibrary to a file.
        ///
        /// On success, the file will contain a representation of the MTLLibrary from which the MTLDynamicLibrary was originally created, as well as the compiled code for the current device.
        /// Such files may be combined with offline tools to contain the compiled code for multiple devices.
        /// If this MTLDynamicLibrary was created from a file that contained compiled code for multiple devices, the compiled code for all other devices is not written (since only compiled code for the current device was loaded).
        ///
        /// Parameter `url`: The file URL to which to write the content of the dynamic library. It the URL does not refer to a file, the function fails.
        ///
        /// Parameter `error`: If the function fails, this will be set to describe the failure. This can be (but is not required to be) an error from the MTLDynamicLibraryDomain domain. Other possible errors can be file access or I/O related.
        ///
        /// Returns: Whether or not the writing the file succeeded.
        #[unsafe(method(serializeToURL:error:_))]
        #[unsafe(method_family = none)]
        fn serializeToURL_error(&self, url: &NSURL) -> Result<(), Retained<NSError>>;
    }
);
