// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// HashicorpCloudBoundary20211221CreateRequest CreateRequest is a request to create a single HCP Boundary cluster.
//
// swagger:model hashicorp.cloud.boundary_20211221.CreateRequest
type HashicorpCloudBoundary20211221CreateRequest struct {

	// boundary_release is the boundary version to deploy
	BoundaryRelease string `json:"boundary_release,omitempty"`

	// cluster_id is the id of the cluster set by user on creation.
	ClusterID string `json:"cluster_id,omitempty"`

	// controller_config contains controller-specific configuration values to apply to the cluster's
	// controllers on creation.
	ControllerConfig *HashicorpCloudBoundary20211221ControllerConfiguration `json:"controller_config,omitempty"`

	// enable_hcp_auth determines whether the cluster is preconfigured with HCP Oauth as an
	// authentication method.
	EnableHcpAuth bool `json:"enable_hcp_auth,omitempty"`

	// location is the location of the cluster.
	Location *cloud.HashicorpCloudLocationLocation `json:"location,omitempty"`

	// marketing_sku is the marketing sku of the cluster [standard, plus]
	MarketingSku *HashicorpCloudBoundary20211221ClusterMarketingSKU `json:"marketing_sku,omitempty"`

	// password is the initial password to use to setup initial login
	Password string `json:"password,omitempty"`

	// username is the admin username to setup for initial login
	Username string `json:"username,omitempty"`
}

// Validate validates this hashicorp cloud boundary 20211221 create request
func (m *HashicorpCloudBoundary20211221CreateRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateControllerConfig(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMarketingSku(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudBoundary20211221CreateRequest) validateControllerConfig(formats strfmt.Registry) error {
	if swag.IsZero(m.ControllerConfig) { // not required
		return nil
	}

	if m.ControllerConfig != nil {
		if err := m.ControllerConfig.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller_config")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("controller_config")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudBoundary20211221CreateRequest) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(m.Location) { // not required
		return nil
	}

	if m.Location != nil {
		if err := m.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("location")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudBoundary20211221CreateRequest) validateMarketingSku(formats strfmt.Registry) error {
	if swag.IsZero(m.MarketingSku) { // not required
		return nil
	}

	if m.MarketingSku != nil {
		if err := m.MarketingSku.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("marketing_sku")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("marketing_sku")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp cloud boundary 20211221 create request based on the context it is used
func (m *HashicorpCloudBoundary20211221CreateRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateControllerConfig(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMarketingSku(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudBoundary20211221CreateRequest) contextValidateControllerConfig(ctx context.Context, formats strfmt.Registry) error {

	if m.ControllerConfig != nil {

		if swag.IsZero(m.ControllerConfig) { // not required
			return nil
		}

		if err := m.ControllerConfig.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller_config")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("controller_config")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudBoundary20211221CreateRequest) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if m.Location != nil {

		if swag.IsZero(m.Location) { // not required
			return nil
		}

		if err := m.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("location")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudBoundary20211221CreateRequest) contextValidateMarketingSku(ctx context.Context, formats strfmt.Registry) error {

	if m.MarketingSku != nil {

		if swag.IsZero(m.MarketingSku) { // not required
			return nil
		}

		if err := m.MarketingSku.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("marketing_sku")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("marketing_sku")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudBoundary20211221CreateRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudBoundary20211221CreateRequest) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudBoundary20211221CreateRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
