// Code generated by go-swagger; DO NOT EDIT.

package boundary_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-boundary-service/stable/2021-12-21/models"
)

// NewBoundaryServiceCreateParams creates a new BoundaryServiceCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewBoundaryServiceCreateParams() *BoundaryServiceCreateParams {
	return &BoundaryServiceCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewBoundaryServiceCreateParamsWithTimeout creates a new BoundaryServiceCreateParams object
// with the ability to set a timeout on a request.
func NewBoundaryServiceCreateParamsWithTimeout(timeout time.Duration) *BoundaryServiceCreateParams {
	return &BoundaryServiceCreateParams{
		timeout: timeout,
	}
}

// NewBoundaryServiceCreateParamsWithContext creates a new BoundaryServiceCreateParams object
// with the ability to set a context for a request.
func NewBoundaryServiceCreateParamsWithContext(ctx context.Context) *BoundaryServiceCreateParams {
	return &BoundaryServiceCreateParams{
		Context: ctx,
	}
}

// NewBoundaryServiceCreateParamsWithHTTPClient creates a new BoundaryServiceCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewBoundaryServiceCreateParamsWithHTTPClient(client *http.Client) *BoundaryServiceCreateParams {
	return &BoundaryServiceCreateParams{
		HTTPClient: client,
	}
}

/*
BoundaryServiceCreateParams contains all the parameters to send to the API endpoint

	for the boundary service create operation.

	Typically these are written to a http.Request.
*/
type BoundaryServiceCreateParams struct {

	// Body.
	Body *models.HashicorpCloudBoundary20211221CreateRequest

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the boundary service create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BoundaryServiceCreateParams) WithDefaults() *BoundaryServiceCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the boundary service create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BoundaryServiceCreateParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the boundary service create params
func (o *BoundaryServiceCreateParams) WithTimeout(timeout time.Duration) *BoundaryServiceCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the boundary service create params
func (o *BoundaryServiceCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the boundary service create params
func (o *BoundaryServiceCreateParams) WithContext(ctx context.Context) *BoundaryServiceCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the boundary service create params
func (o *BoundaryServiceCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the boundary service create params
func (o *BoundaryServiceCreateParams) WithHTTPClient(client *http.Client) *BoundaryServiceCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the boundary service create params
func (o *BoundaryServiceCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the boundary service create params
func (o *BoundaryServiceCreateParams) WithBody(body *models.HashicorpCloudBoundary20211221CreateRequest) *BoundaryServiceCreateParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the boundary service create params
func (o *BoundaryServiceCreateParams) SetBody(body *models.HashicorpCloudBoundary20211221CreateRequest) {
	o.Body = body
}

// WithLocationOrganizationID adds the locationOrganizationID to the boundary service create params
func (o *BoundaryServiceCreateParams) WithLocationOrganizationID(locationOrganizationID string) *BoundaryServiceCreateParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the boundary service create params
func (o *BoundaryServiceCreateParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the boundary service create params
func (o *BoundaryServiceCreateParams) WithLocationProjectID(locationProjectID string) *BoundaryServiceCreateParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the boundary service create params
func (o *BoundaryServiceCreateParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WriteToRequest writes these params to a swagger request
func (o *BoundaryServiceCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
